/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest;

import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.EngineType;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.SeleniumDriver;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.utils.HolmosBaseUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;

public class Allocator {
    private List<BrowserWindow> windows;
    private String screenShotDir = HolmosBaseUtils.getScreenShotDirPath();
    private static volatile Allocator allocator;
    public BrowserWindow currentWindow;

    public String getScreenShotDir() {
        return this.screenShotDir;
    }

    public List<BrowserWindow> getWindows() {
        return this.windows;
    }

    private Allocator() {
        HolmosBaseUtils.configScreenShotLocation();
        this.windows = new ArrayList<BrowserWindow>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Allocator getInstance() {
        if (allocator != null) return allocator;
        Class<Allocator> clazz = Allocator.class;
        synchronized (Allocator.class) {
            if (allocator != null) return allocator;
            allocator = new Allocator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return allocator;
        }
    }

    public void distroy() {
        this.currentWindow = null;
        this.closeAllWindows();
    }

    public void closeAllWindows() {
        for (BrowserWindow window : this.windows) {
            try {
                window.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.windows.clear();
    }

    public boolean closeWindowByUrl(String url) {
        for (BrowserWindow window : this.windows) {
            if (!window.getUrl().equalsIgnoreCase(url)) continue;
            window.close();
            this.windows.remove(window);
            if (this.currentWindow.equals(window)) {
                if (this.windows.size() == 0) {
                    this.currentWindow = null;
                } else {
                    this.currentWindow = this.windows.get(0);
                    this.currentWindow.focus();
                }
            }
            return true;
        }
        return false;
    }

    public boolean closeAllWindowsByUrl(String url) {
        boolean findWindow = false;
        for (BrowserWindow window : this.windows) {
            if (window.getUrl().equalsIgnoreCase(url)) {
                window.close();
                this.windows.remove(window);
                if (this.currentWindow.equals(window)) {
                    this.currentWindow = this.windows.size() == 0 ? null : this.windows.get(0);
                }
            }
            findWindow = true;
        }
        return findWindow;
    }

    public void updateWindows() {
        int i = 0;
        for (String handle : ((WebDriver)this.currentWindow.getDriver().getEngine()).getWindowHandles()) {
            i = 0;
            while (i < this.windows.size()) {
                if (handle.equalsIgnoreCase(this.windows.get(i).getHandle())) break;
                ++i;
            }
            if (i < this.windows.size()) continue;
            WebDriverBrowserWindow webDriverBrowserWindow = new WebDriverBrowserWindow(this.currentWindow.getDriver());
            webDriverBrowserWindow.setWidowHandle(handle);
            this.windows.add(webDriverBrowserWindow);
        }
    }

    public void attach(String url) {
        for (BrowserWindow window : this.windows) {
            if (window.getUrl().equalsIgnoreCase(url)) break;
        }
    }

    public void attachByContains(String url) {
        for (BrowserWindow window : this.windows) {
            if (window.getUrl().contains(url)) break;
        }
    }

    public void attachByRegular(String url) {
        Pattern pattern = Pattern.compile(url);
        for (BrowserWindow window : this.windows) {
            if (pattern.matcher(window.getUrl()).matches()) break;
        }
    }

    public void addBrowserWindow() {
        this.addWebDriverIEBrowserWindow();
    }

    public void addBrowserWindow(EngineType engineType, String url) {
        switch (engineType) {
            case WebDriverIE: 
            case WebDriverFirefox: 
            case WebDriverChrome: 
            case WebDriverSafari: 
            case WebDriverAndroid: 
            case WebDriverIphone: 
            case HtmlUnit: {
                this.addWebDriverBrowserWindow(engineType);
                break;
            }
            case SeleniumIE: 
            case SeleniumFirefox: 
            case SeleniumChrome: 
            case SeleniumSafari: 
            case SeleniumOpera: {
                this.addSeleniumBrowserWindow(engineType, url);
                break;
            }
        }
    }

    public void addWebDriverIEBrowserWindow() {
        WebDriverBrowserWindow window = new WebDriverBrowserWindow(SeleniumDriver.createWebDriverIEEngine());
        this.windows.add(window);
    }

    public void addWebDriverFirefoxBrowserWindow() {
        WebDriverBrowserWindow window = new WebDriverBrowserWindow(SeleniumDriver.createWebDriverFireFoxEngine());
        this.windows.add(window);
    }

    public void addWebDriverChromeBrowserWindow() {
        WebDriverBrowserWindow window = new WebDriverBrowserWindow(SeleniumDriver.createWebDriverChromeEngine());
        this.windows.add(window);
    }

    public void addWebDriverSafariBrowserWindow() {
        WebDriverBrowserWindow window = new WebDriverBrowserWindow(SeleniumDriver.createWebDriverSafariEngine());
        this.windows.add(window);
    }

    public void addWebDriverIphoneBrowserWindow() {
        WebDriverBrowserWindow window = new WebDriverBrowserWindow(SeleniumDriver.createWebDriverIphoneEngine());
        this.windows.add(window);
    }

    public void addWebDriverAndroidBrowserWindow() {
        WebDriverBrowserWindow window = new WebDriverBrowserWindow(SeleniumDriver.createWebDriverAndroidEngine());
        this.windows.add(window);
    }

    private void addHtmlUnitDriverBrowserWindow() {
        WebDriverBrowserWindow window = new WebDriverBrowserWindow(SeleniumDriver.createWebDriverHtmlUnitEngine());
        this.windows.add(window);
    }

    public void addSeleniumFirefoxBrowswerWindow(String url) {
        SeleniumBrowserWindow window = new SeleniumBrowserWindow(SeleniumDriver.createSeleniumFireFoxEngine(url));
        this.windows.add(window);
    }

    public void addSeleniumChromeBrowswerWindow(String url) {
        SeleniumBrowserWindow window = new SeleniumBrowserWindow(SeleniumDriver.createSeleniumChromeEngine(url));
        this.windows.add(window);
    }

    public void addSeleniumSafariBrowswerWindow(String url) {
        SeleniumBrowserWindow window = new SeleniumBrowserWindow(SeleniumDriver.createSeleniumSafariEngine(url));
        this.windows.add(window);
    }

    public void addSeleniumOperaBrowswerWindow(String url) {
        SeleniumBrowserWindow window = new SeleniumBrowserWindow(SeleniumDriver.createSeleniumOperaEngine(url));
        this.windows.add(window);
    }

    public void addSeleniumIEBrowswerWindow(String url) {
        SeleniumBrowserWindow window = new SeleniumBrowserWindow(SeleniumDriver.createSeleniumIEEngine(url));
        this.windows.add(window);
    }

    private void addFFBrowserWindowWithProfile(String url, FirefoxProfile profile) {
        WebDriverBrowserWindow window = new WebDriverBrowserWindow(SeleniumDriver.createWebDriverFireFoxEngineWithProfile(profile));
        this.windows.add(window);
    }

    public void addWebDriverBrowserWindow(EngineType engineType) {
        switch (engineType) {
            case WebDriverIE: {
                this.addWebDriverIEBrowserWindow();
                break;
            }
            case WebDriverFirefox: {
                this.addWebDriverFirefoxBrowserWindow();
                break;
            }
            case WebDriverChrome: {
                this.addWebDriverChromeBrowserWindow();
                break;
            }
            case WebDriverSafari: {
                this.addWebDriverSafariBrowserWindow();
            }
            case WebDriverIphone: {
                this.addWebDriverIphoneBrowserWindow();
                break;
            }
            case WebDriverAndroid: {
                this.addWebDriverAndroidBrowserWindow();
                break;
            }
            case HtmlUnit: {
                this.addHtmlUnitDriverBrowserWindow();
            }
        }
    }

    public void addSeleniumBrowserWindow(EngineType engineType, String url) {
        switch (engineType) {
            case SeleniumIE: {
                this.addSeleniumIEBrowswerWindow(url);
                break;
            }
            case SeleniumFirefox: {
                this.addSeleniumFirefoxBrowswerWindow(url);
                break;
            }
            case SeleniumChrome: {
                this.addSeleniumChromeBrowswerWindow(url);
                break;
            }
            case SeleniumSafari: {
                this.addSeleniumSafariBrowswerWindow(url);
                break;
            }
            case SeleniumOpera: {
                this.addSeleniumOperaBrowswerWindow(url);
            }
        }
    }

    public void addAndSetBrowserWindow(EngineType engineType, String url) {
        this.addBrowserWindow(engineType, url);
        this.currentWindow = this.windows.get(this.windows.size() - 1);
    }

    public void addAndSetFFBrowserWindowWithProfile(String url, FirefoxProfile profile) {
        this.addFFBrowserWindowWithProfile(url, profile);
        this.currentWindow = this.windows.get(this.windows.size() - 1);
    }

    public void attachByTiltle(String title) {
        for (BrowserWindow window : this.windows) {
            if (window.getTitle().equalsIgnoreCase(title)) break;
        }
    }

    public void attachByContainTitle(String partTitle) {
        for (BrowserWindow window : this.windows) {
            if (window.getTitle().contains(partTitle)) break;
        }
    }

    public void attachByRegularTitle(String regularTitle) {
        Pattern pattern = Pattern.compile(regularTitle);
        for (BrowserWindow window : this.windows) {
            if (pattern.matcher(window.getTitle()).matches()) break;
        }
    }
}

