/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.EngineType;
import com.holmos.webtest.SeleniumBrowserWindowHandleProductor;
import com.holmos.webtest.SeleniumDriver;
import com.holmos.webtest.utils.HolmosBaseUtils;
import com.holmos.webtest.utils.HolmosWindow;
import com.thoughtworks.selenium.Selenium;
import java.util.Set;
import org.openqa.selenium.Cookie;

public class SeleniumBrowserWindow
implements BrowserWindow {
    private String windowHandle;
    private EngineType engineType;
    private boolean isLoaded;
    private SeleniumDriver driver;

    static {
        HolmosBaseUtils.configLogProperties();
    }

    public SeleniumBrowserWindow(SeleniumDriver driver) {
        this.driver = driver;
        this.engineType = driver.getType();
    }

    @Override
    public String getHandle() {
        if (this.windowHandle == null) {
            this.windowHandle = SeleniumBrowserWindowHandleProductor.getInstance().productHandle();
        }
        return this.windowHandle;
    }

    public void setWindowHandle(String windowHandle) {
        this.windowHandle = windowHandle;
    }

    public void setDriver(SeleniumDriver driver) {
        this.driver = driver;
    }

    @Override
    public SeleniumDriver getDriver() {
        return this.driver;
    }

    @Override
    public String getUrl() {
        return ((Selenium)this.driver.getEngine()).getLocation();
    }

    @Override
    public void refresh() {
        ((Selenium)this.driver.getEngine()).refresh();
    }

    @Override
    public void close() {
        ((Selenium)this.driver.getEngine()).close();
        ((Selenium)this.driver.getEngine()).stop();
    }

    @Override
    public void goForward() {
        ((Selenium)this.driver.getEngine()).runScript("window.history.forward();");
    }

    @Override
    public void goBack() {
        ((Selenium)this.driver.getEngine()).goBack();
    }

    @Override
    public EngineType getEngineType() {
        return this.engineType;
    }

    @Override
    public void openNewWindow(String url) {
        this.start();
        this.open(url);
    }

    @Override
    public void open(String url) {
        this.focus();
        ((Selenium)this.driver.getEngine()).open(url);
    }

    @Override
    public void focus() {
        if (Allocator.getInstance().currentWindow.equals(this)) {
            return;
        }
        for (BrowserWindow window : Allocator.getInstance().getWindows()) {
            if (!((SeleniumBrowserWindow)window).getHandle().equalsIgnoreCase(this.windowHandle)) continue;
            Allocator.getInstance().currentWindow = this;
            ((Selenium)this.getDriver().getEngine()).windowFocus();
        }
    }

    @Override
    public void maxSizeWindow() {
        this.focus();
        ((Selenium)this.driver.getEngine()).windowMaximize();
    }

    @Override
    public void moveWindowTo(int xLocation, int yLocation) {
        this.focus();
        StringBuilder message = new StringBuilder("\u79fb\u52a8\u7a97\u53e3\u4f4d\u7f6e");
        if (xLocation >= 0 && yLocation >= 0) {
            message.append("x:" + xLocation + "  y:" + yLocation);
            String script = "window.moveTo(" + xLocation + "," + yLocation + ")";
            HolmosWindow.runJavaScript(script);
            logger.info(message);
        } else {
            message.append("\u7a97\u53e3\u4f4d\u7f6e\u8bbe\u7f6e\u9519\u8bef\uff01");
            logger.error(message);
        }
    }

    @Override
    public void resizeTo(int horizonSize, int verticalSize) {
        this.focus();
        StringBuilder message = new StringBuilder("\u7a97\u53e3\u91cd\u65b0\u8bbe\u7f6e\u5927\u5c0f");
        if (horizonSize >= 0 && verticalSize >= 0) {
            message.append("\u5bbd\u5ea6:" + horizonSize + "  \u9ad8\u5ea6:" + verticalSize);
            String script = "window.resizeTo(" + horizonSize + "," + verticalSize + ")";
            HolmosWindow.runJavaScript(script);
            logger.info(message);
        } else {
            message.append("\u7a97\u53e3\u5927\u5c0f\u8bbe\u7f6e\u9519\u8bef\uff01");
            logger.error(message);
        }
    }

    @Override
    public void start() {
        ((Selenium)this.getDriver().getEngine()).start();
        ((Selenium)this.driver.getEngine()).useXpathLibrary("javascript-xpath");
    }

    @Override
    public String dealAlert() {
        this.focus();
        try {
            return ((Selenium)this.getDriver().getEngine()).getAlert();
        }
        catch (Exception e) {
            logger.error("\u6ca1\u6709\u627e\u5230Alert\u7a97\u53e3!");
            return null;
        }
    }

    @Override
    public String dealPrompt(String input, boolean isYes) {
        this.focus();
        try {
            ((Selenium)this.getDriver().getEngine()).answerOnNextPrompt(input);
            return ((Selenium)this.getDriver().getEngine()).getPrompt();
        }
        catch (Exception e) {
            logger.error("\u6ca1\u6709\u627e\u5230Prompt\u7a97\u53e3!");
            return null;
        }
    }

    @Override
    public String dealConfirm(boolean isYes) {
        this.focus();
        try {
            if (isYes) {
                ((Selenium)this.getDriver().getEngine()).chooseOkOnNextConfirmation();
                return ((Selenium)this.getDriver().getEngine()).getConfirmation();
            }
            ((Selenium)this.getDriver().getEngine()).chooseCancelOnNextConfirmation();
            return ((Selenium)this.getDriver().getEngine()).getConfirmation();
        }
        catch (Exception e) {
            logger.error("\u6ca1\u6709\u627e\u5230Prompt\u7a97\u53e3!");
            return null;
        }
    }

    @Override
    public void quit() {
    }

    @Override
    public void TakeScreenshot(String fileName) {
        ((Selenium)this.getDriver().getEngine()).captureEntirePageScreenshot(String.valueOf(Allocator.getInstance().getScreenShotDir()) + fileName, "");
    }

    @Override
    public void addCookie(Cookie cookie) {
    }

    @Override
    public Set<Cookie> getAllCookies() {
        return null;
    }

    @Override
    public Cookie getCookieByName(String name) {
        return null;
    }

    @Override
    public void removeCookieByName(String name) {
    }

    @Override
    public void removeAllCookies() {
    }

    @Override
    public String getTitle() {
        return ((Selenium)this.getDriver().getEngine()).getTitle();
    }

    @Override
    public void setHandle(String handle) {
        this.windowHandle = handle;
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }
}

