/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.element.Element;
import com.holmos.webtest.element.property.Location;
import com.holmos.webtest.exceptions.HolmosFailedError;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class Table
extends Element {
    public Table(String comment) {
        super(comment);
    }

    public String getElementContent(int row, int col) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        String content = null;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                try {
                    content = ((Selenium)currentWindow.getDriver().getEngine()).getTable(String.valueOf(this.locator.getSeleniumCurrentLocator()) + "." + row + "." + col);
                    message.append("\u7b2c" + row + "\u884c\uff0c\u7b2c" + col + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u6210\u529f!");
                    this.logger.info(message);
                }
                catch (Exception e) {
                    message.append("\u7b2c" + row + "\u884c\uff0c\u7b2c" + col + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u5931\u8d25!\u627e\u4e0d\u5230\u8fd9\u4e2atable\u7684\u8fd9\u4e2a\u5143\u7d20");
                    this.logger.error(message);
                }
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                try {
                    WebElement trElement = (WebElement)this.element.findElements(By.tagName((String)"tr")).get(row - 1);
                    WebElement tdElement = (WebElement)trElement.findElements(By.tagName((String)"td")).get(col - 1);
                    content = tdElement.getText();
                    message.append("\u7b2c" + row + "\u884c\uff0c\u7b2c" + col + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u6210\u529f!");
                    this.logger.info(message);
                }
                catch (Exception e) {
                    message.append("\u7b2c" + row + "\u884c\uff0c\u7b2c" + col + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u5931\u8d25!\u627e\u4e0d\u5230\u8fd9\u4e2atable\u7684\u8fd9\u4e2a\u5143\u7d20");
                    this.logger.error(message);
                }
            }
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u7b2c" + row + "\u884c\uff0c\u7b2c" + col + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u5931\u8d25!\u627e\u4e0d\u5230\u8fd9\u4e2atable");
            this.logger.error(message);
        }
        return content;
    }

    public List<String> getElementsContentByColumn(int column) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        ArrayList<String> contents = new ArrayList<String>();
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                try {
                    int rowCount = 0;
                    while (true) {
                        contents.add(((Selenium)currentWindow.getDriver().getEngine()).getTable(String.valueOf(this.locator.getSeleniumCurrentLocator()) + "." + rowCount + "." + column));
                        ++rowCount;
                    }
                }
                catch (SeleniumException rowCount) {}
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                List cells = this.element.findElements(By.xpath((String)(".//td[" + column + "]")));
                for (WebElement cell : cells) {
                    contents.add(cell.getText());
                }
            }
            message.append("\u7b2c" + column + "\u5217\u7684\u5143\u7d20\u7684\u4fe1\u606f\u83b7\u5f97\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u7b2c" + column + "\u5217\u7684\u5143\u7d20\u7684\u4fe1\u606f\u83b7\u5f97\u5931\u8d25!\u627e\u4e0d\u5230\u8be5table!");
            this.logger.error(message);
        }
        return contents;
    }

    public List<List<String>> getElementsContentByColumns(int[] columns) {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        System.out.println("\u5f00\u59cb\u83b7\u5f97\u82e5\u5e72\u5217\u7684\u5143\u7d20\u5185\u5bb9");
        int i = 0;
        while (i < columns.length) {
            contents.add(this.getElementsContentByColumn(columns[i]));
            ++i;
        }
        return contents;
    }

    public List<String> getElementsContentByRow(int row) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        ArrayList<String> contents = new ArrayList<String>();
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                try {
                    int colCount = 0;
                    while (true) {
                        contents.add(((Selenium)currentWindow.getDriver().getEngine()).getTable(String.valueOf(this.locator.getSeleniumCurrentLocator()) + "." + row + "." + colCount));
                        ++colCount;
                    }
                }
                catch (SeleniumException colCount) {}
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                WebElement rowCell = this.element.findElement(By.xpath((String)(".//tr[" + row + "]")));
                List cells = rowCell.findElements(By.xpath((String)".//td"));
                for (WebElement cell : cells) {
                    contents.add(cell.getText());
                }
            }
            message.append("\u7b2c" + row + "\u884c\u7684\u5143\u7d20\u7684\u4fe1\u606f\u83b7\u5f97\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u7b2c" + row + "\u884c\u7684\u5143\u7d20\u7684\u4fe1\u606f\u83b7\u5f97\u5931\u8d25!\u627e\u4e0d\u5230\u8be5table!");
            this.logger.error(message);
        }
        return contents;
    }

    public List<List<String>> getElementsContentByRows(int[] rows) {
        StringBuilder message = new StringBuilder();
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        message.append("\u5f00\u59cb\u83b7\u5f97\u82e5\u5e72\u884c\u7684\u5143\u7d20\u5185\u5bb9");
        this.logger.info(message);
        int i = 0;
        while (i < rows.length) {
            contents.add(this.getElementsContentByRow(rows[i]));
            ++i;
        }
        return contents;
    }

    public List<String> getElementsContentByLocations(Location[] locations) {
        StringBuilder message = new StringBuilder();
        ArrayList<String> contents = new ArrayList<String>();
        message.append("\u5f00\u59cb\u83b7\u5f97\u82e5\u5e72\u884c\u7684\u5143\u7d20\u5185\u5bb9");
        this.logger.info(message);
        int i = 0;
        while (i < locations.length) {
            contents.add(this.getElementContent(locations[i].getxLocation(), locations[i].getyLocation()));
            ++i;
        }
        return contents;
    }

    public List<List<String>> getAllElementsContent() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        message.append("\u5f00\u59cb\u83b7\u5f97\u6240\u6709\u5143\u7d20\u7684\u5185\u5bb9");
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            int rowCount = 0;
            if (currentWindow instanceof SeleniumBrowserWindow) {
                try {
                    while (true) {
                        ((Selenium)currentWindow.getDriver().getEngine()).getTable(String.valueOf(this.locator.getSeleniumCurrentLocator()) + "." + rowCount + "." + 0);
                        contents.add(this.getElementsContentByRow(rowCount));
                        ++rowCount;
                    }
                }
                catch (SeleniumException seleniumException) {}
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                while (this.element.findElements(By.xpath((String)(".//tr[" + rowCount + "]"))).size() != 0) {
                    contents.add(this.getElementsContentByRow(rowCount));
                    ++rowCount;
                }
            }
        }
        return contents;
    }

    public WebElement getElement(int row, int col) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            if (currentWindow instanceof SeleniumBrowserWindow) {
                throw new HolmosFailedError("RC\u4e0d\u652f\u6301");
            }
            if (currentWindow instanceof WebDriverBrowserWindow) {
                return this.element.findElement(By.xpath((String)("./tr[" + row + "]/td[" + col + "]")));
            }
        } else {
            message.append("\u7b2c" + (row + 1) + "\u884c\uff0c\u7b2c" + (col + 1) + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u5931\u8d25!,\u627e\u4e0d\u5230\u8fd9\u4e2atable");
            this.logger.error(message);
        }
        return null;
    }

    public List<WebElement> getElementsByColumn(int column) {
        List<ArrayList<WebElement>> allElements = this.getAllElements();
        ArrayList<WebElement> cElement = new ArrayList<WebElement>();
        int row = 0;
        while (row < allElements.size()) {
            cElement.add(allElements.get(row).get(column - 1));
            ++row;
        }
        return cElement;
    }

    public List<ArrayList<WebElement>> getElementsByColumns(int[] columns) {
        List<ArrayList<WebElement>> elements = this.getAllElements();
        List<ArrayList<WebElement>> allElements = this.getAllElements();
        int[] nArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            int column = nArray[n2];
            ArrayList<WebElement> cElement = new ArrayList<WebElement>();
            int row = 0;
            while (row < allElements.size()) {
                cElement.add(allElements.get(row).get(column - 1));
                ++row;
            }
            elements.add(cElement);
            ++n2;
        }
        return elements;
    }

    public List<WebElement> getElementsByRow(int row) {
        StringBuilder message = new StringBuilder();
        ArrayList elements = new ArrayList();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            if (currentWindow instanceof SeleniumBrowserWindow) {
                throw new HolmosFailedError("RC\u4e0d\u652f\u6301");
            }
            if (currentWindow instanceof WebDriverBrowserWindow) {
                elements = (ArrayList)this.element.findElements(By.xpath((String)("./tr[" + row + "]")));
            }
        } else {
            this.logger.error(message);
        }
        return elements;
    }

    public List<ArrayList<WebElement>> getElementsByRows(int[] rows) {
        List<ArrayList<WebElement>> elements = this.getAllElements();
        List<ArrayList<WebElement>> allElements = this.getAllElements();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            elements.add(allElements.get(row));
            ++n2;
        }
        return elements;
    }

    public List<WebElement> getElementsByLocations(Location[] locations) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        List<ArrayList<WebElement>> allElements = this.getAllElements();
        Location[] locationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            Location location = locationArray[n2];
            elements.add(allElements.get(location.getxLocation()).get(location.getyLocation()));
            ++n2;
        }
        return elements;
    }

    public List<ArrayList<WebElement>> getAllElements() {
        StringBuilder message = new StringBuilder();
        ArrayList<ArrayList<WebElement>> elements = new ArrayList<ArrayList<WebElement>>();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            if (currentWindow instanceof SeleniumBrowserWindow) {
                throw new HolmosFailedError("RC\u4e0d\u652f\u6301");
            }
            if (currentWindow instanceof WebDriverBrowserWindow) {
                for (WebElement rowElement : this.element.findElements(By.xpath((String)"./tr"))) {
                    elements.add((ArrayList)rowElement.findElements(By.xpath((String)"./td")));
                }
            }
        } else {
            this.logger.error(message);
        }
        return elements;
    }

    public int getRowCount() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        int rowCount = 0;
        if (this.isExist()) {
            if (currentWindow instanceof SeleniumBrowserWindow) {
                throw new HolmosFailedError("RC\u4e0d\u652f\u6301");
            }
            if (currentWindow instanceof WebDriverBrowserWindow) {
                rowCount = this.element.findElements(By.xpath((String)"./tr")).size();
            }
        } else {
            this.logger.error(message);
        }
        return rowCount;
    }

    public int getColumnCount(int row) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        int columnCount = 0;
        if (this.isExist()) {
            if (currentWindow instanceof SeleniumBrowserWindow) {
                throw new HolmosFailedError("RC\u4e0d\u652f\u6301");
            }
            if (currentWindow instanceof WebDriverBrowserWindow) {
                columnCount = this.element.findElements(By.xpath((String)("./tr[" + row + "]/td"))).size();
            }
        } else {
            this.logger.error(message);
        }
        return columnCount;
    }
}

