/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.junitextentions.parameters.ParameterFrameWorkMethod;
import com.holmos.webtest.junitextentions.threadpool.HolmosThreadPoolExecutor;
import com.holmos.webtest.utils.HolmosTypeCastUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public final class RunCountFrameWorkMethod {
    private FrameworkMethod method;
    private int index;
    private int parameterThreadpoolSize;
    private ArrayList<ParameterFrameWorkMethod> parameterFrameWorkMethods;
    private ArrayList<Object[]> parameters;
    private ArrayList<Object[]> resultValues;

    public RunCountFrameWorkMethod(FrameworkMethod method, int index, ArrayList<Object[]> parameters, ArrayList<Object[]> resultValues, int parameterThreadpoolSize) {
        this.method = method;
        this.index = index;
        this.parameters = parameters;
        this.resultValues = resultValues;
        this.parameterThreadpoolSize = parameterThreadpoolSize;
    }

    public ArrayList<ParameterFrameWorkMethod> getParameterFrameWorkMethods() {
        if (this.parameterFrameWorkMethods == null) {
            this.parameters = this.convertParametersType();
            this.parameterFrameWorkMethods = new ArrayList();
            if (this.parameters == null || this.parameters.size() == 0) {
                this.parameterFrameWorkMethods.add(new ParameterFrameWorkMethod(this.method.getMethod(), null, null, this.index));
            } else {
                int i = 0;
                while (i < this.parameters.size()) {
                    this.parameterFrameWorkMethods.add(new ParameterFrameWorkMethod(this.method.getMethod(), this.parameters.get(i), this.resultValues.get(i), this.index));
                    ++i;
                }
            }
        }
        return this.parameterFrameWorkMethods;
    }

    private ArrayList<Object[]> convertParametersType() {
        if (this.parameters == null) {
            return null;
        }
        ArrayList<Object[]> myParameters = new ArrayList<Object[]>();
        Class<?>[] types = this.method.getMethod().getParameterTypes();
        for (Object[] parameter : this.parameters) {
            myParameters.add(this.getActualParameter(types, parameter));
        }
        return myParameters;
    }

    private Object[] getActualParameter(Class<?>[] types, Object[] parameter) {
        if (types.length != (parameter = (Object[])HolmosTypeCastUtils.getParameterEndByBlank(parameter)).length) {
            throw new HolmosFailedError("\u6d4b\u8bd5\u65b9\u6cd5   " + this.method.getName() + "()  \u4e2d\u7684\u53c2\u6570\u4e2a\u6570\u548c\u53c2\u6570\u6e90\u6587\u4ef6\u4e2d\u7684\u53c2\u6570\u7684\u4e2a\u6570\u4e0d\u4e00\u81f4!");
        }
        Object[] myParameter = new Object[types.length];
        int i = 0;
        while (i < parameter.length) {
            myParameter[i] = HolmosTypeCastUtils.castObjectAsType(types[i], parameter[i]);
            ++i;
        }
        return myParameter;
    }

    public int getParameterThreadpoolSize() {
        return this.parameterThreadpoolSize;
    }

    public void runParameterMethod(Object target, RunNotifier notifier) {
        try {
            if (this.parameters == null || this.parameters.size() == 0) {
                new ParameterMethodRunner(this.getParameterFrameWorkMethods().get(0), target, notifier).run();
            } else {
                HolmosThreadPoolExecutor executor = new HolmosThreadPoolExecutor(this.parameterThreadpoolSize, this.parameters.size());
                int i = 0;
                while (i < this.parameters.size()) {
                    ParameterMethodRunner parameterMethodRunner = new ParameterMethodRunner(this.getParameterFrameWorkMethods().get(i), target, notifier);
                    executor.submit(parameterMethodRunner);
                    ++i;
                }
                executor.waitForCompleted();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    class ParameterMethodRunner
    implements Runnable {
        private ParameterFrameWorkMethod parameterFrameWorkMethod;
        private Object target;
        private Description description;
        private RunNotifier notifier;

        public ParameterMethodRunner(ParameterFrameWorkMethod parameterFrameWorkMethod, Object target, RunNotifier notifier) {
            this.parameterFrameWorkMethod = parameterFrameWorkMethod;
            this.target = target;
            this.description = this.describeChild(parameterFrameWorkMethod);
            this.notifier = notifier;
        }

        private Statement methodBlock() {
            InvokeMethod statement = new InvokeMethod((FrameworkMethod)this.parameterFrameWorkMethod, this.target);
            statement = this.possiblyExpectingExceptions(this.parameterFrameWorkMethod, this.target, (Statement)statement);
            statement = this.withPotentialTimeout(this.parameterFrameWorkMethod, this.target, (Statement)statement);
            statement = this.withBefores(this.parameterFrameWorkMethod, this.target, (Statement)statement);
            statement = this.withAfters(this.parameterFrameWorkMethod, this.target, (Statement)statement);
            statement = this.withRules(this.parameterFrameWorkMethod, this.target, (Statement)statement);
            return statement;
        }

        protected Statement methodInvoker(FrameworkMethod method, Object test) {
            return new InvokeMethod(method, test);
        }

        @Deprecated
        protected Statement possiblyExpectingExceptions(FrameworkMethod method, Object test, Statement next) {
            Test annotation = (Test)method.getAnnotation(Test.class);
            return this.expectsException(annotation) ? new ExpectException(next, this.getExpectedException(annotation)) : next;
        }

        @Deprecated
        protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
            long timeout = this.getTimeout((Test)method.getAnnotation(Test.class));
            return timeout > 0L ? new FailOnTimeout(next, timeout) : next;
        }

        @Deprecated
        protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
            List befores = this.getTestClass().getAnnotatedMethods(Before.class);
            return befores.isEmpty() ? statement : new RunBefores(statement, befores, target);
        }

        private TestClass getTestClass() {
            return new TestClass(this.target.getClass());
        }

        @Deprecated
        protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
            List afters = this.getTestClass().getAnnotatedMethods(After.class);
            return afters.isEmpty() ? statement : new RunAfters(statement, afters, target);
        }

        private Statement withRules(FrameworkMethod method, Object target, Statement statement) {
            Statement result = statement;
            result = this.withMethodRules(method, target, result);
            result = this.withTestRules(method, target, result);
            return result;
        }

        private Statement withMethodRules(FrameworkMethod method, Object target, Statement result) {
            List<TestRule> testRules = this.getTestRules(target);
            for (MethodRule each : this.getMethodRules(target)) {
                if (testRules.contains(each)) continue;
                result = each.apply(result, method, target);
            }
            return result;
        }

        private List<MethodRule> getMethodRules(Object target) {
            return this.rules(target);
        }

        @Deprecated
        protected List<MethodRule> rules(Object target) {
            return this.getTestClass().getAnnotatedFieldValues(target, Rule.class, MethodRule.class);
        }

        private Statement withTestRules(FrameworkMethod method, Object target, Statement statement) {
            List<TestRule> testRules = this.getTestRules(target);
            return testRules.isEmpty() ? statement : new RunRules(statement, testRules, this.describeChild(method));
        }

        private Description describeChild(FrameworkMethod method) {
            return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)this.testName(method), (Annotation[])method.getAnnotations());
        }

        protected String testName(FrameworkMethod method) {
            if (method instanceof ParameterFrameWorkMethod) {
                return method.toString();
            }
            return method.getName();
        }

        protected List<TestRule> getTestRules(Object target) {
            return this.getTestClass().getAnnotatedFieldValues(target, Rule.class, TestRule.class);
        }

        private Class<? extends Throwable> getExpectedException(Test annotation) {
            if (annotation == null || annotation.expected() == Test.None.class) {
                return null;
            }
            return annotation.expected();
        }

        private boolean expectsException(Test annotation) {
            return this.getExpectedException(annotation) != null;
        }

        private long getTimeout(Test annotation) {
            if (annotation == null) {
                return 0L;
            }
            return annotation.timeout();
        }

        private final void runLeaf(Statement statement, Description description, RunNotifier notifier) {
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
            eachNotifier.fireTestStarted();
            try {
                try {
                    statement.evaluate();
                }
                catch (AssumptionViolatedException e) {
                    eachNotifier.addFailedAssumption(e);
                    eachNotifier.fireTestFinished();
                }
                catch (Throwable e) {
                    eachNotifier.addFailure(e);
                    eachNotifier.fireTestFinished();
                }
            }
            finally {
                eachNotifier.fireTestFinished();
            }
        }

        @Override
        public void run() {
            try {
                if (this.parameterFrameWorkMethod.getAnnotation(Ignore.class) != null) {
                    this.notifier.fireTestIgnored(this.description);
                } else {
                    this.runLeaf(this.methodBlock(), this.description, this.notifier);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

