/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters.excel;

import com.holmos.webtest.junitextentions.parameters.excel.HolmosCell;
import com.holmos.webtest.log.MyLogger;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Row;

public class HolmosRow {
    MyLogger logger = MyLogger.getLogger(HolmosRow.class);
    private Row row;

    public HolmosRow(Row row) {
        this.row = row;
    }

    public int getValidColumnCount() {
        return this.row.getLastCellNum() - this.row.getFirstCellNum();
    }

    public HolmosCell getCellByIndex(int index) {
        if (index < this.getValidColumnCount()) {
            return new HolmosCell(this.row.getCell(index));
        }
        this.logger.error("\u8981\u83b7\u53d6\u7684\u5355\u5143\u683c\u4e0d\u884c\u5728!");
        return null;
    }

    public ArrayList<HolmosCell> getValidCells() {
        ArrayList<HolmosCell> validCells = new ArrayList<HolmosCell>();
        int i = this.row.getFirstCellNum();
        while (i < this.row.getLastCellNum()) {
            validCells.add(new HolmosCell(this.row.getCell(i)));
            ++i;
        }
        return validCells;
    }

    public ArrayList<Object> getValidValues() {
        ArrayList<Object> validCells = new ArrayList<Object>();
        int i = this.row.getFirstCellNum();
        while (i < this.row.getLastCellNum()) {
            validCells.add(new HolmosCell(this.row.getCell(i)).getValueAsString());
            ++i;
        }
        return validCells;
    }
}

