/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.struct;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.constvalue.ConstValue;
import com.holmos.webtest.element.Element;
import com.holmos.webtest.element.locator.Locator;
import com.holmos.webtest.element.locator.LocatorChain;
import com.holmos.webtest.element.locator.LocatorValue;
import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.struct.Collection;
import com.holmos.webtest.struct.Frame;
import com.holmos.webtest.struct.SubPage;
import com.holmos.webtest.utils.HolmosBaseUtils;
import com.thoughtworks.selenium.Selenium;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Page
implements LocatorValue {
    protected String url;
    protected String comment;
    protected List<Element> elements = new ArrayList<Element>();
    protected List<SubPage> subpages = new ArrayList<SubPage>();
    protected List<Frame> frames = new ArrayList<Frame>();
    private static MyLogger logger = MyLogger.getLogger(Page.class);
    protected List<Collection> collections = new ArrayList<Collection>();

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    public Page() {
        HolmosBaseUtils.configLogProperties();
    }

    protected void init() {
        Field[] fields = this.getClass().getFields();
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getModifiers() != ConstValue.nestedFatherObjectModifier) {
                    Object o = field.get(this);
                    if (o instanceof Element) {
                        HolmosBaseUtils.insertElementName((Element)o, field.getName());
                        ((Element)o).getInfoChain().addNode(this);
                        ((Element)o).setFullName(String.valueOf(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)) + field.getName());
                        this.elements.add((Element)o);
                    } else if (o instanceof SubPage) {
                        HolmosBaseUtils.insertSubPageName((SubPage)o, field.getName());
                        ((SubPage)o).getInfoChain().addNode(this);
                        ((SubPage)o).setFullName(String.valueOf(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)) + field.getName());
                        this.subpages.add((SubPage)o);
                        ((SubPage)o).init();
                    } else if (o instanceof Collection) {
                        HolmosBaseUtils.insertCollectionName((Collection)o, field.getName());
                        ((Collection)o).getInfoChain().addNode(this);
                        ((Collection)o).setFullName(String.valueOf(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)) + field.getName());
                        this.collections.add((Collection)o);
                        ((Collection)o).init();
                    } else if (o instanceof Frame) {
                        HolmosBaseUtils.insertFrameName((Frame)o, field.getName());
                        ((Frame)o).getInfoChain().addNode(this);
                        ((Frame)o).setFullName(String.valueOf(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)) + field.getName());
                        this.frames.add((Frame)o);
                        ((Frame)o).setParent(this);
                        ((Frame)o).init();
                    }
                }
                ++n2;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public String getBodyText() {
        logger.info("\u83b7\u5f97" + this.comment + "\u9875\u9762body\u6e90\u7801");
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            return ((Selenium)currentWindow.getDriver().getEngine()).getBodyText();
        }
        if (currentWindow instanceof WebDriverBrowserWindow) {
            return ((WebDriver)currentWindow.getDriver().getEngine()).getPageSource();
        }
        return null;
    }

    public String getHtmlText() {
        logger.info("\u83b7\u5f97" + this.comment + "\u9875\u9762body\u6e90\u7801");
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            return ((Selenium)currentWindow.getDriver().getEngine()).getHtmlSource();
        }
        if (currentWindow instanceof WebDriverBrowserWindow) {
            return ((WebDriver)currentWindow.getDriver().getEngine()).getPageSource();
        }
        return null;
    }

    public String getTitle() {
        logger.info("\u83b7\u5f97" + this.comment + "\u9875\u9762body\u6e90\u7801");
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            return ((Selenium)currentWindow.getDriver().getEngine()).getTitle();
        }
        if (currentWindow instanceof WebDriverBrowserWindow) {
            return ((WebDriver)currentWindow.getDriver().getEngine()).getTitle();
        }
        return null;
    }

    public String getAllCookies() {
        logger.info("\u83b7\u5f97" + this.comment + "\u6240\u6709\u7684cookies");
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            return ((Selenium)currentWindow.getDriver().getEngine()).getCookie();
        }
        if (currentWindow instanceof WebDriverBrowserWindow) {
            Set cookies = ((WebDriver)currentWindow.getDriver().getEngine()).manage().getCookies();
            Iterator cookie = cookies.iterator();
            String cookieStr = "";
            while (cookie.hasNext()) {
                cookieStr = String.valueOf(cookieStr) + "|" + ((Cookie)cookie.next()).getValue();
            }
            return cookieStr;
        }
        return null;
    }

    public String getCookieByName(String name) {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            return ((Selenium)currentWindow.getDriver().getEngine()).getCookieByName(name);
        }
        if (currentWindow instanceof WebDriverBrowserWindow) {
            return ((WebDriver)currentWindow.getDriver().getEngine()).manage().getCookieNamed(name).getValue();
        }
        return null;
    }

    public void deleteCookie(String name, String path) {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).deleteCookie(name, path);
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            ((WebDriver)currentWindow.getDriver().getEngine()).manage().deleteCookieNamed(name);
        }
    }

    public void deleteAllCookie() {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof SeleniumBrowserWindow) {
            ((Selenium)currentWindow.getDriver().getEngine()).deleteAllVisibleCookies();
        } else if (currentWindow instanceof WebDriverBrowserWindow) {
            ((WebDriver)currentWindow.getDriver().getEngine()).manage().deleteAllCookies();
        }
    }

    @Override
    public Locator getLocator() {
        return null;
    }

    @Override
    public WebElement getElement() {
        return null;
    }

    @Override
    public void setElement(WebElement element) {
    }

    @Override
    public String getLocatorCurrent() {
        return null;
    }

    @Override
    public void setLocatorCurrent(String locatorCurrent) {
    }

    @Override
    public boolean isExist() {
        return false;
    }

    @Override
    public LocatorChain getInfoChain() {
        return null;
    }

    @Override
    public void setWholeComment(String currentComment) {
    }
}

