/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.internal.auth;

import com.ibm.cloud.objectstorage.AmazonWebServiceClient;
import com.ibm.cloud.objectstorage.AmazonWebServiceRequest;
import com.ibm.cloud.objectstorage.Request;
import com.ibm.cloud.objectstorage.auth.ServiceAwareSigner;
import com.ibm.cloud.objectstorage.auth.Signer;
import com.ibm.cloud.objectstorage.auth.SignerFactory;
import com.ibm.cloud.objectstorage.auth.SignerParams;
import com.ibm.cloud.objectstorage.auth.SignerTypeAware;
import com.ibm.cloud.objectstorage.handlers.HandlerContextKey;
import com.ibm.cloud.objectstorage.internal.auth.SignerProvider;
import com.ibm.cloud.objectstorage.internal.auth.SignerProviderContext;
import com.ibm.cloud.objectstorage.util.AwsHostNameUtils;
import java.net.URI;

public class DefaultSignerProvider
extends SignerProvider {
    private final AmazonWebServiceClient awsClient;
    private final Signer defaultSigner;

    public DefaultSignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.defaultSigner = defaultSigner;
    }

    @Override
    public Signer getSigner(SignerProviderContext context) {
        Request<?> request = context.getRequest();
        if (request == null || this.shouldUseDefaultSigner(request.getOriginalRequest())) {
            if (context.isRedirect()) {
                return this.awsClient.getSignerByURI(context.getUri());
            }
            if (request != null && request.getHandlerContext(HandlerContextKey.SIGNING_NAME) != null) {
                String signingName = request.getHandlerContext(HandlerContextKey.SIGNING_NAME);
                Signer newSigner = this.awsClient.getSignerByURI(context.getUri());
                if (newSigner instanceof ServiceAwareSigner && !this.isSignerOverridden()) {
                    ((ServiceAwareSigner)newSigner).setServiceName(signingName);
                    return newSigner;
                }
            }
            return this.defaultSigner;
        }
        SignerTypeAware signerTypeAware = (SignerTypeAware)((Object)request.getOriginalRequest());
        SignerParams params = new SignerParams(this.awsClient.getServiceName(), this.getSigningRegionForRequestURI(request.getEndpoint()));
        return SignerFactory.createSigner(signerTypeAware.getSignerType(), params);
    }

    private boolean shouldUseDefaultSigner(AmazonWebServiceRequest originalRequest) {
        return !(originalRequest instanceof SignerTypeAware) || this.isSignerOverridden();
    }

    private boolean isSignerOverridden() {
        return this.awsClient.getSignerOverride() != null;
    }

    private String getSigningRegionForRequestURI(URI uri) {
        String regionName = this.awsClient.getSignerRegionOverride();
        if (regionName == null) {
            regionName = AwsHostNameUtils.parseRegion(uri.getHost(), this.awsClient.getServiceName());
        }
        return regionName;
    }
}

