/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.protocol.json;

import com.ibm.cloud.objectstorage.AmazonServiceException;
import com.ibm.cloud.objectstorage.AmazonWebServiceResponse;
import com.ibm.cloud.objectstorage.SDKGlobalConfiguration;
import com.ibm.cloud.objectstorage.annotation.SdkProtectedApi;
import com.ibm.cloud.objectstorage.annotation.ThreadSafe;
import com.ibm.cloud.objectstorage.http.HttpResponseHandler;
import com.ibm.cloud.objectstorage.protocol.OperationInfo;
import com.ibm.cloud.objectstorage.protocol.Protocol;
import com.ibm.cloud.objectstorage.protocol.ProtocolRequestMarshaller;
import com.ibm.cloud.objectstorage.protocol.json.JsonClientMetadata;
import com.ibm.cloud.objectstorage.protocol.json.JsonContentTypeResolver;
import com.ibm.cloud.objectstorage.protocol.json.JsonErrorResponseMetadata;
import com.ibm.cloud.objectstorage.protocol.json.JsonErrorShapeMetadata;
import com.ibm.cloud.objectstorage.protocol.json.JsonOperationMetadata;
import com.ibm.cloud.objectstorage.protocol.json.JsonProtocolMarshallerBuilder;
import com.ibm.cloud.objectstorage.protocol.json.SdkJsonMarshallerFactory;
import com.ibm.cloud.objectstorage.protocol.json.SdkStructuredCborFactory;
import com.ibm.cloud.objectstorage.protocol.json.SdkStructuredIonFactory;
import com.ibm.cloud.objectstorage.protocol.json.SdkStructuredJsonFactory;
import com.ibm.cloud.objectstorage.protocol.json.SdkStructuredPlainJsonFactory;
import com.ibm.cloud.objectstorage.protocol.json.StructuredJsonGenerator;
import com.ibm.cloud.objectstorage.protocol.json.internal.EmptyBodyJsonMarshaller;
import com.ibm.cloud.objectstorage.transform.JsonErrorUnmarshaller;
import com.ibm.cloud.objectstorage.transform.JsonUnmarshallerContext;
import com.ibm.cloud.objectstorage.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;

@ThreadSafe
@SdkProtectedApi
public class SdkJsonProtocolFactory
implements SdkJsonMarshallerFactory {
    private final JsonClientMetadata metadata;
    private final List<JsonErrorUnmarshaller> errorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();

    public SdkJsonProtocolFactory(JsonClientMetadata metadata) {
        this.metadata = metadata;
        this.createErrorUnmarshallers();
    }

    @Override
    public StructuredJsonGenerator createGenerator() {
        return this.getSdkFactory().createWriter(this.getContentType());
    }

    @Override
    public String getContentType() {
        return this.getContentTypeResolver().resolveContentType(this.metadata);
    }

    public <T> ProtocolRequestMarshaller<T> createProtocolMarshaller(OperationInfo operationInfo, T origRequest) {
        return JsonProtocolMarshallerBuilder.standard().jsonGenerator(this.createGenerator(operationInfo)).contentType(this.getContentType()).operationInfo(operationInfo).originalRequest(origRequest).emptyBodyMarshaller(this.createEmptyBodyMarshaller(operationInfo)).build();
    }

    private StructuredJsonGenerator createGenerator(OperationInfo operationInfo) {
        if (operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.AWS_JSON) {
            return this.createGenerator();
        }
        return StructuredJsonGenerator.NO_OP;
    }

    private EmptyBodyJsonMarshaller createEmptyBodyMarshaller(OperationInfo operationInfo) {
        if (operationInfo.protocol() == Protocol.API_GATEWAY) {
            throw new IllegalStateException("Detected the API_GATEWAY protocol which should not be used with this protocol factory.");
        }
        if (!operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.API_GATEWAY) {
            return EmptyBodyJsonMarshaller.NULL;
        }
        return EmptyBodyJsonMarshaller.EMPTY;
    }

    public <T> HttpResponseHandler<AmazonWebServiceResponse<T>> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return this.getSdkFactory().createResponseHandler(operationMetadata, responseUnmarshaller);
    }

    public HttpResponseHandler<AmazonServiceException> createErrorResponseHandler(JsonErrorResponseMetadata errorResponsMetadata) {
        return this.getSdkFactory().createErrorResponseHandler(this.errorUnmarshallers, errorResponsMetadata.getCustomErrorCodeFieldName());
    }

    private void createErrorUnmarshallers() {
        for (JsonErrorShapeMetadata errorMetadata : this.metadata.getErrorShapeMetadata()) {
            if (errorMetadata.getExceptionUnmarshaller() != null) {
                this.errorUnmarshallers.add(errorMetadata.getExceptionUnmarshaller());
                continue;
            }
            if (errorMetadata.getModeledClass() == null) continue;
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(errorMetadata.getModeledClass(), errorMetadata.getErrorCode()));
        }
        if (this.metadata.getBaseServiceExceptionClass() != null) {
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(this.metadata.getBaseServiceExceptionClass(), null));
        }
    }

    private SdkStructuredJsonFactory getSdkFactory() {
        if (this.isCborEnabled()) {
            return SdkStructuredCborFactory.SDK_CBOR_FACTORY;
        }
        if (this.isIonEnabled()) {
            return this.isIonBinaryEnabled() ? SdkStructuredIonFactory.SDK_ION_BINARY_FACTORY : SdkStructuredIonFactory.SDK_ION_TEXT_FACTORY;
        }
        return SdkStructuredPlainJsonFactory.SDK_JSON_FACTORY;
    }

    private JsonContentTypeResolver getContentTypeResolver() {
        if (this.isCborEnabled()) {
            return JsonContentTypeResolver.CBOR;
        }
        if (this.isIonEnabled()) {
            return this.isIonBinaryEnabled() ? JsonContentTypeResolver.ION_BINARY : JsonContentTypeResolver.ION_TEXT;
        }
        return JsonContentTypeResolver.JSON;
    }

    private boolean isCborEnabled() {
        return this.metadata.isSupportsCbor() && !SDKGlobalConfiguration.isCborDisabled();
    }

    private boolean isIonEnabled() {
        return this.metadata.isSupportsIon();
    }

    boolean isIonBinaryEnabled() {
        return !SDKGlobalConfiguration.isIonBinaryDisabled();
    }
}

