/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.partitions;

import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.partitions.PartitionRegionImpl;
import com.ibm.cloud.objectstorage.partitions.model.Endpoint;
import com.ibm.cloud.objectstorage.partitions.model.Partition;
import com.ibm.cloud.objectstorage.partitions.model.Region;
import com.ibm.cloud.objectstorage.partitions.model.Service;
import com.ibm.cloud.objectstorage.regions.AbstractRegionMetadataProvider;
import com.ibm.cloud.objectstorage.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private static final String STANDARD_PARTITION_HOSTNAME = "{service}.{region}.{dnsSuffix}";
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, com.ibm.cloud.objectstorage.regions.Region> credentialScopeRegionByHost = new HashMap<String, com.ibm.cloud.objectstorage.regions.Region>();
    private final Set<String> standardHostnamePatternDnsSuffixes = new HashSet<String>();
    private final Map<String, com.ibm.cloud.objectstorage.regions.Region> regionCache = new ConcurrentHashMap<String, com.ibm.cloud.objectstorage.regions.Region>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        ValidationUtils.assertNotNull(partitions, "partitions");
        for (Partition p : partitions) {
            this.partitionMap.put(p.getPartition(), p);
            if (p.getDefaults() != null && STANDARD_PARTITION_HOSTNAME.equals(p.getDefaults().getHostName())) {
                this.standardHostnamePatternDnsSuffixes.add(p.getDnsSuffix());
            }
            for (Service service : p.getServices().values()) {
                for (Endpoint endpoint : service.getEndpoints().values()) {
                    if (endpoint.getHostName() == null || endpoint.getCredentialScope() == null || endpoint.getCredentialScope().getRegion() == null) continue;
                    com.ibm.cloud.objectstorage.regions.Region region = this.cacheRegion(new PartitionRegionImpl(endpoint.getCredentialScope().getRegion(), p));
                    this.credentialScopeRegionByHost.put(endpoint.getHostName(), region);
                }
            }
        }
    }

    @Override
    public List<com.ibm.cloud.objectstorage.regions.Region> getRegions() {
        ArrayList<com.ibm.cloud.objectstorage.regions.Region> regions = new ArrayList<com.ibm.cloud.objectstorage.regions.Region>();
        for (Partition p : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : p.getRegions().entrySet()) {
                regions.add(new com.ibm.cloud.objectstorage.regions.Region(new PartitionRegionImpl(entry.getKey(), p)));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public com.ibm.cloud.objectstorage.regions.Region getRegion(String regionName) {
        if (regionName == null) {
            return null;
        }
        com.ibm.cloud.objectstorage.regions.Region regionFromCache = this.getRegionFromCache(regionName);
        if (regionFromCache != null) {
            return regionFromCache;
        }
        return this.createNewRegion(regionName);
    }

    private com.ibm.cloud.objectstorage.regions.Region createNewRegion(String regionName) {
        for (Partition p : this.partitionMap.values()) {
            if (!p.hasRegion(regionName)) continue;
            return this.cacheRegion(new PartitionRegionImpl(regionName, p));
        }
        Partition awsPartition = this.partitionMap.get("aws");
        if (awsPartition != null) {
            return this.cacheRegion(new PartitionRegionImpl(regionName, awsPartition));
        }
        return null;
    }

    private com.ibm.cloud.objectstorage.regions.Region getRegionFromCache(String regionName) {
        return this.regionCache.get(regionName);
    }

    private com.ibm.cloud.objectstorage.regions.Region cacheRegion(PartitionRegionImpl regionImpl) {
        com.ibm.cloud.objectstorage.regions.Region region = new com.ibm.cloud.objectstorage.regions.Region(regionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<com.ibm.cloud.objectstorage.regions.Region> getRegionsForService(String serviceName) {
        List<com.ibm.cloud.objectstorage.regions.Region> allRegions = this.getRegions();
        ArrayList<com.ibm.cloud.objectstorage.regions.Region> serviceSupportedRegions = new ArrayList<com.ibm.cloud.objectstorage.regions.Region>();
        for (com.ibm.cloud.objectstorage.regions.Region r : allRegions) {
            if (!r.isServiceSupported(serviceName)) continue;
            serviceSupportedRegions.add(r);
        }
        return serviceSupportedRegions;
    }

    @Override
    public com.ibm.cloud.objectstorage.regions.Region tryGetRegionByExplicitEndpoint(String endpoint) {
        String host = PartitionMetadataProvider.getHost(endpoint);
        return this.credentialScopeRegionByHost.get(host);
    }

    @Override
    public com.ibm.cloud.objectstorage.regions.Region tryGetRegionByEndpointDnsSuffix(String endpoint) {
        String host = PartitionMetadataProvider.getHost(endpoint);
        for (String dnsSuffix : this.standardHostnamePatternDnsSuffixes) {
            dnsSuffix = "." + dnsSuffix;
            if (!host.endsWith(dnsSuffix)) continue;
            String serviceRegion = host.substring(0, host.length() - dnsSuffix.length());
            String region = serviceRegion.substring(serviceRegion.lastIndexOf(46) + 1);
            if (region.isEmpty()) {
                return null;
            }
            return this.getRegion(region);
        }
        return null;
    }
}

