/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth.json;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.auth.JsonCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

@SdkInternalApi
public class BasicJsonConfigLoader {
    public static final BasicJsonConfigLoader INSTANCE = new BasicJsonConfigLoader();

    private BasicJsonConfigLoader() {
    }

    public JsonCredentials loadCredentials(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Unable to load IBM credentials: specified file is null.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("IBM credential file not found in the given path: " + file.getAbsolutePath());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            JsonCredentials jsonCredentials = new JsonCredentials(fis);
            return jsonCredentials;
        }
        catch (IOException ioe) {
            throw new SdkClientException("Unable to load IBM credentials file at: " + file.getAbsolutePath(), ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

