/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.kms.model.transform;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.protocol.MarshallLocation;
import com.ibm.cloud.objectstorage.protocol.MarshallingInfo;
import com.ibm.cloud.objectstorage.protocol.MarshallingType;
import com.ibm.cloud.objectstorage.protocol.ProtocolMarshaller;
import com.ibm.cloud.objectstorage.services.kms.model.DecryptRequest;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class DecryptRequestMarshaller {
    private static final MarshallingInfo<ByteBuffer> CIPHERTEXTBLOB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CiphertextBlob").build();
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContext").build();
    private static final MarshallingInfo<List> GRANTTOKENS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantTokens").build();
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final MarshallingInfo<String> ENCRYPTIONALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionAlgorithm").build();
    private static final MarshallingInfo<Boolean> DRYRUN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DryRun").build();
    private static final DecryptRequestMarshaller instance = new DecryptRequestMarshaller();

    public static DecryptRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(DecryptRequest decryptRequest, ProtocolMarshaller protocolMarshaller) {
        if (decryptRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)decryptRequest.getCiphertextBlob(), CIPHERTEXTBLOB_BINDING);
            protocolMarshaller.marshall(decryptRequest.getEncryptionContext(), ENCRYPTIONCONTEXT_BINDING);
            protocolMarshaller.marshall(decryptRequest.getGrantTokens(), GRANTTOKENS_BINDING);
            protocolMarshaller.marshall((Object)decryptRequest.getKeyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)decryptRequest.getEncryptionAlgorithm(), ENCRYPTIONALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)decryptRequest.getDryRun(), DRYRUN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

