/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import net.jpountz.util.SafeUtils;
import net.jpountz.util.Utils;

public final class ByteBufferUtils
extends Enum<ByteBufferUtils> {
    private static final /* synthetic */ ByteBufferUtils[] $VALUES;

    public static ByteBufferUtils[] values() {
        return (ByteBufferUtils[])$VALUES.clone();
    }

    public static ByteBufferUtils valueOf(String string) {
        return Enum.valueOf(ByteBufferUtils.class, string);
    }

    public static void checkRange(ByteBuffer byteBuffer, int n2, int n3) {
        SafeUtils.checkLength(n3);
        if (n3 > 0) {
            ByteBufferUtils.checkRange(byteBuffer, n2);
            ByteBufferUtils.checkRange(byteBuffer, n2 + n3 - 1);
        }
    }

    public static void checkRange(ByteBuffer byteBuffer, int n2) {
        if (n2 < 0 || n2 >= byteBuffer.capacity()) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
    }

    public static ByteBuffer inLittleEndianOrder(ByteBuffer byteBuffer) {
        if (byteBuffer.order().equals(ByteOrder.LITTLE_ENDIAN)) {
            return byteBuffer;
        }
        return byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuffer inNativeByteOrder(ByteBuffer byteBuffer) {
        if (byteBuffer.order().equals(Utils.NATIVE_BYTE_ORDER)) {
            return byteBuffer;
        }
        return byteBuffer.duplicate().order(Utils.NATIVE_BYTE_ORDER);
    }

    public static byte readByte(ByteBuffer byteBuffer, int n2) {
        return byteBuffer.get(n2);
    }

    public static void writeInt(ByteBuffer byteBuffer, int n2, int n3) {
        assert (byteBuffer.order() == Utils.NATIVE_BYTE_ORDER);
        byteBuffer.putInt(n2, n3);
    }

    public static int readInt(ByteBuffer byteBuffer, int n2) {
        assert (byteBuffer.order() == Utils.NATIVE_BYTE_ORDER);
        return byteBuffer.getInt(n2);
    }

    public static int readIntLE(ByteBuffer byteBuffer, int n2) {
        assert (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getInt(n2);
    }

    public static void writeLong(ByteBuffer byteBuffer, int n2, long l8) {
        assert (byteBuffer.order() == Utils.NATIVE_BYTE_ORDER);
        byteBuffer.putLong(n2, l8);
    }

    public static long readLong(ByteBuffer byteBuffer, int n2) {
        assert (byteBuffer.order() == Utils.NATIVE_BYTE_ORDER);
        return byteBuffer.getLong(n2);
    }

    public static long readLongLE(ByteBuffer byteBuffer, int n2) {
        assert (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getLong(n2);
    }

    public static void writeByte(ByteBuffer byteBuffer, int n2, int n3) {
        byteBuffer.put(n2, (byte)n3);
    }

    public static void writeShortLE(ByteBuffer byteBuffer, int n2, int n3) {
        byteBuffer.put(n2, (byte)n3);
        byteBuffer.put(n2 + 1, (byte)(n3 >>> 8));
    }

    public static void checkNotReadOnly(ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
    }

    public static int readShortLE(ByteBuffer byteBuffer, int n2) {
        return byteBuffer.get(n2) & 0xFF | (byteBuffer.get(n2 + 1) & 0xFF) << 8;
    }

    static {
        $VALUES = new ByteBufferUtils[0];
    }
}

