/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.monitor;

import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.internal.core.CMXConnection;
import com.ibm.db2.cmx.internal.core.CMXConnectionEventListener;
import com.ibm.db2.cmx.internal.core.CMXConnectionFactory;
import com.ibm.db2.cmx.internal.metadata.DataBeanFirstConnection;
import com.ibm.db2.cmx.internal.metadata.DataBeanTransactionExecution;
import com.ibm.db2.cmx.internal.monitor.ClientInfoMaskBean;
import com.ibm.db2.cmx.internal.monitor.ConnectionClosedEventListener;
import com.ibm.db2.cmx.internal.monitor.MonitorAgent;
import com.ibm.db2.cmx.internal.monitor.MonitorProcessorAR;
import com.ibm.db2.cmx.internal.monitor.PeriodicTask;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcDataSource;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitorAgentImpl
implements MonitorAgent {
    boolean isHttp_ = false;
    ControllerAgent httpCA_ = null;
    private static Logger logger__ = Log.getCMXClientLogger();
    static Timer timer_ = new Timer(true);
    PeriodicTask periodicTask_ = null;
    CMXConnection connection_ = null;
    public boolean isConnectionActive_ = false;
    public boolean tryReconect_ = false;
    private int portNumber_ = 1234;
    private String monitorServerName_ = "localhost";
    int intervalSeconds_ = -1;
    DataBeanFirstConnection postConnectionBean_ = null;
    boolean sendConnectionData_ = false;
    private CMXConnectionEventListener connectionClosedListener_ = new ConnectionClosedEventListener(this);
    private List<DataBeanTransactionExecution> postTransactionsBeans_ = new ArrayList<DataBeanTransactionExecution>();
    private List<DataBeanTransactionExecution> postTransactionBeansToSend_ = new ArrayList<DataBeanTransactionExecution>();
    ProxiedJdbcDataSource proxiedDataSource_ = null;
    String supportedKeyTypes_ = null;
    int dispatchToken_ = -1;
    ClientInfoMaskBean clientInfoMaskBean_ = null;
    public boolean monitorIdRequired_ = false;
    public boolean sendFullSQL_ = false;
    private ByteBuffer buffer = null;
    private CharBuffer cBuffer = null;
    private CharsetEncoder encoder = null;
    public static final long FOW_PRIME = 1099511628211L;
    public volatile boolean bGotInitialIntervalPropertes_ = false;

    public void logActiveBeans(Logger logger) {
        logger.fine("postTransactionBeans_ size = " + this.postTransactionsBeans_.size());
        logger.fine("postTransactionBeansToSend_ size = " + this.postTransactionBeansToSend_.size());
    }

    public MonitorAgentImpl(boolean bl2, ControllerAgent controllerAgent, int n2, String string, int n3, int n4, ProxiedJdbcDataSource proxiedJdbcDataSource, String string2, String string3, String string4, String string5, String string6) throws Exception {
        this.isHttp_ = bl2;
        this.httpCA_ = controllerAgent;
        this.proxiedDataSource_ = proxiedJdbcDataSource;
        this.monitorServerName_ = string;
        this.portNumber_ = n3;
        this.setInterval(n4);
        this.buffer = ByteBuffer.allocate(32768);
        this.cBuffer = CharBuffer.allocate(8192);
        this.encoder = Charset.forName("UTF-8").newEncoder();
        this.supportedKeyTypes_ = string2;
        if (string3 != null || string4 != null || string5 != null || string6 != null) {
            this.clientInfoMaskBean_ = new ClientInfoMaskBean(string3, string4, string5, string6);
        }
        if (string2 != null) {
            this.monitorIdRequired_ = this.supportedKeyTypes_.contains("1");
            this.sendFullSQL_ = this.supportedKeyTypes_.contains("4");
        }
    }

    @Override
    public void getConnection() throws Exception {
        if (this.isHttp_) {
            if (this.httpCA_.getNegotiatedVersion() != -1) {
                this.isConnectionActive_ = true;
            }
            return;
        }
        String string = this.monitorServerName_;
        if (this.connection_ != null) {
            this.connection_.removeConnectionEventListner(this.connectionClosedListener_);
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "getConnection", "Monitor agent for datasource id:" + (this.proxiedDataSource_ == null ? "null" : Integer.valueOf(this.proxiedDataSource_.getDatasourceId())) + " is establishing a connection to " + this.monitorServerName_ + ":" + this.portNumber_);
        }
        String[] stringArray = null;
        if (this.monitorServerName_ != null) {
            stringArray = this.monitorServerName_.split(";");
        }
        int n2 = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        do {
            block16: {
                String string2 = string = stringArray == null ? this.monitorServerName_ : stringArray[n2];
                if (stringArray == null || n2 + 1 == stringArray.length) {
                    bl3 = true;
                }
                if (string != "") {
                    try {
                        this.connection_ = CMXConnectionFactory.getSharedConnection(string, this.portNumber_);
                        MonitorProcessorAR monitorProcessorAR = new MonitorProcessorAR();
                        int n3 = this.connection_.connectToProcessor(monitorProcessorAR);
                        if (n3 != -1) {
                            this.connection_.addConnectionEventListner(this.connectionClosedListener_);
                            this.isConnectionActive_ = true;
                            bl2 = false;
                        } else {
                            this.connection_.close();
                            this.connection_ = null;
                            this.isConnectionActive_ = false;
                            if (logger__.isLoggable(Level.INFO)) {
                                DataLogger.lowImpactLogger(logger__, this, "getConnection", "WARNING: Incompatible monitor server version.", null);
                            }
                            if (bl3) {
                                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, "monitoring processor unsupported on server", null, 11051);
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (logger__.isLoggable(Level.FINE)) {
                            DataLogger.lowImpactLogger(logger__, this, "getConnection", "Monitor agent for datasource id:" + (this.proxiedDataSource_ == null ? "null" : Integer.valueOf(this.proxiedDataSource_.getDatasourceId())) + " failed to connect to the monitor server", exception);
                        }
                        if (!bl3) break block16;
                        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, "monitoring processor unsupported on server", exception, 11052);
                    }
                }
            }
            n2 = (short)(n2 + 1);
            if (stringArray != null && n2 < stringArray.length) continue;
            bl2 = false;
        } while (bl2);
        if (logger__.isLoggable(Level.CONFIG)) {
            DataLogger.logConfigHighVis(logger__, this, "getConnection", "Monitor agent for datasource id:" + (this.proxiedDataSource_ == null ? "null" : Integer.valueOf(this.proxiedDataSource_.getDatasourceId())) + " successfully connected to the monitor server at " + string + ":" + this.portNumber_, false);
        }
    }

    private void setInterval(int n2) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "setInterval", "ENTRY " + Arrays.deepToString(new Object[]{n2}));
        }
        if (n2 != this.intervalSeconds_ && this.proxiedDataSource_ != null) {
            if (this.intervalSeconds_ > 0 && this.periodicTask_ != null) {
                this.periodicTask_.cancel();
                this.periodicTask_ = null;
            }
            this.intervalSeconds_ = n2;
            if (this.intervalSeconds_ > 0) {
                this.periodicTask_ = new PeriodicTask(this);
                this.periodicTask_.setIntervalSeconds(n2);
                timer_.schedule((TimerTask)this.periodicTask_, 0L, 1000L);
            }
        }
    }

    public boolean isConnected() {
        if (this.isHttp_) {
            return this.httpCA_.getNegotiatedVersion() != -1;
        }
        return this.connection_ != null && this.connection_.isConnected();
    }

    @Override
    public boolean isConnectionActive() {
        return this.isConnectionActive_;
    }

    @Override
    public void setReconnectFlag(boolean bl2) {
        this.tryReconect_ = bl2;
    }

    @Override
    public boolean getReconnectFlag() {
        return this.tryReconect_;
    }

    @Override
    public int getProtocol() {
        return 12;
    }

    @Override
    public void reportFirstConnection(DataBeanFirstConnection dataBeanFirstConnection) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "reportFirstConnection", "ENTRY " + Arrays.deepToString(new Object[]{dataBeanFirstConnection}));
            DataLogger.logMonitorMessage(logger__, this, "reportFirstConnection", "Message contents: " + dataBeanFirstConnection.toJSON(this.getNegotiatedVersion()).toString());
        }
        this.postConnectionBean_ = dataBeanFirstConnection;
        if (this.clientInfoMaskBean_ != null) {
            this.postConnectionBean_.clientUserMask_ = this.clientInfoMaskBean_.clientUserMask_;
            this.postConnectionBean_.clientWorkstationMask_ = this.clientInfoMaskBean_.clientWorkstationMask_;
            this.postConnectionBean_.clientApplicationNameMask_ = this.clientInfoMaskBean_.clientApplicationNameMask_;
            this.postConnectionBean_.clientAccountingInformationMask_ = this.clientInfoMaskBean_.clientAccountingInformationMask_;
        }
        this.sendConnectionData_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportPostTransaction(DataBeanTransactionExecution dataBeanTransactionExecution) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "reportPostTransaction", "ENTRY " + Arrays.deepToString(new Object[]{dataBeanTransactionExecution}));
        }
        if (this.periodicTask_ != null && !this.periodicTask_.isCancelled()) {
            MonitorAgentImpl monitorAgentImpl = this;
            synchronized (monitorAgentImpl) {
                this.postTransactionsBeans_.add(dataBeanTransactionExecution);
            }
        }
    }

    @Override
    public synchronized long hashCodeFowler(String string, int n2) {
        if (string == null) {
            return 0L;
        }
        long l2 = 0L;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        while (n3 < n4 && n5 < n2) {
            n6 = n4 - n3 > this.cBuffer.capacity() ? (n6 += this.cBuffer.capacity()) : n4;
            this.cBuffer.put(string, n3, n6);
            this.cBuffer.flip();
            this.encoder.reset();
            this.encoder.encode(this.cBuffer, this.buffer, true);
            this.encoder.flush(this.buffer);
            this.buffer.flip();
            while (this.buffer.hasRemaining() && n5 < n2) {
                l2 *= 1099511628211L;
                l2 ^= (long)this.buffer.get();
                ++n5;
            }
            this.cBuffer.clear();
            this.buffer.clear();
            n3 = n6;
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logMonitorMessage(logger__, "DataBeanStatementExecution", "hashCodeFowler", "bytelength=" + n5 + " hashcode for text: " + string + " = " + l2);
        }
        this.cBuffer.clear();
        this.buffer.clear();
        return l2;
    }

    public synchronized List<DataBeanTransactionExecution> getPostTransactionsToSend() {
        List<DataBeanTransactionExecution> list = this.postTransactionsBeans_;
        this.postTransactionsBeans_ = this.postTransactionBeansToSend_;
        this.postTransactionsBeans_.clear();
        this.postTransactionBeansToSend_ = list;
        return this.postTransactionBeansToSend_;
    }

    public void unsynchronizedTransactionBeanClear() {
        this.postTransactionsBeans_.clear();
        this.postTransactionBeansToSend_.clear();
    }

    private void monitorDisabledProcessing() {
        if (this.periodicTask_ != null) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logMonitorMessage(logger__, this, "monitorDisabledProcessing", "Cancelling the periodic task..");
            }
            this.periodicTask_.cancel();
            this.periodicTask_ = null;
        }
        if (this.connection_ != null) {
            this.connection_.removeConnectionEventListner(this.connectionClosedListener_);
        }
        this.connection_ = null;
        this.supportedKeyTypes_ = null;
    }

    @Override
    public synchronized void update(int n2, int n3, String string, int n4, int n5, int n6, String string2, String string3, String string4, String string5, String string6) {
        if (1 == n3) {
            if (!this.isConnected() || this.portNumber_ != n4 || null != this.monitorServerName_ && !this.monitorServerName_.equalsIgnoreCase(string)) {
                if (this.postConnectionBean_ != null) {
                    this.sendConnectionData_ = true;
                }
                this.portNumber_ = n4;
                this.monitorServerName_ = string;
                this.isConnectionActive_ = false;
                if (this.periodicTask_ != null && this.periodicTask_.isCancelled()) {
                    this.periodicTask_.run();
                }
                if (logger__.isLoggable(Level.INFO)) {
                    DataLogger.lowImpactLogger(logger__, this, "update", "monitor server info changed after lookup. New monitorServerName = " + this.monitorServerName_ + ": " + this.portNumber_, null);
                }
            }
            this.setInterval(n6);
            this.supportedKeyTypes_ = string2;
            if (string3 != null || string4 != null || string5 != null || string6 != null) {
                this.clientInfoMaskBean_ = new ClientInfoMaskBean(string3, string4, string5, string6);
                this.postConnectionBean_.clientUserMask_ = this.clientInfoMaskBean_.clientUserMask_;
                this.postConnectionBean_.clientWorkstationMask_ = this.clientInfoMaskBean_.clientWorkstationMask_;
                this.postConnectionBean_.clientApplicationNameMask_ = this.clientInfoMaskBean_.clientApplicationNameMask_;
                this.postConnectionBean_.clientAccountingInformationMask_ = this.clientInfoMaskBean_.clientAccountingInformationMask_;
                this.sendConnectionData_ = true;
            } else {
                this.clientInfoMaskBean_ = null;
            }
        } else {
            this.monitorDisabledProcessing();
        }
    }

    public String getMonitorInfo() {
        if (this.isHttp_ && this.httpCA_.getNegotiatedVersion() >= 12) {
            return "  Monitor Agent Connection Active: " + this.isConnectionActive() + "\n";
        }
        if (this.connection_ != null) {
            return "  Monitor Agent Connection URL: " + this.connection_.getUrl() + "\n  Monitor Agent Connection Active: " + this.isConnectionActive() + "\n";
        }
        return null;
    }

    protected void finalize() throws Throwable {
        DataLogger.logMonitorMessage(logger__, this, "finalize", "ENTER");
        super.finalize();
        if (this.connection_ != null) {
            this.connection_.removeConnectionEventListner(this.connectionClosedListener_);
        }
        if (this.periodicTask_ != null && !this.periodicTask_.isCancelled()) {
            this.periodicTask_.cancel();
            this.periodicTask_.run(this);
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "Finalize", "CMX Timer is cancelled and GC occured");
        }
        DataLogger.logMonitorMessage(logger__, this, "finalize", "EXIT");
    }

    @Override
    public int getNegotiatedVersion() {
        if (this.isHttp_) {
            return this.httpCA_.getNegotiatedVersion();
        }
        if (this.connection_ != null) {
            return this.connection_.getNegotiatedProcessorVersion("Monitor");
        }
        return -1;
    }

    public int getServerVersion() {
        int n2 = this.proxiedDataSource_.getControlDataSource().getOPMControllerVersion();
        int n3 = this.getNegotiatedVersion();
        if (n3 != -1) {
            n2 = n3;
        }
        return n2;
    }

    @Override
    public void close() {
        if (this.periodicTask_ != null) {
            this.periodicTask_.cancel();
        }
        this.connection_ = null;
        this.isConnectionActive_ = false;
        this.intervalSeconds_ = -1;
    }

    @Override
    public void maskClientInfo(String[] stringArray) {
        if (this.clientInfoMaskBean_ != null) {
            this.clientInfoMaskBean_.maskClientInfoString(stringArray);
        }
    }

    @Override
    public String maskClientUser(String string) {
        if (this.clientInfoMaskBean_ != null) {
            return this.clientInfoMaskBean_.maskClientUser(string);
        }
        return string;
    }

    @Override
    public String maskClientWorkstation(String string) {
        if (this.clientInfoMaskBean_ != null) {
            return this.clientInfoMaskBean_.maskClientWorkstation(string);
        }
        return string;
    }

    @Override
    public String maskClientApplicationInformation(String string) {
        if (this.clientInfoMaskBean_ != null) {
            return this.clientInfoMaskBean_.maskClientApplicationInformation(string);
        }
        return string;
    }

    @Override
    public String maskClientAccountingInformation(String string) {
        if (this.clientInfoMaskBean_ != null) {
            return this.clientInfoMaskBean_.maskClientAccountingInformation(string);
        }
        return string;
    }

    @Override
    public synchronized void updateIntervalSettings(int n2, int n3) {
        this.dispatchToken_ = n2;
        if (this.bGotInitialIntervalPropertes_ && 1 != n3) {
            this.monitorDisabledProcessing();
        }
    }
}

