/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.standalone.metadata.repository;

import com.ibm.db2.cmx.runtime.internal.repository.manager.ConnectionManager;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.DataAccessFactory;
import com.ibm.db2.cmx.runtime.internal.repository.standalone.metadata.repository.ConnectionProperties;
import com.ibm.db2.cmx.runtime.internal.repository.standalone.metadata.repository.RepositoryConnectionException;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.repository.ConnectionDescriptor;
import com.ibm.db2.jcc.DB2Driver;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class RepositoryConnectionFactory {
    public static Connection getConnection(InputStream inputStream) throws RepositoryConnectionException {
        ConnectionProperties connectionProperties = new ConnectionProperties();
        Connection connection = null;
        try {
            connectionProperties.load(inputStream);
            connection = RepositoryConnectionFactory.getConnection(connectionProperties);
        }
        catch (Exception exception) {
            throw new RepositoryConnectionException(exception);
        }
        return connection;
    }

    private static Connection getDB2Connection(String string, String string2, String string3) throws RepositoryConnectionException {
        try {
            DB2Driver dB2Driver = new DB2Driver();
            Properties properties = new Properties();
            if (string != null && string.length() > 0) {
                properties.put("user", string);
            }
            if (string2 != null && string2.length() > 0) {
                properties.put("password", string2);
            }
            if (string3 != null && !string3.contains("retrieveMessagesFromServerOnGetMessage")) {
                properties.put("retrieveMessagesFromServerOnGetMessage", "true");
            }
            return dB2Driver.connect(string3, properties);
        }
        catch (SQLException sQLException) {
            throw new RepositoryConnectionException(sQLException);
        }
    }

    public static Connection getConnection(ConnectionDescriptor connectionDescriptor) throws RepositoryConnectionException {
        String string = connectionDescriptor.getDriverClass();
        String string2 = connectionDescriptor.getUsername();
        String string3 = connectionDescriptor.getPassword();
        String string4 = connectionDescriptor.getUrl();
        if (string.toUpperCase().contains("DB2")) {
            DataAccessFactory.setDbType(DataAccessFactory.DBType.DB2);
        } else {
            DataAccessFactory.setDbType(DataAccessFactory.DBType.Derby);
        }
        if (connectionDescriptor.isUseDB2DriverDirectly() && DataAccessFactory.getDbType() == DataAccessFactory.DBType.DB2) {
            return RepositoryConnectionFactory.getDB2Connection(string2, string3, string4);
        }
        try {
            Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to load the driver. Message " + exception.getMessage());
        }
        Properties properties = new Properties();
        if (string2 != null) {
            properties.put("user", string2);
        }
        if (string3 != null) {
            properties.put("password", string3);
        }
        if (string4 != null && !string4.contains("retrieveMessagesFromServerOnGetMessage")) {
            properties.put("retrieveMessagesFromServerOnGetMessage", "true");
        }
        Connection connection = null;
        try {
            String string5;
            connection = DriverManager.getConnection(string4, properties);
            ConnectionManager.ConnectionType connectionType = ConnectionManager.getConnectionType(connection);
            if (ConnectionManager.ConnectionType.Informix.equals((Object)connectionType) && !(string5 = string4.toUpperCase()).contains("DELIMIDENT=Y") && !string5.contains("DELIMIDENT=TRUE")) {
                connection.close();
                String string6 = Messages.getText("ERR_MANAGEREPOSITORY_INFORMIX_URL_MISSING_DELIMIDENT", new Object[0]);
                throw new RepositoryConnectionException(string6, null);
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryConnectionException(sQLException);
        }
        return connection;
    }

    public static Connection getConnection(ConnectionProperties connectionProperties) throws RepositoryConnectionException {
        String string = connectionProperties.getProperty(ConnectionProperties.DRIVER_CLASS_KEY);
        String string2 = connectionProperties.getProperty(ConnectionProperties.USERID_KEY);
        String string3 = connectionProperties.getProperty(ConnectionProperties.PASSWORD_KEY);
        String string4 = connectionProperties.getProperty(ConnectionProperties.URL_KEY);
        try {
            Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to load the driver. Message " + exception.getMessage());
        }
        if (string.toUpperCase().contains("DB2")) {
            DataAccessFactory.setDbType(DataAccessFactory.DBType.DB2);
        } else {
            DataAccessFactory.setDbType(DataAccessFactory.DBType.Derby);
        }
        Properties properties = new Properties();
        properties.put("user", string2);
        properties.put("password", string3);
        if (string4 != null && !string4.contains("emulateParameterMetaDataForZCalls")) {
            connectionProperties.put("emulateParameterMetaDataForZCalls", "1");
        }
        if (string4 != null && !string4.contains("retrieveMessagesFromServerOnGetMessage")) {
            connectionProperties.put("retrieveMessagesFromServerOnGetMessage", "true");
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string4, properties);
        }
        catch (SQLException sQLException) {
            throw new RepositoryConnectionException(sQLException);
        }
        return connection;
    }
}

