/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CalendarData;
import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.impl.TextTrieMap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.ZoneMeta;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    public static final int FORMAT = 0;
    public static final int STANDALONE = 1;
    public static final int DT_CONTEXT_COUNT = 2;
    public static final int ABBREVIATED = 0;
    public static final int WIDE = 1;
    public static final int NARROW = 2;
    public static final int DT_WIDTH_COUNT = 3;
    String[] eras = null;
    String[] eraNames = null;
    String[] narrowEras = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] narrowMonths = null;
    String[] standaloneMonths = null;
    String[] standaloneShortMonths = null;
    String[] standaloneNarrowMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] narrowWeekdays = null;
    String[] standaloneWeekdays = null;
    String[] standaloneShortWeekdays = null;
    String[] standaloneNarrowWeekdays = null;
    String[] ampms = null;
    String[] shortQuarters = null;
    String[] quarters = null;
    String[] standaloneShortQuarters = null;
    String[] standaloneQuarters = null;
    private String[][] zoneStrings = null;
    static final String patternChars = "GyMdkHmsSEDFwWahKzYeugAZvcLQq";
    String localPatternChars = null;
    private static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    private static ICUCache DFSCACHE = new SimpleCache();
    private static ICUCache zoneItemInfoCache = new SimpleCache();
    private transient ZoneItemInfo localZoneItemInfo;
    private transient ZoneItem lastZoneItem;
    private ULocale requestedLocale;
    private static final String SHORT_GENERIC = "sg";
    private static final String SHORT_STANDARD = "ss";
    private static final String SHORT_DAYLIGHT = "sd";
    private static final String LONG_GENERIC = "lg";
    private static final String LONG_STANDARD = "ls";
    private static final String LONG_DAYLIGHT = "ld";
    private static final String EXEMPLAR_CITY = "ec";
    static final int TIMEZONE_SHORT_GENERIC = 0;
    static final int TIMEZONE_SHORT_STANDARD = 1;
    static final int TIMEZONE_SHORT_DAYLIGHT = 2;
    static final int TIMEZONE_LONG_GENERIC = 3;
    static final int TIMEZONE_LONG_STANDARD = 4;
    static final int TIMEZONE_LONG_DAYLIGHT = 5;
    static final int TIMEZONE_EXEMPLAR_CITY = 6;
    static final int TIMEZONE_COUNT = 7;
    private ULocale validLocale;
    private ULocale actualLocale;
    static /* synthetic */ Class class$com$ibm$icu$util$GregorianCalendar;

    public DateFormatSymbols() {
        this.initializeData(ULocale.getDefault(), "");
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(ULocale.forLocale(locale), "");
    }

    public DateFormatSymbols(ULocale locale) {
        this.initializeData(locale, "");
    }

    public String[] getEras() {
        return this.duplicate(this.eras);
    }

    public void setEras(String[] newEras) {
        this.eras = this.duplicate(newEras);
    }

    public String[] getEraNames() {
        return this.duplicate(this.eraNames);
    }

    public void setEraNames(String[] newEraNames) {
        this.eraNames = this.duplicate(newEraNames);
    }

    public String[] getMonths() {
        return this.duplicate(this.months);
    }

    public String[] getMonths(int context, int width) {
        String[] returnValue = null;
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        returnValue = this.months;
                        break;
                    }
                    case 0: {
                        returnValue = this.shortMonths;
                        break;
                    }
                    case 2: {
                        returnValue = this.narrowMonths;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        returnValue = this.standaloneMonths;
                        break block0;
                    }
                    case 0: {
                        returnValue = this.standaloneShortMonths;
                        break block0;
                    }
                    case 2: {
                        returnValue = this.standaloneNarrowMonths;
                    }
                }
            }
        }
        return this.duplicate(returnValue);
    }

    public void setMonths(String[] newMonths) {
        this.months = this.duplicate(newMonths);
    }

    public void setMonths(String[] newMonths, int context, int width) {
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        this.months = this.duplicate(newMonths);
                        break;
                    }
                    case 0: {
                        this.shortMonths = this.duplicate(newMonths);
                        break;
                    }
                    case 2: {
                        this.narrowMonths = this.duplicate(newMonths);
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        this.standaloneMonths = this.duplicate(newMonths);
                        break block0;
                    }
                    case 0: {
                        this.standaloneShortMonths = this.duplicate(newMonths);
                        break block0;
                    }
                    case 2: {
                        this.standaloneNarrowMonths = this.duplicate(newMonths);
                    }
                }
            }
        }
    }

    public String[] getShortMonths() {
        return this.duplicate(this.shortMonths);
    }

    public void setShortMonths(String[] newShortMonths) {
        this.shortMonths = this.duplicate(newShortMonths);
    }

    public String[] getWeekdays() {
        return this.duplicate(this.weekdays);
    }

    public String[] getWeekdays(int context, int width) {
        String[] returnValue = null;
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        returnValue = this.weekdays;
                        break;
                    }
                    case 0: {
                        returnValue = this.shortWeekdays;
                        break;
                    }
                    case 2: {
                        returnValue = this.narrowWeekdays;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        returnValue = this.standaloneWeekdays;
                        break block0;
                    }
                    case 0: {
                        returnValue = this.standaloneShortWeekdays;
                        break block0;
                    }
                    case 2: {
                        returnValue = this.standaloneNarrowWeekdays;
                    }
                }
            }
        }
        return this.duplicate(returnValue);
    }

    public void setWeekdays(String[] newWeekdays, int context, int width) {
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        this.weekdays = this.duplicate(newWeekdays);
                        break;
                    }
                    case 0: {
                        this.shortWeekdays = this.duplicate(newWeekdays);
                        break;
                    }
                    case 2: {
                        this.narrowWeekdays = this.duplicate(newWeekdays);
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        this.standaloneWeekdays = this.duplicate(newWeekdays);
                        break block0;
                    }
                    case 0: {
                        this.standaloneShortWeekdays = this.duplicate(newWeekdays);
                        break block0;
                    }
                    case 2: {
                        this.standaloneNarrowWeekdays = this.duplicate(newWeekdays);
                    }
                }
            }
        }
    }

    public void setWeekdays(String[] newWeekdays) {
        this.weekdays = this.duplicate(newWeekdays);
    }

    public String[] getShortWeekdays() {
        return this.duplicate(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] newShortWeekdays) {
        this.shortWeekdays = this.duplicate(newShortWeekdays);
    }

    public String[] getQuarters(int context, int width) {
        String[] returnValue = null;
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        returnValue = this.quarters;
                        break;
                    }
                    case 0: {
                        returnValue = this.shortQuarters;
                        break;
                    }
                    case 2: {
                        returnValue = null;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        returnValue = this.standaloneQuarters;
                        break block0;
                    }
                    case 0: {
                        returnValue = this.standaloneShortQuarters;
                        break block0;
                    }
                    case 2: {
                        returnValue = null;
                    }
                }
            }
        }
        return this.duplicate(returnValue);
    }

    public void setQuarters(String[] newQuarters, int context, int width) {
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        this.quarters = this.duplicate(newQuarters);
                        break block0;
                    }
                    case 0: {
                        this.shortQuarters = this.duplicate(newQuarters);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        this.standaloneQuarters = this.duplicate(newQuarters);
                        break block0;
                    }
                    case 0: {
                        this.standaloneShortQuarters = this.duplicate(newQuarters);
                        break block0;
                    }
                }
            }
        }
    }

    public String[] getAmPmStrings() {
        return this.duplicate(this.ampms);
    }

    public void setAmPmStrings(String[] newAmpms) {
        this.ampms = this.duplicate(newAmpms);
    }

    public String[][] getZoneStrings() {
        String[][] strings = this.zoneStrings;
        if (strings == null) {
            ZoneItemInfo zii = this.getDefaultZoneItemInfo();
            strings = zii.tzStrings;
        }
        return this.duplicate(strings);
    }

    public void setZoneStrings(String[][] newZoneStrings) {
        this.zoneStrings = this.duplicate(newZoneStrings);
        this.localZoneItemInfo = null;
    }

    public String getLocalPatternChars() {
        return new String(this.localPatternChars);
    }

    public void setLocalPatternChars(String newLocalPatternChars) {
        this.localPatternChars = newLocalPatternChars;
    }

    public Object clone() {
        try {
            DateFormatSymbols other = (DateFormatSymbols)super.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public int hashCode() {
        int hashcode = 0;
        hashcode ^= this.requestedLocale.toString().hashCode();
        String[][] tzStrings = this.zoneStrings;
        if (tzStrings == null) {
            ZoneItemInfo zii = this.getDefaultZoneItemInfo();
            tzStrings = zii.tzStrings;
        }
        for (int i = 0; i < tzStrings.length; ++i) {
            for (int j = 0; j < tzStrings[i].length; ++j) {
                if (tzStrings[i][j] == null) continue;
                hashcode ^= tzStrings[i][j].hashCode();
            }
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormatSymbols that = (DateFormatSymbols)obj;
        return Utility.arrayEquals(this.eras, (Object)that.eras) && Utility.arrayEquals(this.eraNames, (Object)that.eraNames) && Utility.arrayEquals(this.months, (Object)that.months) && Utility.arrayEquals(this.shortMonths, (Object)that.shortMonths) && Utility.arrayEquals(this.narrowMonths, (Object)that.narrowMonths) && Utility.arrayEquals(this.standaloneMonths, (Object)that.standaloneMonths) && Utility.arrayEquals(this.standaloneShortMonths, (Object)that.standaloneShortMonths) && Utility.arrayEquals(this.standaloneNarrowMonths, (Object)that.standaloneNarrowMonths) && Utility.arrayEquals(this.weekdays, (Object)that.weekdays) && Utility.arrayEquals(this.shortWeekdays, (Object)that.shortWeekdays) && Utility.arrayEquals(this.narrowWeekdays, (Object)that.narrowWeekdays) && Utility.arrayEquals(this.standaloneWeekdays, (Object)that.standaloneWeekdays) && Utility.arrayEquals(this.standaloneShortWeekdays, (Object)that.standaloneShortWeekdays) && Utility.arrayEquals(this.standaloneNarrowWeekdays, (Object)that.standaloneNarrowWeekdays) && Utility.arrayEquals(this.ampms, (Object)that.ampms) && DateFormatSymbols.arrayOfArrayEquals(this.zoneStrings, that.zoneStrings) && this.requestedLocale.getDisplayName().equals(that.requestedLocale.getDisplayName()) && Utility.arrayEquals(this.localPatternChars, (Object)that.localPatternChars);
    }

    protected void initializeData(ULocale desiredLocale, String type) {
        String key = desiredLocale.toString() + "+" + type;
        DateFormatSymbols dfs = (DateFormatSymbols)DFSCACHE.get(key);
        if (dfs == null) {
            CalendarData calData = new CalendarData(desiredLocale, type);
            this.initializeData(desiredLocale, calData);
            dfs = (DateFormatSymbols)this.clone();
            DFSCACHE.put(key, dfs);
        } else {
            this.initializeData(dfs);
        }
    }

    void initializeData(DateFormatSymbols dfs) {
        this.eras = dfs.eras;
        this.eraNames = dfs.eraNames;
        this.narrowEras = dfs.narrowEras;
        this.months = dfs.months;
        this.shortMonths = dfs.shortMonths;
        this.narrowMonths = dfs.narrowMonths;
        this.standaloneMonths = dfs.standaloneMonths;
        this.standaloneShortMonths = dfs.standaloneShortMonths;
        this.standaloneNarrowMonths = dfs.standaloneNarrowMonths;
        this.weekdays = dfs.weekdays;
        this.shortWeekdays = dfs.shortWeekdays;
        this.narrowWeekdays = dfs.narrowWeekdays;
        this.standaloneWeekdays = dfs.standaloneWeekdays;
        this.standaloneShortWeekdays = dfs.standaloneShortWeekdays;
        this.standaloneNarrowWeekdays = dfs.standaloneNarrowWeekdays;
        this.ampms = dfs.ampms;
        this.shortQuarters = dfs.shortQuarters;
        this.quarters = dfs.quarters;
        this.standaloneShortQuarters = dfs.standaloneShortQuarters;
        this.standaloneQuarters = dfs.standaloneQuarters;
        this.zoneStrings = dfs.zoneStrings;
        this.localPatternChars = dfs.localPatternChars;
        this.actualLocale = dfs.actualLocale;
        this.validLocale = dfs.validLocale;
        this.requestedLocale = dfs.requestedLocale;
    }

    protected void initializeData(ULocale desiredLocale, CalendarData calData) {
        this.eras = calData.getEras("abbreviated");
        try {
            this.eraNames = calData.getEras("wide");
        }
        catch (MissingResourceException e) {
            this.eraNames = calData.getEras("abbreviated");
        }
        try {
            this.narrowEras = calData.getEras("narrow");
        }
        catch (MissingResourceException e) {
            this.narrowEras = calData.getEras("abbreviated");
        }
        this.months = calData.getStringArray("monthNames", "wide");
        this.shortMonths = calData.getStringArray("monthNames", "abbreviated");
        try {
            this.narrowMonths = calData.getStringArray("monthNames", "narrow");
        }
        catch (MissingResourceException e) {
            try {
                this.narrowMonths = calData.getStringArray("monthNames", "stand-alone", "narrow");
            }
            catch (MissingResourceException e1) {
                this.narrowMonths = calData.getStringArray("monthNames", "abbreviated");
            }
        }
        try {
            this.standaloneMonths = calData.getStringArray("monthNames", "stand-alone", "wide");
        }
        catch (MissingResourceException e) {
            this.standaloneMonths = calData.getStringArray("monthNames", "format", "wide");
        }
        try {
            this.standaloneShortMonths = calData.getStringArray("monthNames", "stand-alone", "abbreviated");
        }
        catch (MissingResourceException e) {
            this.standaloneShortMonths = calData.getStringArray("monthNames", "format", "abbreviated");
        }
        try {
            this.standaloneNarrowMonths = calData.getStringArray("monthNames", "stand-alone", "narrow");
        }
        catch (MissingResourceException e) {
            try {
                this.standaloneNarrowMonths = calData.getStringArray("monthNames", "format", "narrow");
            }
            catch (MissingResourceException e1) {
                this.standaloneNarrowMonths = calData.getStringArray("monthNames", "format", "abbreviated");
            }
        }
        String[] lWeekdays = calData.getStringArray("dayNames", "wide");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        System.arraycopy(lWeekdays, 0, this.weekdays, 1, lWeekdays.length);
        String[] sWeekdays = calData.getStringArray("dayNames", "abbreviated");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        System.arraycopy(sWeekdays, 0, this.shortWeekdays, 1, sWeekdays.length);
        String[] nWeekdays = null;
        try {
            nWeekdays = calData.getStringArray("dayNames", "narrow");
        }
        catch (MissingResourceException e) {
            try {
                nWeekdays = calData.getStringArray("dayNames", "stand-alone", "narrow");
            }
            catch (MissingResourceException e1) {
                nWeekdays = calData.getStringArray("dayNames", "abbreviated");
            }
        }
        this.narrowWeekdays = new String[8];
        this.narrowWeekdays[0] = "";
        System.arraycopy(nWeekdays, 0, this.narrowWeekdays, 1, nWeekdays.length);
        String[] saWeekdays = null;
        try {
            saWeekdays = calData.getStringArray("dayNames", "stand-alone", "wide");
        }
        catch (MissingResourceException e) {
            saWeekdays = calData.getStringArray("dayNames", "format", "wide");
        }
        this.standaloneWeekdays = new String[8];
        this.standaloneWeekdays[0] = "";
        System.arraycopy(saWeekdays, 0, this.standaloneWeekdays, 1, saWeekdays.length);
        String[] ssWeekdays = null;
        try {
            ssWeekdays = calData.getStringArray("dayNames", "stand-alone", "abbreviated");
        }
        catch (MissingResourceException e) {
            ssWeekdays = calData.getStringArray("dayNames", "format", "abbreviated");
        }
        this.standaloneShortWeekdays = new String[8];
        this.standaloneShortWeekdays[0] = "";
        System.arraycopy(ssWeekdays, 0, this.standaloneShortWeekdays, 1, ssWeekdays.length);
        String[] snWeekdays = null;
        try {
            snWeekdays = calData.getStringArray("dayNames", "stand-alone", "narrow");
        }
        catch (MissingResourceException e) {
            try {
                snWeekdays = calData.getStringArray("dayNames", "format", "narrow");
            }
            catch (MissingResourceException e1) {
                snWeekdays = calData.getStringArray("dayNames", "format", "abbreviated");
            }
        }
        this.standaloneNarrowWeekdays = new String[8];
        this.standaloneNarrowWeekdays[0] = "";
        System.arraycopy(snWeekdays, 0, this.standaloneNarrowWeekdays, 1, snWeekdays.length);
        this.ampms = calData.getStringArray("AmPmMarkers");
        this.quarters = calData.getStringArray("quarters", "wide");
        this.shortQuarters = calData.getStringArray("quarters", "abbreviated");
        try {
            this.standaloneQuarters = calData.getStringArray("quarters", "stand-alone", "wide");
        }
        catch (MissingResourceException e) {
            this.standaloneQuarters = calData.getStringArray("quarters", "format", "wide");
        }
        try {
            this.standaloneShortQuarters = calData.getStringArray("quarters", "stand-alone", "abbreviated");
        }
        catch (MissingResourceException e) {
            this.standaloneShortQuarters = calData.getStringArray("quarters", "format", "abbreviated");
        }
        this.requestedLocale = desiredLocale;
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt36b", desiredLocale);
        this.localPatternChars = rb.getString("localPatternChars");
        ULocale uloc = rb.getULocale();
        this.setLocale(uloc, uloc);
    }

    private static final boolean arrayOfArrayEquals(Object[][] aa1, Object[][] aa2) {
        if (aa1 == aa2) {
            return true;
        }
        if (aa1 == null || aa2 == null) {
            return false;
        }
        if (aa1.length != aa2.length) {
            return false;
        }
        boolean equal = true;
        for (int i = 0; i < aa1.length && (equal = Utility.arrayEquals(aa1[i], (Object)aa2[i])); ++i) {
        }
        return equal;
    }

    String getZoneString(String zid, int type) {
        String zoneString = this.getZoneString(this.getLocalZoneItemInfo(), zid, type);
        if (zoneString == null) {
            zoneString = this.getZoneString(this.getDefaultZoneItemInfo(), zid, type);
        }
        return zoneString;
    }

    private String getZoneString(ZoneItemInfo zinfo, String zid, int type) {
        if (zinfo == null) {
            return null;
        }
        String[] names = (String[])zinfo.tzidMap.get(zid);
        if (names != null) {
            int index = -1;
            switch (type) {
                case 4: {
                    index = 1;
                    break;
                }
                case 1: {
                    index = 2;
                    break;
                }
                case 5: {
                    index = 3;
                    break;
                }
                case 2: {
                    index = 4;
                    break;
                }
                case 6: {
                    if (names.length != 6 && names.length != 8) break;
                    index = 5;
                    break;
                }
                case 3: {
                    if (names.length == 8) {
                        index = 6;
                        break;
                    }
                    index = 5;
                    break;
                }
                case 0: {
                    index = names.length == 8 ? 7 : 6;
                }
            }
            if (index < names.length) {
                return names[index];
            }
        }
        return null;
    }

    ZoneItem findZoneIDTypeValue(String text, int start) {
        ZoneItem item = null;
        int textLength = text.length() - start;
        if (this.lastZoneItem != null && textLength == this.lastZoneItem.value.length() && text.regionMatches(true, start, this.lastZoneItem.value, 0, textLength)) {
            item = new ZoneItem();
            item.type = this.lastZoneItem.type;
            item.value = this.lastZoneItem.value;
            item.zid = this.lastZoneItem.zid;
            return item;
        }
        ZoneItemInfo zinfo = this.getLocalZoneItemInfo();
        if (zinfo != null) {
            item = (ZoneItem)zinfo.tzStringMap.get(text, start);
        }
        zinfo = this.getDefaultZoneItemInfo();
        ZoneItem itemForLocale = (ZoneItem)zinfo.tzStringMap.get(text, start);
        if (itemForLocale != null && (item == null || itemForLocale.value.length() > item.value.length())) {
            item = itemForLocale;
        }
        if (item != null && textLength == item.value.length()) {
            this.lastZoneItem = new ZoneItem();
            this.lastZoneItem.type = item.type;
            this.lastZoneItem.value = item.value;
            this.lastZoneItem.zid = item.zid;
        }
        return item;
    }

    private ZoneItemInfo getDefaultZoneItemInfo() {
        ZoneItemInfo zii = (ZoneItemInfo)zoneItemInfoCache.get(this.requestedLocale);
        if (zii != null) {
            return zii;
        }
        zii = this.getZoneItemInfo(DateFormatSymbols.getDefaultZoneStrings(this.requestedLocale));
        String[] zoneIDs = TimeZone.getAvailableIDs();
        for (int i = 0; i < zoneIDs.length; ++i) {
            String value;
            Object o = zii.tzidMap.get(zoneIDs[i]);
            if (o != null || (value = ZoneMeta.displayFallback(zoneIDs[i], null, this.requestedLocale)) == null) continue;
            String[] strings = new String[8];
            strings[5] = value;
            zii.tzidMap.put(zoneIDs[i], strings);
            ZoneItem item = new ZoneItem();
            item.zid = zoneIDs[i];
            item.value = value;
            item.type = 6;
            zii.tzStringMap.put(item.value, item);
        }
        zoneItemInfoCache.put(this.requestedLocale, zii);
        return zii;
    }

    private static String[][] getDefaultZoneStrings(ULocale locale) {
        ArrayList<String[]> tmpList = new ArrayList<String[]>();
        HashSet tmpSet = new HashSet();
        for (ULocale tempLocale = locale; tempLocale != null; tempLocale = tempLocale.getFallback()) {
            ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt36b", tempLocale);
            ICUResourceBundle zoneStringsBundle = bundle.getWithFallback("zoneStrings");
            for (int i = 0; i < zoneStringsBundle.getSize(); ++i) {
                ICUResourceBundle zoneTable = zoneStringsBundle.get(i);
                String key = Utility.replaceAll(zoneTable.getKey(), ":", "/");
                if (key.length() == 0 || zoneTable.getType() != 2 || tmpSet.contains(key)) continue;
                String[] strings = new String[8];
                strings[0] = key;
                try {
                    strings[1] = zoneTable.getStringWithFallback(LONG_STANDARD);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[2] = zoneTable.getStringWithFallback(SHORT_STANDARD);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[3] = zoneTable.getStringWithFallback(LONG_DAYLIGHT);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[4] = zoneTable.getStringWithFallback(SHORT_DAYLIGHT);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    String city = zoneTable.getStringWithFallback(EXEMPLAR_CITY);
                    strings[5] = ZoneMeta.displayFallback(key, city, tempLocale);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[6] = zoneTable.getStringWithFallback(LONG_GENERIC);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[7] = zoneTable.getStringWithFallback(SHORT_GENERIC);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                tmpList.add(strings);
            }
        }
        String[][] array = new String[tmpList.size()][8];
        tmpList.toArray((T[])array);
        return array;
    }

    private ZoneItemInfo getLocalZoneItemInfo() {
        if (this.localZoneItemInfo == null && this.zoneStrings != null) {
            this.localZoneItemInfo = this.getZoneItemInfo(this.zoneStrings);
        }
        return this.localZoneItemInfo;
    }

    private ZoneItemInfo getZoneItemInfo(String[][] strings) {
        ZoneItemInfo zii = new ZoneItemInfo();
        zii.tzStrings = strings;
        zii.tzidMap = new HashMap();
        zii.tzStringMap = new TextTrieMap(true);
        for (int i = 0; i < strings.length; ++i) {
            String zid = strings[i][0];
            if (zid == null || zid.length() <= 0) continue;
            zii.tzidMap.put(zid, strings[i]);
            int nameCount = strings[i].length < 8 ? strings[i].length : 8;
            block10: for (int j = 1; j < nameCount; ++j) {
                if (strings[i][j] == null) continue;
                int type = -1;
                switch (j) {
                    case 1: {
                        type = 4;
                        break;
                    }
                    case 2: {
                        type = 1;
                        break;
                    }
                    case 3: {
                        type = 5;
                        break;
                    }
                    case 4: {
                        type = 2;
                        break;
                    }
                    case 5: {
                        if (nameCount == 6 || nameCount == 8) {
                            type = 6;
                            break;
                        }
                        type = 3;
                        break;
                    }
                    case 6: {
                        if (nameCount == 8) {
                            type = 3;
                            break;
                        }
                        type = 0;
                        break;
                    }
                    case 7: {
                        type = 0;
                        break;
                    }
                    default: {
                        continue block10;
                    }
                }
                ZoneItem item = new ZoneItem();
                item.zid = zid;
                item.value = strings[i][j];
                item.type = type;
                zii.tzStringMap.put(strings[i][j], item);
            }
        }
        return zii;
    }

    private final String[] duplicate(String[] srcArray) {
        return (String[])srcArray.clone();
    }

    private final String[][] duplicate(String[][] srcArray) {
        String[][] aCopy = new String[srcArray.length][];
        for (int i = 0; i < srcArray.length; ++i) {
            aCopy[i] = this.duplicate(srcArray[i]);
        }
        return aCopy;
    }

    public DateFormatSymbols(Calendar cal, Locale locale) {
        this.initializeData(ULocale.forLocale(locale), cal.getType());
    }

    public DateFormatSymbols(Calendar cal, ULocale locale) {
        this.initializeData(locale, cal.getType());
    }

    public DateFormatSymbols(Class calendarClass, Locale locale) {
        this(calendarClass, ULocale.forLocale(locale));
    }

    public DateFormatSymbols(Class calendarClass, ULocale locale) {
        String fullName = calendarClass.getName();
        int lastDot = fullName.lastIndexOf(46);
        String className = fullName.substring(lastDot + 1);
        String calType = Utility.replaceAll(className, "Calendar", "").toLowerCase();
        this.initializeData(locale, calType);
    }

    public DateFormatSymbols(ResourceBundle bundle, Locale locale) {
        this(bundle, ULocale.forLocale(locale));
    }

    public DateFormatSymbols(ResourceBundle bundle, ULocale locale) {
        this.initializeData(locale, new CalendarData((ICUResourceBundle)bundle, null));
    }

    public static ResourceBundle getDateFormatBundle(Class calendarClass, Locale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(calendarClass, ULocale.forLocale(locale));
    }

    public static ResourceBundle getDateFormatBundle(Class calendarClass, ULocale locale) throws MissingResourceException {
        UResourceBundle result;
        block2: {
            String fullName = calendarClass.getName();
            int lastDot = fullName.lastIndexOf(46);
            String className = fullName.substring(lastDot + 1);
            String bundleName = className + "Symbols";
            result = null;
            try {
                result = UResourceBundle.getBundleInstance(bundleName, locale);
            }
            catch (MissingResourceException e) {
                if ((class$com$ibm$icu$util$GregorianCalendar == null ? (class$com$ibm$icu$util$GregorianCalendar = DateFormatSymbols.class$("com.ibm.icu.util.GregorianCalendar")) : class$com$ibm$icu$util$GregorianCalendar).isAssignableFrom(calendarClass)) break block2;
                throw e;
            }
        }
        return result;
    }

    public static ResourceBundle getDateFormatBundle(Calendar cal, Locale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(cal.getClass(), ULocale.forLocale(locale));
    }

    public static ResourceBundle getDateFormatBundle(Calendar cal, ULocale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(cal.getClass(), locale);
    }

    public final ULocale getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ZoneItemInfo {
        String[][] tzStrings;
        HashMap tzidMap;
        TextTrieMap tzStringMap;

        private ZoneItemInfo() {
        }
    }

    class ZoneItem {
        String value;
        int type;
        String zid;

        ZoneItem() {
        }
    }
}

