/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.CalendarAstronomer;
import com.ibm.icu.impl.CalendarCache;
import com.ibm.icu.impl.CalendarUtil;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Locale;

public class IslamicCalendar
extends Calendar {
    private static final long serialVersionUID = -6253365474073869325L;
    public static final int MUHARRAM = 0;
    public static final int SAFAR = 1;
    public static final int RABI_1 = 2;
    public static final int RABI_2 = 3;
    public static final int JUMADA_1 = 4;
    public static final int JUMADA_2 = 5;
    public static final int RAJAB = 6;
    public static final int SHABAN = 7;
    public static final int RAMADAN = 8;
    public static final int SHAWWAL = 9;
    public static final int DHU_AL_QIDAH = 10;
    public static final int DHU_AL_HIJJAH = 11;
    private static final long HIJRA_MILLIS = -42521587200000L;
    private static final long CIVIL_EPOC = 1948440L;
    private static final long ASTRONOMICAL_EPOC = 1948439L;
    private static final int[][] LIMITS = new int[][]{{0, 0, 0, 0}, {1, 1, 5000000, 5000000}, {0, 0, 11, 11}, {1, 1, 50, 51}, new int[0], {1, 1, 29, 30}, {1, 1, 354, 355}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {1, 1, 5000000, 5000000}, new int[0], {1, 1, 5000000, 5000000}, new int[0], new int[0]};
    private static final int[] UMALQURA_MONTHLENGTH = new int[]{1396, 2421, 1703, 599, 1323, 1685, 1738, 2773, 1371, 603, 2349, 3221, 3402, 3675, 603, 2773, 1370, 2731, 1099, 1701, 1874, 2985, 884, 2742, 1366, 2730, 3410, 3497, 1492, 2794, 1245, 622, 2350, 2726, 3412, 1450, 1461, 692, 2359, 1179, 2635, 2853, 2900, 2922, 1389, 1197, 2645, 3365, 3730, 3785, 1748, 2778, 1387, 1195, 1669, 2889, 2980, 2994, 1461, 698, 2395, 1195, 1365, 1714, 1753, 748, 2414, 1198, 2646, 3370, 3413, 1450, 2741, 1211, 91, 2347, 2709, 842, 2981, 1450, 2741, 1366, 2710, 2890, 3749, 1874, 1769, 874, 2733, 1365, 2725, 2898, 2985, 1460, 2490, 1243, 605, 1325, 2725, 2772, 2794, 1389, 1213, 573, 2333, 2709, 2890, 2906, 1389, 694, 2363, 1179, 1621, 1705, 1876, 2922, 1388, 2733, 1365, 2857, 2962, 2985, 1492, 2778, 1370, 2731, 1429, 1865, 1892, 2986, 1461, 694, 2646, 3661, 2853, 2898, 2922, 1453, 686, 2351, 1175, 1611, 1701, 1708, 2774, 1373, 1181, 2637, 3350, 3477, 1450, 1461, 666, 2395, 1196, 1429, 1738, 1764, 2794, 1269, 694, 2390, 2730};
    private static final int UMALQURA_YEAR_START = 1318;
    private static final int UMALQURA_YEAR_END = 1480;
    private static CalendarAstronomer astro = new CalendarAstronomer();
    private static CalendarCache cache = new CalendarCache();
    private boolean civil = true;
    private CalculationType cType = CalculationType.ISLAMIC_CIVIL;

    public IslamicCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public IslamicCalendar(TimeZone zone) {
        this(zone, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public IslamicCalendar(Locale aLocale) {
        this(TimeZone.getDefault(), aLocale);
    }

    public IslamicCalendar(ULocale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public IslamicCalendar(TimeZone zone, Locale aLocale) {
        this(zone, ULocale.forLocale(aLocale));
    }

    public IslamicCalendar(TimeZone zone, ULocale locale) {
        super(zone, locale);
        this.setCalcTypeForLocale(locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public IslamicCalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.setTime(date);
    }

    public IslamicCalendar(int year, int month, int date) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
    }

    public IslamicCalendar(int year, int month, int date, int hour, int minute, int second) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    public void setCivil(boolean beCivil) {
        this.civil = beCivil;
        if (beCivil && this.cType != CalculationType.ISLAMIC_CIVIL) {
            long m = this.getTimeInMillis();
            this.cType = CalculationType.ISLAMIC_CIVIL;
            this.clear();
            this.setTimeInMillis(m);
        } else if (!beCivil && this.cType != CalculationType.ISLAMIC) {
            long m = this.getTimeInMillis();
            this.cType = CalculationType.ISLAMIC;
            this.clear();
            this.setTimeInMillis(m);
        }
    }

    public boolean isCivil() {
        return this.cType == CalculationType.ISLAMIC_CIVIL;
    }

    protected int handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    private static final boolean civilLeapYear(int year) {
        return (14 + 11 * year) % 30 < 11;
    }

    private long yearStart(int year) {
        long ys = 0L;
        if (this.cType == CalculationType.ISLAMIC_CIVIL || this.cType == CalculationType.ISLAMIC_TBLA || this.cType == CalculationType.ISLAMIC_UMALQURA && year < 1318) {
            ys = (long)((year - 1) * 354) + (long)Math.floor((double)(3 + 11 * year) / 30.0);
        } else if (this.cType == CalculationType.ISLAMIC) {
            ys = IslamicCalendar.trueMonthStart(12 * (year - 1));
        } else if (this.cType == CalculationType.ISLAMIC_UMALQURA) {
            ys = this.yearStart(1317);
            ys += (long)this.handleGetYearLength(1317);
            for (int i = 1318; i < year; ++i) {
                ys += (long)this.handleGetYearLength(i);
            }
        }
        return ys;
    }

    private long monthStart(int year, int month) {
        int realYear = year + month / 12;
        int realMonth = month % 12;
        long ms = 0L;
        if (this.cType == CalculationType.ISLAMIC_CIVIL || this.cType == CalculationType.ISLAMIC_TBLA || this.cType == CalculationType.ISLAMIC_UMALQURA && year < 1318) {
            ms = (long)Math.ceil(29.5 * (double)realMonth) + (long)((realYear - 1) * 354) + (long)Math.floor((double)(3 + 11 * realYear) / 30.0);
        } else if (this.cType == CalculationType.ISLAMIC) {
            ms = IslamicCalendar.trueMonthStart(12 * (realYear - 1) + realMonth);
        } else if (this.cType == CalculationType.ISLAMIC_UMALQURA) {
            ms = this.yearStart(year);
            for (int i = 0; i < month; ++i) {
                ms += (long)this.handleGetMonthLength(year, i);
            }
        }
        return ms;
    }

    private static final long trueMonthStart(long month) {
        long start = cache.get(month);
        if (start == CalendarCache.EMPTY) {
            long origin = -42521587200000L + (long)Math.floor((double)month * 29.530588853) * 86400000L;
            double age = IslamicCalendar.moonAge(origin);
            if (IslamicCalendar.moonAge(origin) >= 0.0) {
                while ((age = IslamicCalendar.moonAge(origin -= 86400000L)) >= 0.0) {
                }
            } else {
                while ((age = IslamicCalendar.moonAge(origin += 86400000L)) < 0.0) {
                }
            }
            start = (origin - -42521587200000L) / 86400000L + 1L;
            cache.put(month, start);
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final double moonAge(long time) {
        double age = 0.0;
        CalendarAstronomer calendarAstronomer = astro;
        synchronized (calendarAstronomer) {
            astro.setTime(time);
            age = astro.getMoonAge();
        }
        age = age * 180.0 / Math.PI;
        if (age > 180.0) {
            age -= 360.0;
        }
        return age;
    }

    protected int handleGetMonthLength(int extendedYear, int month) {
        int length = 0;
        if (this.cType == CalculationType.ISLAMIC_CIVIL || this.cType == CalculationType.ISLAMIC_TBLA || this.cType == CalculationType.ISLAMIC_UMALQURA && (extendedYear < 1318 || extendedYear > 1480)) {
            length = 29 + (month + 1) % 2;
            if (month == 11 && IslamicCalendar.civilLeapYear(extendedYear)) {
                ++length;
            }
        } else if (this.cType == CalculationType.ISLAMIC) {
            month = 12 * (extendedYear - 1) + month;
            length = (int)(IslamicCalendar.trueMonthStart(month + 1) - IslamicCalendar.trueMonthStart(month));
        } else if (this.cType == CalculationType.ISLAMIC_UMALQURA) {
            int idx = extendedYear - 1318;
            int mask = 1 << 11 - month;
            length = (UMALQURA_MONTHLENGTH[idx] & mask) == 0 ? 29 : 30;
        }
        return length;
    }

    protected int handleGetYearLength(int extendedYear) {
        int length = 0;
        if (this.cType == CalculationType.ISLAMIC_CIVIL || this.cType == CalculationType.ISLAMIC_TBLA || this.cType == CalculationType.ISLAMIC_UMALQURA && (extendedYear < 1318 || extendedYear > 1480)) {
            length = 354 + (IslamicCalendar.civilLeapYear(extendedYear) ? 1 : 0);
        } else if (this.cType == CalculationType.ISLAMIC) {
            int month = 12 * (extendedYear - 1);
            length = (int)(IslamicCalendar.trueMonthStart(month + 12) - IslamicCalendar.trueMonthStart(month));
        } else if (this.cType == CalculationType.ISLAMIC_UMALQURA) {
            for (int i = 0; i < 12; ++i) {
                length += this.handleGetMonthLength(extendedYear, i);
            }
        }
        return length;
    }

    protected int handleComputeMonthStart(int eyear, int month, boolean useMonth) {
        return (int)this.monthStart(eyear, month) + 1948439;
    }

    protected int handleGetExtendedYear() {
        int year = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : this.internalGet(1, 1);
        return year;
    }

    protected void handleComputeFields(int julianDay) {
        int year = 0;
        int month = 0;
        int dayOfMonth = 0;
        int dayOfYear = 0;
        long days = (long)julianDay - 1948440L;
        if (this.cType == CalculationType.ISLAMIC_CIVIL || this.cType == CalculationType.ISLAMIC_TBLA) {
            if (this.cType == CalculationType.ISLAMIC_TBLA) {
                days = (long)julianDay - 1948439L;
            }
            year = (int)Math.floor((double)(30L * days + 10646L) / 10631.0);
            month = (int)Math.ceil((double)(days - 29L - this.yearStart(year)) / 29.5);
            month = Math.min(month, 11);
        } else if (this.cType == CalculationType.ISLAMIC) {
            int months = (int)Math.floor((double)days / 29.530588853);
            long monthStart = (long)Math.floor((double)months * 29.530588853 - 1.0);
            if (days - monthStart >= 25L && IslamicCalendar.moonAge(this.internalGetTimeInMillis()) > 0.0) {
                ++months;
            }
            while ((monthStart = IslamicCalendar.trueMonthStart(months)) > days) {
                --months;
            }
            year = months / 12 + 1;
            month = months % 12;
        } else if (this.cType == CalculationType.ISLAMIC_UMALQURA) {
            long umalquraStartdays = this.yearStart(1318);
            if (days < umalquraStartdays) {
                year = (int)Math.floor((double)(30L * days + 10646L) / 10631.0);
                month = (int)Math.ceil((double)(days - 29L - this.yearStart(year)) / 29.5);
                month = Math.min(month, 11);
            } else {
                int y = 1317;
                int m = 0;
                long d = 1L;
                while (d > 0L) {
                    if ((d = days - this.yearStart(++y) + 1L) == (long)this.handleGetYearLength(y)) {
                        m = 11;
                        break;
                    }
                    if (d >= (long)this.handleGetYearLength(y)) continue;
                    int monthLen = this.handleGetMonthLength(y, m);
                    m = 0;
                    while (d > (long)monthLen) {
                        d -= (long)monthLen;
                        monthLen = this.handleGetMonthLength(y, ++m);
                    }
                    break block1;
                }
                year = y;
                month = m;
            }
        }
        dayOfMonth = (int)(days - this.monthStart(year, month)) + 1;
        dayOfYear = (int)(days - this.monthStart(year, 0) + 1L);
        this.internalSet(0, 0);
        this.internalSet(1, year);
        this.internalSet(19, year);
        this.internalSet(2, month);
        this.internalSet(5, dayOfMonth);
        this.internalSet(6, dayOfYear);
    }

    public void setType(CalculationType type) {
        this.cType = type;
        this.civil = this.cType == CalculationType.ISLAMIC_CIVIL;
    }

    private void setCalcTypeForLocale(ULocale locale) {
        String localeCalType = CalendarUtil.getCalendarType(locale);
        if ("islamic-civil".equals(localeCalType)) {
            this.setType(CalculationType.ISLAMIC_CIVIL);
        } else if ("islamic-umalqura".equals(localeCalType)) {
            this.setType(CalculationType.ISLAMIC_UMALQURA);
        } else if ("islamic-tbla".equals(localeCalType)) {
            this.setType(CalculationType.ISLAMIC_TBLA);
        } else if (localeCalType.startsWith("islamic")) {
            this.setType(CalculationType.ISLAMIC);
        } else {
            this.setType(CalculationType.ISLAMIC_CIVIL);
        }
    }

    public String getType() {
        if (this.cType == null) {
            return "islamic";
        }
        return this.cType.bcpType();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.cType != CalculationType.ISLAMIC_CIVIL) {
            return;
        }
        if (!this.civil) {
            this.cType = CalculationType.ISLAMIC;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CalculationType {
        ISLAMIC("islamic"),
        ISLAMIC_CIVIL("islamic-civil"),
        ISLAMIC_UMALQURA("islamic-umalqura"),
        ISLAMIC_TBLA("islamic-tbla");

        private String bcpType;

        private CalculationType(String bcpType) {
            this.bcpType = bcpType;
        }

        String bcpType() {
            return this.bcpType;
        }
    }
}

