/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.antlr.v4.runtime.tree.TerminalNode;

public class EachFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$each");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$each");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$each");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$each");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$each");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ExpressionsVisitor.SelectorArrayNode result = null;
        FunctionBase.CtxEvalResult ctxEvalResult = this.evalContext(expressionVisitor, ctx);
        JsonNode arg = ctxEvalResult.arg;
        int argCount = ctxEvalResult.argumentCount;
        boolean useContext = ctxEvalResult.useContext;
        switch (argCount) {
            case 0: {
                if (arg == null) return result;
                throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
            }
            case 1: {
                DeclaredFunction fctArg = FunctionUtils.getFunctionArgFromCtx(expressionVisitor, ctx, true);
                if (fctArg != null) return result;
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
            case 2: {
                MappingExpressionParser.ExprContext varid;
                if (arg == null || !arg.isObject()) {
                    throw new EvaluateRuntimeException(String.format("Argument 1 of function %s does not match function signature", "$each"));
                }
                ObjectNode object = (ObjectNode)arg;
                result = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
                MappingExpressionParser.ExprContext exprContext = ctx.exprValues() != null && ctx.exprValues().exprList() != null ? ctx.exprValues().exprList().expr(useContext ? 0 : 1) : (varid = null);
                if (varid instanceof MappingExpressionParser.Var_recallContext) {
                    TerminalNode VAR_ID = ((MappingExpressionParser.Var_recallContext)varid).VAR_ID();
                    String varID = varid.getText();
                    DeclaredFunction fct = expressionVisitor.getDeclaredFunction(varID);
                    if (fct != null) {
                        int fctVarCount;
                        int varCount = fct.getVariableCount();
                        if (varCount > (fctVarCount = fct.getMaxArgs())) {
                            varCount = fctVarCount;
                        }
                        Iterator it = object.fieldNames();
                        while (it.hasNext()) {
                            JsonNode fctResult;
                            String key = (String)it.next();
                            JsonNode field = object.get(key);
                            MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                            switch (varCount) {
                                case 1: {
                                    evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                                    break;
                                }
                                case 2: {
                                    evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                                    evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                                    break;
                                }
                                case 3: {
                                    evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                                    evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                                    evc = FunctionUtils.addObjectExprVarContext(ctx, evc, object);
                                }
                            }
                            if ((fctResult = fct.invoke(expressionVisitor, evc)) == null) continue;
                            result.add(fctResult);
                        }
                        return result;
                    } else {
                        FunctionBase function = expressionVisitor.getJsonataFunction(varid.getText());
                        if (function == null) throw new EvaluateRuntimeException("Expected function variable reference " + varID + " to resolve to a declared nor Jsonata function.");
                        Iterator it = object.fieldNames();
                        while (it.hasNext()) {
                            String key = (String)it.next();
                            JsonNode field = object.get(key);
                            MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                            result.add(FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, field));
                        }
                    }
                    return result;
                } else {
                    int fctVarCount;
                    MappingExpressionParser.ExprListContext fctBody;
                    MappingExpressionParser.Function_declContext fctDeclCtx;
                    if (!(varid instanceof MappingExpressionParser.Function_declContext)) return result;
                    MappingExpressionParser.Function_declContext function_declContext = ctx.exprValues() != null && ctx.exprValues().exprList() != null ? (MappingExpressionParser.Function_declContext)ctx.exprValues().exprList().expr(useContext ? 0 : 1) : (fctDeclCtx = null);
                    if (fctDeclCtx == null) return result;
                    MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
                    DeclaredFunction fct = new DeclaredFunction(varList, fctBody = fctDeclCtx.exprList());
                    int varCount = fct.getVariableCount();
                    if (varCount > (fctVarCount = fct.getMaxArgs())) {
                        varCount = fctVarCount;
                    }
                    Iterator it = object.fieldNames();
                    while (it.hasNext()) {
                        JsonNode fctResult;
                        String key = (String)it.next();
                        JsonNode field = object.get(key);
                        MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                        switch (varCount) {
                            case 1: {
                                evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                                break;
                            }
                            case 2: {
                                evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                                evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                                break;
                            }
                            case 3: {
                                evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                                evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                                evc = FunctionUtils.addObjectExprVarContext(ctx, evc, object);
                            }
                        }
                        if ((fctResult = fct.invoke(expressionVisitor, evc)) == null) continue;
                        result.add(fctResult);
                    }
                }
                return result;
            }
            default: {
                throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
            }
        }
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<o-f:a<o>";
    }
}

