/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.jakarta.jms.MQConnectionFactory;
import com.ibm.mq.spring.boot.MQConfigurationProperties;
import com.ibm.mq.spring.boot.MQConnectionFactoryCustomizer;
import com.ibm.mq.spring.boot.MQConnectionFactoryFactory;
import jakarta.jms.ConnectionFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.pool2.PooledObject;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryProperties;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={ConnectionFactory.class})
public class MQConnectionFactoryConfiguration {
    private static Logger logger = LoggerFactory.getLogger(MQConnectionFactoryConfiguration.class);

    private static MQConnectionFactory createConnectionFactory(MQConfigurationProperties properties, ObjectProvider<SslBundles> sslBundles, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers) {
        return new MQConnectionFactoryFactory(properties, (SslBundles)sslBundles.getIfAvailable(), (List)factoryCustomizers.getIfAvailable()).createConnectionFactory(MQConnectionFactory.class);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JmsPoolConnectionFactory.class, PooledObject.class})
    public static class PooledMQConnectionFactoryConfiguration {
        @Bean(destroyMethod="stop")
        @ConditionalOnProperty(prefix="ibm.mq.pool", name={"enabled"}, havingValue="true", matchIfMissing=false)
        public JmsPoolConnectionFactory pooledJmsConnectionFactory(MQConfigurationProperties properties, ObjectProvider<SslBundles> sslBundles, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers) {
            logger.trace("Creating pooled MQConnectionFactory");
            MQConnectionFactory connectionFactory = MQConnectionFactoryConfiguration.createConnectionFactory(properties, sslBundles, factoryCustomizers);
            return PooledMQConnectionFactoryConfiguration.createInstance(JmsPoolConnectionFactory.class, (ConnectionFactory)connectionFactory, properties.getPool());
        }

        public static <T extends JmsPoolConnectionFactory> T createInstance(Class<T> factoryClass, ConnectionFactory connectionFactory, JmsPoolConnectionFactoryProperties poolProperties) {
            logger.trace("Creating pooled MQConnectionFactory instance for type {}", (Object)factoryClass.getSimpleName());
            JmsPoolConnectionFactory pooledConnectionFactory = null;
            try {
                pooledConnectionFactory = (JmsPoolConnectionFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                pooledConnectionFactory.setConnectionFactory((Object)connectionFactory);
                pooledConnectionFactory.setBlockIfSessionPoolIsFull(poolProperties.isBlockIfFull());
                if (poolProperties.getBlockIfFullTimeout() != null) {
                    pooledConnectionFactory.setBlockIfSessionPoolIsFullTimeout(poolProperties.getBlockIfFullTimeout().toMillis());
                }
                if (poolProperties.getIdleTimeout() != null) {
                    pooledConnectionFactory.setConnectionIdleTimeout((int)poolProperties.getIdleTimeout().toMillis());
                }
                pooledConnectionFactory.setMaxConnections(poolProperties.getMaxConnections());
                pooledConnectionFactory.setMaxSessionsPerConnection(poolProperties.getMaxSessionsPerConnection());
                if (poolProperties.getTimeBetweenExpirationCheck() != null) {
                    pooledConnectionFactory.setConnectionCheckInterval(poolProperties.getTimeBetweenExpirationCheck().toMillis());
                }
                pooledConnectionFactory.setUseAnonymousProducers(poolProperties.isUseAnonymousProducers());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
            return (T)pooledConnectionFactory;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CachingConnectionFactory.class})
    @ConditionalOnProperty(prefix="ibm.mq.pool", name={"enabled"}, havingValue="false", matchIfMissing=true)
    static class RegularMQConnectionFactoryConfiguration {
        RegularMQConnectionFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="false")
        public MQConnectionFactory jmsConnectionFactory(MQConfigurationProperties properties, ObjectProvider<SslBundles> sslBundles, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers) {
            logger.trace("Creating single MQConnectionFactory");
            return MQConnectionFactoryConfiguration.createConnectionFactory(properties, sslBundles, factoryCustomizers);
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public CachingConnectionFactory cachingJmsConnectionFactory(MQConfigurationProperties properties, ObjectProvider<SslBundles> sslBundles, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers, JmsProperties jmsProperties) {
            JmsProperties.Cache cacheProperties = jmsProperties.getCache();
            logger.trace("Creating caching MQConnectionFactory");
            MQConnectionFactory wrappedConnectionFactory = MQConnectionFactoryConfiguration.createConnectionFactory(properties, sslBundles, factoryCustomizers);
            CachingConnectionFactory connectionFactory = new CachingConnectionFactory((ConnectionFactory)wrappedConnectionFactory);
            connectionFactory.setCacheConsumers(cacheProperties.isConsumers());
            connectionFactory.setCacheProducers(cacheProperties.isProducers());
            connectionFactory.setSessionCacheSize(cacheProperties.getSessionCacheSize());
            return connectionFactory;
        }
    }
}

