/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.ByteArrayInputStream;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.MimeMessage;

class AppendCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "APPEND";
    public static final String ARGS = "<mailbox> [<flag_list>] [<date_time>] literal";
    private AppendCommandParser appendCommandParser = new AppendCommandParser();

    AppendCommand() {
        super(NAME, ARGS);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        MailFolder folder;
        Date receivedDate;
        String mailboxName = this.appendCommandParser.mailbox(request);
        Flags flags = this.appendCommandParser.optionalAppendFlags(request);
        if (flags == null) {
            flags = new Flags();
        }
        if ((receivedDate = this.appendCommandParser.optionalDateTime(request)) == null) {
            receivedDate = new Date();
        }
        MimeMessage message = this.appendCommandParser.mimeMessage(request);
        this.appendCommandParser.endLine(request);
        try {
            folder = this.getMailbox(mailboxName, session, true);
        }
        catch (FolderException e) {
            e.setResponseCode("TRYCREATE");
            throw e;
        }
        folder.appendMessage(message, flags, receivedDate);
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }

    private static class AppendCommandParser
    extends CommandParser {
        private AppendCommandParser() {
        }

        public Flags optionalAppendFlags(ImapRequestLineReader request) throws ProtocolException {
            char next = request.nextWordChar();
            if (next == '(') {
                return this.flagList(request);
            }
            return null;
        }

        public Date optionalDateTime(ImapRequestLineReader request) throws ProtocolException {
            char next = request.nextWordChar();
            if (next == '\"') {
                return this.dateTime(request);
            }
            return null;
        }

        public MimeMessage mimeMessage(ImapRequestLineReader request) throws ProtocolException {
            request.nextWordChar();
            byte[] mail = this.consumeLiteralAsBytes(request);
            try {
                return GreenMailUtil.newMimeMessage(new ByteArrayInputStream(mail));
            }
            catch (Exception e) {
                throw new ProtocolException("Can not create new mime message", e);
            }
        }
    }
}

