/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.commands.SortKey;
import com.icegreen.greenmail.imap.commands.SortTerm;
import com.icegreen.greenmail.store.StoredMessage;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;

class StoredMessageSorter
implements Comparator<StoredMessage> {
    private SortTerm sortTerm;
    private final AtomicBoolean reverse = new AtomicBoolean();

    StoredMessageSorter(SortTerm sortTerm) {
        this.sortTerm = sortTerm;
    }

    @Override
    public int compare(StoredMessage m1, StoredMessage m2) {
        try {
            int compareResult = 0;
            for (SortKey sortKey : this.sortTerm.getSortCriteria()) {
                switch (sortKey) {
                    case REVERSE: {
                        this.reverse.set(true);
                        break;
                    }
                    case ARRIVAL: {
                        compareResult = this.doCompare(m1.getReceivedDate(), m2.getReceivedDate());
                        break;
                    }
                    case CC: {
                        compareResult = this.doCompare((Comparable)((Object)this.getCc(m1)), (Comparable)((Object)this.getCc(m2)));
                        break;
                    }
                    case DATE: {
                        compareResult = this.doCompare(m1.getMimeMessage().getSentDate(), m2.getMimeMessage().getSentDate());
                        break;
                    }
                    case FROM: {
                        compareResult = this.doCompare((Comparable)((Object)this.getFrom(m1)), (Comparable)((Object)this.getFrom(m2)));
                        break;
                    }
                    case SIZE: {
                        compareResult = this.doCompare(Integer.valueOf(m1.getMimeMessage().getSize()), Integer.valueOf(m2.getMimeMessage().getSize()));
                        break;
                    }
                    case SUBJECT: {
                        compareResult = this.doCompare((Comparable)((Object)m1.getMimeMessage().getSubject()), (Comparable)((Object)m2.getMimeMessage().getSubject()));
                        break;
                    }
                    case TO: {
                        compareResult = this.doCompare((Comparable)((Object)this.getTo(m1)), (Comparable)((Object)this.getTo(m2)));
                        break;
                    }
                }
                if (compareResult == 0) continue;
                break;
            }
            return compareResult;
        }
        catch (MessagingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String getFrom(StoredMessage message) throws MessagingException {
        Address[] addresses = message.getMimeMessage().getFrom();
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        return String.valueOf(addresses[0]);
    }

    private String getTo(StoredMessage message) throws MessagingException {
        Address[] addresses = message.getMimeMessage().getRecipients(Message.RecipientType.TO);
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        return String.valueOf(addresses[0]);
    }

    private String getCc(StoredMessage message) throws MessagingException {
        Address[] addresses = message.getMimeMessage().getRecipients(Message.RecipientType.CC);
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        return String.valueOf(addresses[0]);
    }

    private int doCompare(Comparable c1, Comparable c2) {
        int multiplier;
        int n = multiplier = this.reverse.getAndSet(false) ? -1 : 1;
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return multiplier * 1;
        }
        if (c2 == null) {
            return multiplier * -1;
        }
        return multiplier * c1.compareTo(c2);
    }
}

