/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.store.StoredMessageCollection;
import com.icegreen.greenmail.util.MaxSizeLinkedHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;

public class MapBasedStoredMessageCollection
implements StoredMessageCollection {
    private final Map<Long, StoredMessage> mailMessages;

    public MapBasedStoredMessageCollection(int maximumMapSize) {
        this.mailMessages = Collections.synchronizedMap(new MaxSizeLinkedHashMap(maximumMapSize));
    }

    @Override
    public int size() {
        return this.mailMessages.size();
    }

    @Override
    public void add(StoredMessage storedMessage) {
        this.mailMessages.put(storedMessage.getUid(), storedMessage);
    }

    @Override
    public void clear() {
        this.mailMessages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFirstUnseen() {
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            int i = 1;
            for (StoredMessage message : this.mailMessages.values()) {
                if (!message.isSet(Flags.Flag.SEEN)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public int getMsn(long uid) throws FolderException {
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            if (this.mailMessages.containsKey(uid)) {
                int i = 1;
                for (Long messageUid : this.mailMessages.keySet()) {
                    if (messageUid.equals(uid)) {
                        return i;
                    }
                    ++i;
                }
            }
            throw new FolderException("No such message.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoredMessage> getMessages(MsgRangeFilter range) {
        ArrayList<StoredMessage> messagesInRange = new ArrayList<StoredMessage>();
        int i = 0;
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            for (StoredMessage message : this.mailMessages.values()) {
                if (range.includes(i)) {
                    messagesInRange.add(message);
                }
                ++i;
            }
        }
        return messagesInRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoredMessage> getMessages() {
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            return new ArrayList<StoredMessage>(this.mailMessages.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getMessageUids() {
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            long[] uids = new long[this.mailMessages.size()];
            int i = 0;
            for (Long uid : this.mailMessages.keySet()) {
                uids[i] = uid;
                ++i;
            }
            return uids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expunge(List<FolderListener> mailboxListeners) {
        int i = 1;
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            Iterator<Map.Entry<Long, StoredMessage>> messageEntryIt = this.mailMessages.entrySet().iterator();
            while (messageEntryIt.hasNext()) {
                Map.Entry<Long, StoredMessage> messageEntry = messageEntryIt.next();
                if (messageEntry.getValue().isSet(Flags.Flag.DELETED)) {
                    List<FolderListener> list = mailboxListeners;
                    synchronized (list) {
                        messageEntryIt.remove();
                        for (FolderListener expungeListener : mailboxListeners) {
                            expungeListener.expunged(i);
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredMessage get(int messageIndex) {
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            int i = 0;
            for (StoredMessage message : this.mailMessages.values()) {
                if (messageIndex == i) {
                    return message;
                }
                ++i;
            }
        }
        throw new IllegalArgumentException(String.format("No message with index %d found", messageIndex));
    }

    @Override
    public Iterator<StoredMessage> iterator() {
        return this.mailMessages.values().iterator();
    }
}

