/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.store.MailMessageAttributes;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.strings.JavaEscape;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMessageAttributes
implements MailMessageAttributes {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String SP = " ";
    private static final String NIL = "NIL";
    private static final String Q = "\"";
    private static final String LB = "(";
    private static final String RB = ")";
    private static final String MULTIPART = "MULTIPART";
    private static final String MESSAGE = "MESSAGE";
    private int uid;
    private int messageSequenceNumber;
    private Date receivedDate;
    private String bodyStructure;
    private String envelope;
    private int size;
    private int lineCount;
    public MailMessageAttributes[] parts;
    private List<String> headers;
    private String subject;
    private String[] from;
    private String[] sender;
    private String[] replyTo;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private String[] inReplyTo;
    private String[] date;
    private String[] messageID;
    private String contentType;
    private String primaryType;
    private String secondaryType;
    private Set<String> parameters;
    private String contentID;
    private String contentDesc;
    private String contentEncoding;
    private String receivedDateString;
    private String sentDateEnvelopeString;
    private Header contentDisposition;

    SimpleMessageAttributes(MimeMessage msg, Date receivedDate) throws MessagingException {
        Date sentDate = SimpleMessageAttributes.getSentDate(msg, receivedDate);
        this.receivedDate = receivedDate;
        this.receivedDateString = new MailDateFormat().format(receivedDate);
        this.sentDateEnvelopeString = new MailDateFormat().format(sentDate);
        if (msg != null) {
            this.parseMimePart((MimePart)msg);
        }
    }

    private static Date getSentDate(MimeMessage msg, Date defaultVal) {
        if (msg == null) {
            return defaultVal;
        }
        try {
            Date sentDate = msg.getSentDate();
            if (sentDate == null) {
                return defaultVal;
            }
            return sentDate;
        }
        catch (MessagingException me) {
            return new Date();
        }
    }

    void setUID(int thisUID) {
        this.uid = thisUID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseMimePart(MimePart part) throws MessagingException {
        block43: {
            block42: {
                this.size = GreenMailUtil.getBody((Part)part).length();
                if (part instanceof MimeMessage) {
                    try {
                        this.subject = part.getHeader("Subject")[0];
                    }
                    catch (MessagingException messagingException) {
                        // empty catch block
                    }
                }
                try {
                    this.from = part.getHeader("From");
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.sender = part.getHeader("Sender");
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.replyTo = part.getHeader("Reply To");
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.to = part.getHeader("To");
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.cc = part.getHeader("Cc");
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.bcc = part.getHeader("Bcc");
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.inReplyTo = part.getHeader("In Reply To");
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.date = part.getHeader("Date");
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.messageID = part.getHeader("Message-ID");
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                String contentTypeLine = null;
                try {
                    contentTypeLine = part.getContentType();
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                if (contentTypeLine != null) {
                    this.decodeContentType(contentTypeLine);
                }
                try {
                    this.contentID = part.getContentID();
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.contentDesc = part.getDescription();
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.contentEncoding = part.getEncoding();
                    if (this.contentEncoding == null) {
                        this.contentEncoding = "7BIT";
                    }
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                try {
                    this.contentDisposition = Header.create(part.getHeader("Content-Disposition"));
                }
                catch (MessagingException me) {
                    if (!this.log.isDebugEnabled()) break block42;
                    this.log.debug("Can not create content disposition for part " + part, (Throwable)me);
                }
            }
            try {
                this.lineCount = this.getLineCount(part);
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block43;
                this.log.debug("Can not get line count for part " + part, (Throwable)e);
            }
        }
        if (this.primaryType.equalsIgnoreCase(MULTIPART)) {
            try {
                MimeMultipart container = (MimeMultipart)part.getContent();
                int count = container.getCount();
                this.parts = new SimpleMessageAttributes[count];
                for (int i = 0; i < count; ++i) {
                    BodyPart nextPart = container.getBodyPart(i);
                    if (!(nextPart instanceof MimePart)) continue;
                    SimpleMessageAttributes partAttrs = new SimpleMessageAttributes(null, this.receivedDate);
                    partAttrs.parseMimePart((MimePart)nextPart);
                    this.parts[i] = partAttrs;
                }
                return;
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) return;
                this.log.debug("Can not recurse through multipart content", (Throwable)e);
                return;
            }
        } else {
            if (!this.primaryType.equalsIgnoreCase("message")) return;
            if (this.secondaryType.equalsIgnoreCase("RFC822")) {
                this.log.warn("Unknown/unhandled subtype " + this.secondaryType + " of message encountered.");
                return;
            } else {
                this.log.warn("Unknown/unhandled subtype " + this.secondaryType + " of message encountered.");
            }
        }
    }

    private int getLineCount(MimePart part) throws MessagingException {
        return GreenMailUtil.getLineCount(GreenMailUtil.getBody((Part)part));
    }

    String parseEnvelope() {
        ArrayList<String> response = new ArrayList<String>();
        response.add("(\"" + this.sentDateEnvelopeString + Q + SP);
        if (this.subject != null && this.subject.length() != 0) {
            response.add(Q + JavaEscape.escapeJava(this.subject) + Q + SP);
        } else {
            response.add("NIL ");
        }
        if (this.from != null && this.from.length > 0) {
            response.add(LB);
            for (String aFrom : this.from) {
                response.add(this.parseAddress(aFrom));
            }
            response.add(RB);
        } else {
            response.add(NIL);
        }
        response.add(SP);
        if (this.sender != null && this.sender.length > 0) {
            if (this.sender[0].indexOf(64) == -1) {
                response.add(LB + (String)response.get(3) + RB);
            } else {
                response.add(LB);
                for (String aSender : this.sender) {
                    response.add(this.parseAddress(aSender));
                }
                response.add(RB);
            }
        } else if (this.from != null && this.from.length > 0) {
            response.add(LB + (String)response.get(3) + RB);
        } else {
            response.add(NIL);
        }
        response.add(SP);
        if (this.replyTo != null && this.replyTo.length > 0) {
            if (this.replyTo[0].indexOf(64) == -1) {
                response.add(LB + (String)response.get(3) + RB);
            } else {
                response.add(LB);
                for (String aReplyTo : this.replyTo) {
                    response.add(this.parseAddress(aReplyTo));
                }
                response.add(RB);
            }
        } else if (this.from != null && this.from.length > 0) {
            response.add(LB + (String)response.get(3) + RB);
        } else {
            response.add(NIL);
        }
        response.add(SP);
        if (this.to != null && this.to.length > 0) {
            response.add(LB);
            for (String aTo : this.to) {
                response.add(this.parseAddress(aTo));
            }
            response.add(RB);
        } else {
            response.add(NIL);
        }
        response.add(SP);
        if (this.cc != null && this.cc.length > 0) {
            response.add(LB);
            for (String aCc : this.cc) {
                response.add(this.parseAddress(aCc));
            }
            response.add(RB);
        } else {
            response.add(NIL);
        }
        response.add(SP);
        if (this.bcc != null && this.bcc.length > 0) {
            response.add(LB);
            for (String aBcc : this.bcc) {
                response.add(this.parseAddress(aBcc));
            }
            response.add(RB);
        } else {
            response.add(NIL);
        }
        response.add(SP);
        if (this.inReplyTo != null && this.inReplyTo.length > 0) {
            response.add(this.inReplyTo[0]);
        } else {
            response.add(NIL);
        }
        response.add(SP);
        if (this.messageID != null && this.messageID.length > 0) {
            this.messageID[0] = JavaEscape.escapeJava(this.messageID[0]);
            response.add(Q + this.messageID[0] + Q);
        } else {
            response.add(NIL);
        }
        response.add(RB);
        StringBuilder buf = new StringBuilder(16 * response.size());
        for (String aResponse : response) {
            buf.append(aResponse);
        }
        return buf.toString();
    }

    String parseAddress(String address) {
        int comma = address.indexOf(44);
        StringBuilder buf = new StringBuilder();
        if (comma == -1) {
            InternetAddress netAddr;
            buf.append(LB);
            try {
                netAddr = new InternetAddress(address);
            }
            catch (AddressException ae) {
                return null;
            }
            String personal = netAddr.getPersonal();
            if (personal != null && personal.length() != 0) {
                buf.append(Q).append(personal).append(Q);
            } else {
                buf.append(NIL);
            }
            buf.append(SP);
            buf.append(NIL);
            buf.append(SP);
            try {
                MailAddress mailAddr = new MailAddress(netAddr.getAddress().replaceAll(Q, ""));
                buf.append(Q).append(mailAddr.getUser()).append(Q);
                buf.append(SP);
                buf.append(Q).append(mailAddr.getHost()).append(Q);
            }
            catch (Exception pe) {
                buf.append("NIL NIL");
            }
            buf.append(RB);
        } else {
            buf.append(this.parseAddress(address.substring(0, comma)));
            buf.append(SP);
            buf.append(this.parseAddress(address.substring(comma + 1)));
        }
        return buf.toString();
    }

    void decodeContentType(String rawLine) {
        int slash = rawLine.indexOf(47);
        if (slash == -1) {
            return;
        }
        this.primaryType = rawLine.substring(0, slash).trim();
        int semicolon = rawLine.indexOf(59);
        if (semicolon == -1) {
            this.secondaryType = rawLine.substring(slash + 1).trim();
            return;
        }
        this.secondaryType = rawLine.substring(slash + 1, semicolon).trim();
        Header h = new Header(rawLine);
        this.parameters = h.getParams();
    }

    String parseBodyFields() {
        StringBuilder buf = new StringBuilder();
        this.getParameters(buf);
        buf.append(SP);
        if (this.contentID == null) {
            buf.append(NIL);
        } else {
            buf.append(Q).append(this.contentID).append(Q);
        }
        buf.append(SP);
        if (this.contentDesc == null) {
            buf.append(NIL);
        } else {
            buf.append(Q).append(this.contentDesc).append(Q);
        }
        buf.append(SP);
        if (this.contentEncoding == null) {
            buf.append(NIL);
        } else {
            buf.append(Q).append(this.contentEncoding).append(Q);
        }
        buf.append(SP);
        buf.append(this.size);
        return buf.toString();
    }

    private void getParameters(StringBuilder buf) {
        if (this.parameters == null || this.parameters.isEmpty()) {
            buf.append(NIL);
        } else {
            buf.append(LB);
            Iterator<String> it = this.parameters.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
                if (!it.hasNext()) continue;
                buf.append(SP);
            }
            buf.append(RB);
        }
    }

    String parseBodyStructure(boolean includeExtension) {
        try {
            String fields = this.parseBodyFields();
            StringBuilder buf = new StringBuilder();
            buf.append(LB);
            if (this.primaryType.equalsIgnoreCase("Text")) {
                buf.append("\"TEXT\" \"");
                buf.append(this.secondaryType.toUpperCase());
                buf.append("\" ");
                buf.append(fields);
                buf.append(' ');
                buf.append(this.lineCount);
            } else if (this.primaryType.equalsIgnoreCase(MESSAGE) && this.secondaryType.equalsIgnoreCase("rfc822")) {
                buf.append("\"MESSAGE\" \"RFC822\" ");
                buf.append(fields).append(SP);
                buf.append(this.parts[0].getEnvelope()).append(SP);
                buf.append(this.parts[0].getBodyStructure(false)).append(SP);
                buf.append(this.lineCount);
            } else if (this.primaryType.equalsIgnoreCase(MULTIPART)) {
                for (MailMessageAttributes part : this.parts) {
                    buf.append(part.getBodyStructure(includeExtension));
                }
                buf.append(" \"").append(this.secondaryType).append(Q);
            } else {
                buf.append('\"');
                buf.append(this.primaryType.toUpperCase());
                buf.append('\"');
                buf.append(" \"");
                buf.append(this.secondaryType.toUpperCase());
                buf.append('\"');
                buf.append(' ');
                this.getParameters(buf);
                buf.append(' ');
                buf.append(NIL);
                buf.append(' ');
                if (null != this.contentDesc) {
                    buf.append('\"');
                    buf.append(this.contentDesc);
                    buf.append('\"');
                } else {
                    buf.append(NIL);
                }
                buf.append(' ');
                if (null != this.contentEncoding) {
                    buf.append('\"');
                    buf.append(this.contentEncoding);
                    buf.append('\"');
                } else {
                    buf.append(NIL);
                }
                buf.append(' ');
                buf.append(this.size);
            }
            if (includeExtension) {
                if (this.primaryType.equalsIgnoreCase(MULTIPART)) {
                    buf.append(' ');
                    this.getParameters(buf);
                    buf.append(' ');
                    if (null != this.contentDisposition) {
                        buf.append(this.contentDisposition);
                    } else {
                        buf.append(NIL);
                    }
                    buf.append(' ');
                    buf.append(NIL);
                } else {
                    buf.append(' ');
                    buf.append(NIL);
                    buf.append(' ');
                    if (null != this.contentDisposition) {
                        buf.append(this.contentDisposition);
                    } else {
                        buf.append(NIL);
                    }
                    buf.append(' ');
                    buf.append(NIL);
                }
            }
            buf.append(RB);
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not parse body structure", e);
        }
    }

    public int getMessageSequenceNumber() {
        return this.messageSequenceNumber;
    }

    void setMessageSequenceNumber(int newMsn) {
        this.messageSequenceNumber = newMsn;
    }

    public int getUID() {
        return this.uid;
    }

    @Override
    public Date getReceivedDate() {
        return this.receivedDate;
    }

    @Override
    public String getReceivedDateAsString() {
        return this.receivedDateString;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getEnvelope() {
        return this.parseEnvelope();
    }

    @Override
    public String getBodyStructure(boolean includeExtensions) {
        return this.parseBodyStructure(includeExtensions);
    }

    private static class Header {
        String value;
        Set<String> params = null;

        public Header(String line) {
            String[] strs = line.split(";");
            this.value = strs[0];
            if (0 != strs.length) {
                this.params = new HashSet<String>(strs.length);
                for (int i = 1; i < strs.length; ++i) {
                    String p = strs[i].trim();
                    int e = p.indexOf(61);
                    String key = p.substring(0, e);
                    String val = p.substring(e + 1, p.length());
                    p = SimpleMessageAttributes.Q + this.strip(key) + SimpleMessageAttributes.Q + SimpleMessageAttributes.SP + SimpleMessageAttributes.Q + this.strip(val) + SimpleMessageAttributes.Q;
                    this.params.add(p);
                }
            }
        }

        public Set<String> getParams() {
            return this.params;
        }

        private String strip(String s) {
            return s.trim().replaceAll("\\\"", "");
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            if (null == this.params) {
                ret.append(SimpleMessageAttributes.Q).append(this.value).append(SimpleMessageAttributes.Q);
            } else if (this.params.isEmpty()) {
                ret.append(SimpleMessageAttributes.NIL);
            } else {
                ret.append(SimpleMessageAttributes.LB);
                ret.append(SimpleMessageAttributes.Q).append(this.value).append("\" ");
                ret.append(SimpleMessageAttributes.LB);
                int i = 0;
                for (String param : this.params) {
                    if (i++ > 0) {
                        ret.append(SimpleMessageAttributes.SP);
                    }
                    ret.append(param);
                }
                ret.append(SimpleMessageAttributes.RB);
                ret.append(SimpleMessageAttributes.RB);
            }
            return ret.toString();
        }

        public static Header create(String[] header) {
            if (null == header || 0 == header.length) {
                return null;
            }
            if (header.length > 1) {
                throw new IllegalArgumentException("Header creation assumes only one occurrence of header instead of " + header.length);
            }
            return new Header(header[0]);
        }
    }
}

