/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.foedus.util;

import com.icegreen.greenmail.foedus.util.Resource;
import com.icegreen.greenmail.util.EncodingUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class StringBufferResource
implements Resource {
    StringWriter currentWriter;
    StringBuilder contentBuffer;

    public StringBufferResource() {
    }

    public StringBufferResource(String initalValue) {
        this.contentBuffer = new StringBuilder(initalValue);
    }

    @Override
    public Writer getWriter() throws IOException {
        this.currentWriter = new StringWriter();
        return this.currentWriter;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.closeInput();
        return new ByteArrayInputStream(this.contentBuffer.toString().getBytes(EncodingUtil.CHARSET_EIGHT_BIT_ENCODING));
    }

    @Override
    public Reader getReader() throws IOException {
        this.closeInput();
        return new StringReader(this.contentBuffer.toString());
    }

    private void closeInput() throws IOException {
        if (this.currentWriter != null) {
            this.contentBuffer = new StringBuilder(this.currentWriter.getBuffer());
            this.currentWriter = null;
        }
        if (this.contentBuffer == null) {
            throw new IOException("No content has been written");
        }
    }

    @Override
    public long getSize() {
        return this.contentBuffer.length();
    }

    @Override
    public String getAsString() throws IOException {
        this.closeInput();
        return this.contentBuffer.toString();
    }

    @Override
    public void delete() {
        this.contentBuffer = null;
        this.currentWriter = null;
    }
}

