/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp;

import com.icegreen.greenmail.smtp.SmtpHandler;
import com.icegreen.greenmail.util.EncodingUtil;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpConnection {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final Logger log = LoggerFactory.getLogger(SmtpConnection.class);
    Socket sock;
    InetAddress clientAddress;
    InternetPrintWriter out;
    BufferedReader in;
    SmtpHandler handler;
    String heloName;

    public SmtpConnection(SmtpHandler handler, Socket sock) throws IOException {
        this.sock = sock;
        sock.setSoTimeout(30000);
        this.clientAddress = sock.getInetAddress();
        OutputStream o = sock.getOutputStream();
        InputStream i = sock.getInputStream();
        this.out = InternetPrintWriter.createForEncoding(o, true, EncodingUtil.CHARSET_EIGHT_BIT_ENCODING);
        this.in = new BufferedReader(new InputStreamReader(i));
        this.handler = handler;
    }

    public void send(String line) {
        log.trace("S: {}", (Object)line);
        this.out.println(line);
    }

    public BufferedReader getReader() {
        return this.in;
    }

    public String receiveLine() throws IOException {
        String line = this.in.readLine();
        log.trace("C: {}", (Object)line);
        return line;
    }

    public String getClientAddress() {
        return this.clientAddress.getHostAddress();
    }

    public InetAddress getServerAddress() {
        return this.sock.getLocalAddress();
    }

    public String getServerGreetingsName() {
        InetAddress address = this.getServerAddress();
        if (address != null) {
            return address.toString();
        }
        return System.getProperty("user.name");
    }

    public String getHeloName() {
        return this.heloName;
    }

    public void setHeloName(String n) {
        this.heloName = n;
    }

    public void quit() {
        this.handler.close();
    }
}

