/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PropertiesBasedServerSetupBuilder {
    public static final String GREENMAIL_VERBOSE = "greenmail.verbose";

    public ServerSetup[] build(Properties properties) {
        ArrayList<ServerSetup> serverSetups = new ArrayList<ServerSetup>();
        String hostname = properties.getProperty("greenmail.hostname", ServerSetup.getLocalHostAddress());
        long serverStartupTimeout = Long.parseLong(properties.getProperty("greenmail.startup.timeout", "-1"));
        this.addDefaultSetups(hostname, properties, serverSetups);
        this.addTestSetups(hostname, properties, serverSetups);
        for (String protocol : ServerSetup.PROTOCOLS) {
            this.addSetup(hostname, protocol, properties, serverSetups);
        }
        for (ServerSetup setup : serverSetups) {
            if (properties.containsKey(GREENMAIL_VERBOSE)) {
                setup.setVerbose(true);
            }
            if (serverStartupTimeout < 0L) continue;
            setup.setServerStartupTimeout(serverStartupTimeout);
        }
        return serverSetups.toArray(new ServerSetup[serverSetups.size()]);
    }

    protected void addSetup(String hostname, String protocol, Properties properties, List<ServerSetup> serverSetups) {
        if (properties.containsKey("greenmail." + protocol + ".port")) {
            int port = Integer.parseInt(properties.getProperty("greenmail." + protocol + ".port"));
            String setupHostname = properties.getProperty("greenmail." + protocol + ".hostname", hostname);
            ServerSetup setup = new ServerSetup(port, setupHostname, protocol);
            serverSetups.add(setup);
        }
    }

    protected void addTestSetups(String hostname, Properties properties, List<ServerSetup> serverSetups) {
        if (properties.containsKey("greenmail.setup.test.all")) {
            for (ServerSetup setup : ServerSetupTest.ALL) {
                serverSetups.add(setup.createCopy(hostname));
            }
        }
        if (properties.containsKey("greenmail.setup.test.smtp")) {
            serverSetups.add(ServerSetupTest.SMTP.createCopy(hostname));
        }
        if (properties.containsKey("greenmail.setup.test.smtps")) {
            serverSetups.add(ServerSetupTest.SMTPS.createCopy(hostname));
        }
        if (properties.containsKey("greenmail.setup.test.pop3")) {
            serverSetups.add(ServerSetupTest.POP3.createCopy(hostname));
        }
        if (properties.containsKey("greenmail.setup.test.pop3s")) {
            serverSetups.add(ServerSetupTest.POP3S.createCopy(hostname));
        }
        if (properties.containsKey("greenmail.setup.test.imap")) {
            serverSetups.add(ServerSetupTest.IMAP.createCopy(hostname));
        }
        if (properties.containsKey("greenmail.setup.test.imaps")) {
            serverSetups.add(ServerSetupTest.IMAPS.createCopy(hostname));
        }
    }

    protected void addDefaultSetups(String hostname, Properties properties, List<ServerSetup> serverSetups) {
        if (properties.containsKey("greenmail.setup.all")) {
            for (ServerSetup setup : ServerSetup.ALL) {
                serverSetups.add(setup.createCopy(hostname));
            }
        }
        if (properties.containsKey("greenmail.setup.smtp")) {
            serverSetups.add(ServerSetup.SMTP.createCopy(hostname));
        }
        if (properties.containsKey("greenmail.setup.smtps")) {
            serverSetups.add(ServerSetup.SMTPS.createCopy(hostname));
        }
        if (properties.containsKey("greenmail.setup.pop3")) {
            serverSetups.add(ServerSetup.POP3.createCopy(hostname));
        }
        if (properties.containsKey("greenmail.setup.pop3s")) {
            serverSetups.add(ServerSetup.POP3S.createCopy(hostname));
        }
        if (properties.containsKey("greenmail.setup.imap")) {
            serverSetups.add(ServerSetup.IMAP.createCopy(hostname));
        }
        if (properties.containsKey("greenmail.setup.imaps")) {
            serverSetups.add(ServerSetup.IMAPS.createCopy(hostname));
        }
    }
}

