/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp.commands;

import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.EncodingUtil;
import com.icegreen.greenmail.util.SaslMessage;
import java.io.IOException;
import java.util.Arrays;

public class AuthCommand
extends SmtpCommand {
    public static final String AUTH_SUCCEDED = "235 2.7.0  Authentication Succeeded";
    public static final String AUTH_CREDENTIALS_INVALID = "535 5.7.8  Authentication credentials invalid";
    public static final String AUTH_ALREADY_AUTHENTICATED = "503 already authenticated";
    public static final String SMTP_SYNTAX_ERROR = "500 syntax error";
    public static final String SMTP_SERVER_CONTINUATION = "334 ";
    public static final String SUPPORTED_AUTH_MECHANISM = AuthCommand.getValuesWsSeparated();

    @Override
    public void execute(SmtpConnection conn, SmtpState state, SmtpManager manager, String commandLine) throws IOException {
        if (conn.isAuthenticated()) {
            conn.send(AUTH_ALREADY_AUTHENTICATED);
            return;
        }
        String[] commandParts = commandLine.split(" ");
        if (commandParts.length < 2) {
            conn.send("500 syntax error : expected mechanism but received <" + commandLine + ">");
            return;
        }
        String authMechanismValue = commandParts[1];
        if (AuthMechanism.LOGIN.name().equalsIgnoreCase(authMechanismValue)) {
            this.authLogin(conn, manager, commandLine, commandParts, authMechanismValue);
        } else if (AuthMechanism.PLAIN.name().equalsIgnoreCase(authMechanismValue)) {
            this.authPlain(conn, manager, commandParts);
        } else {
            conn.send("500 syntax error : Unsupported auth mechanism " + authMechanismValue + ". Only auth mechanism <" + Arrays.toString((Object[])AuthMechanism.values()) + "> supported.");
        }
    }

    private void authPlain(SmtpConnection conn, SmtpManager manager, String[] commandParts) throws IOException {
        String initialResponse;
        if (commandParts.length == 2) {
            conn.send(SMTP_SERVER_CONTINUATION);
            initialResponse = conn.receiveLine();
        } else {
            initialResponse = commandParts[2];
        }
        if (this.authenticate(manager.getUserManager(), EncodingUtil.decodeBase64(initialResponse))) {
            conn.setAuthenticated(true);
            conn.send(AUTH_SUCCEDED);
        } else {
            conn.send(AUTH_CREDENTIALS_INVALID);
        }
    }

    private void authLogin(SmtpConnection conn, SmtpManager manager, String commandLine, String[] commandParts, String authMechanismValue) throws IOException {
        if (commandParts.length != 2) {
            conn.send("500 syntax error : Unsupported auth mechanism " + authMechanismValue + " with unexpected values. Line is: <" + commandLine + ">");
        } else {
            conn.send("334  VXNlciBOYW1lAA==");
            String username = conn.receiveLine();
            conn.send("334  UGFzc3dvcmQA");
            String pwd = conn.receiveLine();
            if (manager.getUserManager().test(EncodingUtil.decodeBase64(username), EncodingUtil.decodeBase64(pwd))) {
                conn.setAuthenticated(true);
                conn.send(AUTH_SUCCEDED);
            } else {
                conn.send(AUTH_CREDENTIALS_INVALID);
            }
        }
    }

    private boolean authenticate(UserManager userManager, String value) {
        SaslMessage saslMessage = SaslMessage.parse(value);
        return userManager.test(saslMessage.getAuthcid(), saslMessage.getPasswd());
    }

    private static String getValuesWsSeparated() {
        StringBuilder buf = new StringBuilder();
        for (AuthMechanism mechanism : AuthMechanism.values()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append((Object)mechanism);
        }
        return buf.toString();
    }

    public static enum AuthMechanism {
        PLAIN,
        LOGIN;

    }
}

