/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.ImapCommand;
import com.icegreen.greenmail.imap.commands.ImapCommandFactory;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImapRequestHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ImapCommandFactory imapCommands = new ImapCommandFactory();
    private final CommandParser parser = new CommandParser();
    private static final String REQUEST_SYNTAX = "Protocol Error: Was expecting <tag SPACE command [arguments]>";

    public boolean handleRequest(InputStream input, OutputStream output, ImapSession session) throws ProtocolException {
        ImapRequestLineReader request = new ImapRequestLineReader(input, output);
        try {
            request.nextChar();
        }
        catch (ProtocolException e) {
            return false;
        }
        ImapResponse response = new ImapResponse(output);
        this.doProcessRequest(request, response, session);
        request.consumeLine();
        return true;
    }

    private void doProcessRequest(ImapRequestLineReader request, ImapResponse response, ImapSession session) {
        String commandName;
        String tag;
        try {
            tag = this.parser.tag(request);
        }
        catch (ProtocolException e) {
            response.badResponse(REQUEST_SYNTAX);
            return;
        }
        response.setTag(tag);
        try {
            commandName = this.parser.atom(request);
        }
        catch (ProtocolException e) {
            response.commandError(REQUEST_SYNTAX);
            return;
        }
        ImapCommand command = this.imapCommands.getCommand(commandName);
        if (command == null) {
            this.log.error("Command '{}' not valid", (Object)commandName);
            response.commandError("Invalid command.");
            return;
        }
        if (!command.validForState(session.getState())) {
            this.log.error("Command '{}' not valid in this state {}", (Object)commandName, (Object)session.getState());
            response.commandFailed(command, "Command not valid in this state");
            return;
        }
        command.process(request, response, session);
    }
}

