/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import java.util.ArrayList;
import java.util.List;

class CopyCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "COPY";
    public static final String ARGS = "<message-set> <mailbox>";

    CopyCommand() {
        super(NAME, ARGS);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    @Override
    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        long[] uids;
        MailFolder toFolder;
        IdRange[] idSet = this.parser.parseIdRange(request);
        String mailboxName = this.parser.mailbox(request);
        this.parser.endLine(request);
        ImapSessionFolder currentMailbox = session.getSelected();
        try {
            toFolder = this.getMailbox(mailboxName, session, true);
        }
        catch (FolderException e) {
            e.setResponseCode("TRYCREATE");
            throw e;
        }
        ArrayList<Long> copiedUidsOld = new ArrayList<Long>();
        ArrayList<Long> copiedUidsNew = new ArrayList<Long>();
        for (long uid : uids = currentMailbox.getMessageUids()) {
            boolean inSet;
            if (useUids) {
                inSet = this.includes(idSet, uid);
            } else {
                int msn = currentMailbox.getMsn(uid);
                inSet = this.includes(idSet, msn);
            }
            if (!inSet) continue;
            long copiedUid = currentMailbox.copyMessage(uid, toFolder);
            copiedUidsOld.add(uid);
            copiedUidsNew.add(copiedUid);
        }
        session.unsolicitedResponses(response);
        response.commandComplete(this, this.generateCopyUidResponseCode(currentMailbox, copiedUidsOld, copiedUidsNew));
    }

    private String generateCopyUidResponseCode(ImapSessionFolder currentMailbox, List<Long> copiedUidsFrom, List<Long> copiedUidsTo) {
        return "COPYUID " + currentMailbox.getUidValidity() + " " + IdRange.uidsToRangeString(copiedUidsFrom) + " " + IdRange.uidsToRangeString(copiedUidsTo);
    }
}

