/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp;

import com.icegreen.greenmail.smtp.SmtpHandler;
import com.icegreen.greenmail.util.EncodingUtil;
import com.icegreen.greenmail.util.InternetPrintWriter;
import com.icegreen.greenmail.util.LoggingInputStream;
import com.icegreen.greenmail.util.LoggingOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpConnection {
    private static final Logger log = LoggerFactory.getLogger(SmtpConnection.class);
    Socket sock;
    InetAddress clientAddress;
    InternetPrintWriter out;
    BufferedInputStream in;
    SmtpHandler handler;
    String heloName;
    boolean authenticated;
    private static final int CR_LF_DOT = 854574;
    private static final int CR_LF_DOT_CR = 218770957;

    public SmtpConnection(SmtpHandler handler, Socket sock) throws IOException {
        this.sock = sock;
        this.clientAddress = sock.getInetAddress();
        OutputStream o = sock.getOutputStream();
        if (log.isDebugEnabled()) {
            o = new LoggingOutputStream(o, "S: ");
        }
        this.out = InternetPrintWriter.createForEncoding(o, true, EncodingUtil.CHARSET_EIGHT_BIT_ENCODING);
        InputStream is = sock.getInputStream();
        if (log.isDebugEnabled()) {
            is = new LoggingInputStream(is, "C: ");
        }
        this.in = new BufferedInputStream(is);
        this.handler = handler;
    }

    public void send(String line) {
        this.out.println(line);
    }

    public String readLine() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
        try {
            while (true) {
                int b;
                if ((b = this.in.read()) < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unexpected end of stream, read {} bytes: {}", (Object)bos.size(), (Object)bos.toString());
                    }
                    if (bos.size() > 0) {
                        return bos.toString(StandardCharsets.US_ASCII.name());
                    }
                    return null;
                }
                if (b == 13) {
                    b = this.in.read();
                    if (b == 10) {
                        return bos.toString(StandardCharsets.US_ASCII.name());
                    }
                    bos.write(13);
                }
                bos.write(b);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Can not read line, read " + bos.size() + " bytes: " + bos.toString(), ex);
        }
    }

    public InputStream dotLimitedInputStream(byte[] initialContent) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        try {
            bos.write(initialContent);
            int cbuf = 0;
            while (true) {
                int b;
                if ((b = this.in.read()) < 0) {
                    throw new IllegalStateException("Unexpected end of stream, read " + bos.size() + " bytes: " + bos.toString());
                }
                if (cbuf == 218770957 && b == 10) {
                    byte[] buf = bos.toByteArray();
                    int maxLen = Math.min(bos.size(), bos.size() - 2);
                    return new ByteArrayInputStream(buf, 0, maxLen);
                }
                if ((cbuf & 0xFFFFFF) != 854574 || b != 46) {
                    bos.write(b);
                }
                cbuf = cbuf << 8 | b;
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Can not read line, read " + bos.size() + " bytes: " + bos.toString(), ex);
        }
    }

    public String getClientAddress() {
        return this.clientAddress.getHostAddress();
    }

    public InetAddress getServerAddress() {
        return this.sock.getLocalAddress();
    }

    public String getServerGreetingsName() {
        InetAddress address = this.getServerAddress();
        if (address != null) {
            return address.toString();
        }
        return System.getProperty("user.name");
    }

    public String getHeloName() {
        return this.heloName;
    }

    public void setHeloName(String n) {
        this.heloName = n;
    }

    public void quit() {
        this.handler.close();
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }
}

