/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.commands.AppendCommand;
import com.icegreen.greenmail.imap.commands.AuthenticateCommand;
import com.icegreen.greenmail.imap.commands.CapabilityCommand;
import com.icegreen.greenmail.imap.commands.CheckCommand;
import com.icegreen.greenmail.imap.commands.CloseCommand;
import com.icegreen.greenmail.imap.commands.CopyCommand;
import com.icegreen.greenmail.imap.commands.CreateCommand;
import com.icegreen.greenmail.imap.commands.DeleteCommand;
import com.icegreen.greenmail.imap.commands.ExamineCommand;
import com.icegreen.greenmail.imap.commands.ExpungeCommand;
import com.icegreen.greenmail.imap.commands.FetchCommand;
import com.icegreen.greenmail.imap.commands.IdleCommand;
import com.icegreen.greenmail.imap.commands.ImapCommand;
import com.icegreen.greenmail.imap.commands.ListCommand;
import com.icegreen.greenmail.imap.commands.LoginCommand;
import com.icegreen.greenmail.imap.commands.LogoutCommand;
import com.icegreen.greenmail.imap.commands.LsubCommand;
import com.icegreen.greenmail.imap.commands.NoopCommand;
import com.icegreen.greenmail.imap.commands.QuotaCommand;
import com.icegreen.greenmail.imap.commands.QuotaRootCommand;
import com.icegreen.greenmail.imap.commands.RenameCommand;
import com.icegreen.greenmail.imap.commands.SearchCommand;
import com.icegreen.greenmail.imap.commands.SelectCommand;
import com.icegreen.greenmail.imap.commands.SetQuotaCommand;
import com.icegreen.greenmail.imap.commands.SortCommand;
import com.icegreen.greenmail.imap.commands.StatusCommand;
import com.icegreen.greenmail.imap.commands.StoreCommand;
import com.icegreen.greenmail.imap.commands.SubscribeCommand;
import com.icegreen.greenmail.imap.commands.UidCommand;
import com.icegreen.greenmail.imap.commands.UnsubscribeCommand;
import java.util.HashMap;
import java.util.Map;

public class ImapCommandFactory {
    private final Map<String, Class<? extends ImapCommand>> imapCommands = new HashMap<String, Class<? extends ImapCommand>>();

    public ImapCommandFactory() {
        this.imapCommands.put("CAPABILITY", CapabilityCommand.class);
        this.imapCommands.put("NOOP", NoopCommand.class);
        this.imapCommands.put("LOGOUT", LogoutCommand.class);
        this.imapCommands.put("AUTHENTICATE", AuthenticateCommand.class);
        this.imapCommands.put("LOGIN", LoginCommand.class);
        this.imapCommands.put("SELECT", SelectCommand.class);
        this.imapCommands.put("EXAMINE", ExamineCommand.class);
        this.imapCommands.put("CREATE", CreateCommand.class);
        this.imapCommands.put("DELETE", DeleteCommand.class);
        this.imapCommands.put("RENAME", RenameCommand.class);
        this.imapCommands.put("SUBSCRIBE", SubscribeCommand.class);
        this.imapCommands.put("UNSUBSCRIBE", UnsubscribeCommand.class);
        this.imapCommands.put("LIST", ListCommand.class);
        this.imapCommands.put("LSUB", LsubCommand.class);
        this.imapCommands.put("STATUS", StatusCommand.class);
        this.imapCommands.put("APPEND", AppendCommand.class);
        this.imapCommands.put("CHECK", CheckCommand.class);
        this.imapCommands.put("CLOSE", CloseCommand.class);
        this.imapCommands.put("EXPUNGE", ExpungeCommand.class);
        this.imapCommands.put("COPY", CopyCommand.class);
        this.imapCommands.put("SEARCH", SearchCommand.class);
        this.imapCommands.put("FETCH", FetchCommand.class);
        this.imapCommands.put("STORE", StoreCommand.class);
        this.imapCommands.put("UID", UidCommand.class);
        this.imapCommands.put("SORT", SortCommand.class);
        this.imapCommands.put("SETQUOTA", SetQuotaCommand.class);
        this.imapCommands.put("QUOTA", QuotaCommand.class);
        this.imapCommands.put("GETQUOTAROOT", QuotaRootCommand.class);
        this.imapCommands.put("IDLE", IdleCommand.class);
    }

    public ImapCommand getCommand(String commandName) {
        Class<? extends ImapCommand> cmdClass = this.imapCommands.get(commandName.toUpperCase());
        if (cmdClass == null) {
            return null;
        }
        return this.createCommand(cmdClass);
    }

    private ImapCommand createCommand(Class<? extends ImapCommand> commandClass) {
        try {
            ImapCommand cmd = commandClass.newInstance();
            if (cmd instanceof UidCommand) {
                ((UidCommand)cmd).setCommandFactory(this);
            }
            return cmd;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not create command instance " + commandClass.getName(), e);
        }
    }
}

