/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvngolang.AbstractPackageGolangMojo;
import com.igormaznitsa.mvngolang.cvs.CVSType;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.zeroturnaround.exec.ProcessResult;

@Mojo(name="get", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE)
public class GolangGetMojo
extends AbstractPackageGolangMojo {
    private static final Pattern PATTERN_NO_SUBMODULE_MAPPING_FOUND_IN_GIT = Pattern.compile("no\\s+submodule\\s+mapping\\s+found\\s+in\\s+.gitmodules for path\\s+\\'([\\S]+?)\\'", 10);
    private static final Pattern PATTERN_EXTRACT_PACKAGE_AND_STATUS = Pattern.compile("^package ([\\S]+?)\\s*:\\s*exit\\s+status\\s+([\\d]+?)\\s*$", 10);
    @Parameter(name="autofixGitCache", defaultValue="false")
    private boolean autofixGitCache;
    @Parameter(name="branch")
    private String branch;
    @Parameter(name="tag")
    private String tag;
    @Parameter(name="revision")
    private String revision;
    @Parameter(name="customCvsOptions")
    private String[] customCvsOptions;
    @Parameter(name="cvsExe")
    private String cvsExe;
    @Parameter(name="enforceDeletePackageFiles")
    private boolean enforceDeletePackageFiles;
    @Parameter(name="deleteCommonPkg", defaultValue="false")
    private boolean deleteCommonPkg;
    @Parameter(name="relativePathToCvsFolder")
    private String relativePathToCvsFolder;
    @Parameter(name="disableCvsAutosearch", defaultValue="false")
    private boolean disableCvsAutosearch;

    @Nonnull
    private static String processSlashes(@Nonnull String str) {
        char last;
        StringBuilder result = new StringBuilder();
        boolean check = true;
        for (char c : str.toCharArray()) {
            if (check) {
                if (c == '\\' || c == '/') continue;
                check = false;
            }
            if (c == '\\' || c == '/') {
                result.append(File.separatorChar);
                continue;
            }
            result.append(c);
        }
        while (result.length() > 0 && ((last = result.charAt(result.length() - 1)) == '/' || last == '\\')) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private static synchronized boolean processCVS(@Nonnull GolangGetMojo instance, @Nullable ProxySettings proxySettings, @Nonnull File goPath) {
        String[] packages = instance.getPackages();
        if (packages != null && packages.length > 0) {
            for (String p : packages) {
                File rootCvsFolder = instance.makePathToPackageSources(goPath, p);
                if (instance.getRelativePathToCvsFolder() == null) {
                    File file = rootCvsFolder = instance.isDisableCvsAutosearch() ? rootCvsFolder : instance.findRootCvsFolderForPackageSources(goPath, rootCvsFolder);
                }
                if (rootCvsFolder == null) {
                    instance.getLog().error((CharSequence)("Can't find CVS folder in hierarchy for package '" + p + "' [" + rootCvsFolder + ']'));
                    return false;
                }
                instance.getLog().info((CharSequence)("CVS folder for processing is : " + rootCvsFolder));
                if (!rootCvsFolder.isDirectory()) {
                    instance.getLog().error((CharSequence)String.format("Can't find CVS folder for package '%s' at '%s'", p, rootCvsFolder.getAbsolutePath()));
                    return false;
                }
                CVSType repo = CVSType.investigateFolder(rootCvsFolder);
                if (repo == CVSType.UNKNOWN) {
                    instance.getLog().error((CharSequence)("Can't recognize CVS in the folder : " + rootCvsFolder + " (for package '" + p + "')"));
                    instance.getLog().error((CharSequence)"May be to define folder directly through <relativePathToCvsFolder>...</relativePathToCvsFolder>!");
                    return false;
                }
                boolean hasCvsRequisite = instance.branch != null || instance.tag != null || instance.revision != null;
                Object[] customcvs = instance.customCvsOptions;
                if (customcvs == null && !hasCvsRequisite) continue;
                if (!repo.getProcessor().prepareFolder(instance.getLog(), proxySettings, instance.getCvsExe(), rootCvsFolder)) {
                    instance.getLog().debug((CharSequence)("Can't prepare folder : " + rootCvsFolder));
                    return false;
                }
                if (customcvs != null && hasCvsRequisite) {
                    instance.getLog().warn((CharSequence)"CVS branch, tag or revision are ignored for provided custom CVS options!");
                }
                if (customcvs != null) {
                    instance.getLog().info((CharSequence)("Custom CVS options : " + Arrays.toString(customcvs)));
                    if (repo.getProcessor().processCVSForCustomOptions(instance.getLog(), proxySettings, rootCvsFolder, instance.getCvsExe(), (String[])customcvs)) continue;
                    return false;
                }
                if (instance.branch == null && instance.tag == null && instance.revision == null) continue;
                instance.getLog().info((CharSequence)String.format("Switch '%s' to branch = '%s', tag = '%s', revision = '%s'", p, GetUtils.ensureNonNull((Object)instance.branch, (Object)"_"), GetUtils.ensureNonNull((Object)instance.tag, (Object)"_"), GetUtils.ensureNonNull((Object)instance.revision, (Object)"_")));
                if (repo.getProcessor().processCVSRequisites(instance.getLog(), proxySettings, instance.getCvsExe(), rootCvsFolder, instance.branch, instance.tag, instance.revision)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDisableCvsAutosearch() {
        return this.disableCvsAutosearch;
    }

    public boolean getDeleteCommonPkg() {
        return this.deleteCommonPkg;
    }

    @Nullable
    @MustNotContainNull
    public String[] getCustomCvsOptions() {
        return this.customCvsOptions;
    }

    @Nullable
    public String getRelativePathToCvsFolder() {
        return this.relativePathToCvsFolder;
    }

    public boolean isAutoFixGitCache() {
        return this.autofixGitCache;
    }

    public boolean isEnforceDeletePackageFiles() {
        return this.enforceDeletePackageFiles;
    }

    @Nullable
    public String getRevision() {
        return this.revision;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Nullable
    public String getTag() {
        return this.tag;
    }

    @Nullable
    public String getCvsExe() {
        return this.cvsExe;
    }

    @Override
    @Nonnull
    public String getGoCommand() {
        return "get";
    }

    @Override
    public boolean enforcePrintOutput() {
        return true;
    }

    @Override
    public boolean isMojoMustNotBeExecuted() throws MojoFailureException {
        boolean result;
        String[] packages = this.getTailArguments();
        if (packages.length == 0) {
            this.getLog().info((CharSequence)"There are no packages to get");
            result = true;
        } else {
            result = super.isMojoMustNotBeExecuted();
        }
        return result;
    }

    @Nonnull
    @MustNotContainNull
    private List<String> extractProblemPackagesFromErrorLog(@Nonnull String errorLog) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher extractor = PATTERN_EXTRACT_PACKAGE_AND_STATUS.matcher(errorLog);
        while (extractor.find()) {
            String packageName = extractor.group(1);
            String status = extractor.group(2);
            if ("0".equals(status)) continue;
            result.add(packageName);
        }
        return result;
    }

    @Nullable
    private File findRootCvsFolderForPackageSources(@Nonnull File goPath, @Nullable File packageSourceFolder) {
        File foundFile = null;
        if (packageSourceFolder != null) {
            File srcFolder = this.getSrcFolder(goPath);
            File current = packageSourceFolder;
            while (!srcFolder.equals(current)) {
                if (CVSType.investigateFolder(current) != CVSType.UNKNOWN) {
                    foundFile = current;
                    break;
                }
                current = current.getParentFile();
            }
        }
        return foundFile;
    }

    @Nonnull
    private File getSrcFolder(@Nonnull File goPath) {
        return new File(goPath, "src");
    }

    @Nonnull
    private File makePathToPackageSources(@Nonnull File goPath, @Nonnull String pack) {
        String path = pack.trim();
        String predefinedCvsPath = this.getRelativePathToCvsFolder();
        if (predefinedCvsPath != null) {
            path = GolangGetMojo.processSlashes(predefinedCvsPath);
        } else {
            try {
                URI uri = URI.create(path);
                path = GolangGetMojo.processSlashes(uri.getPath());
            }
            catch (IllegalArgumentException ex) {
                path = GolangGetMojo.processSlashes(path);
            }
        }
        return new File(this.getSrcFolder(goPath), path);
    }

    @Nonnull
    private File makePathToPackageCompiled(@Nonnull File goPath, @Nonnull String pack) {
        String path = pack.trim();
        try {
            URI uri = URI.create(path);
            path = GolangGetMojo.processSlashes(uri.getPath());
        }
        catch (IllegalArgumentException ex) {
            path = GolangGetMojo.processSlashes(path);
        }
        return new File(goPath, "pkg" + File.separatorChar + this.getOs() + '_' + this.getArch() + File.separatorChar + path);
    }

    private boolean tryToFixGitCacheErrorsForPackages(@Nonnull @MustNotContainNull List<String> packages) throws IOException {
        File goPath = this.findGoPath(true);
        int fixed = 0;
        for (String s : packages) {
            File packageFolder = this.makePathToPackageSources(goPath, s);
            CVSType repo = CVSType.investigateFolder(packageFolder);
            if (repo == CVSType.GIT) {
                this.getLog().warn((CharSequence)String.format("Executing 'git rm -r --cached .' in %s", packageFolder.getAbsolutePath()));
                int result = repo.getProcessor().execute(this.getCvsExe(), this.getLog(), packageFolder, "rm", "-r", "--cached", ".");
                if (result != 0) {
                    return false;
                }
                ++fixed;
            } else {
                this.getLog().warn((CharSequence)String.format("Folder %s is not GIT repository", packageFolder.getAbsolutePath()));
                return false;
            }
            ++fixed;
        }
        return fixed != 0;
    }

    @Override
    public void beforeExecution(@Nullable ProxySettings proxySettings) throws MojoFailureException, MojoExecutionException {
        String[] customcvs;
        if (this.getDeleteCommonPkg()) {
            File goPath;
            this.getLog().warn((CharSequence)"Request to delete whole common pkg folder");
            try {
                goPath = this.findGoPath(true);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't find $GOPATH", (Exception)ex);
            }
            File pkgBinary = new File(goPath, "pkg");
            if (pkgBinary.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)pkgBinary);
                    this.getLog().warn((CharSequence)("Folder " + pkgBinary + " has been deleted"));
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Can't delete common PKG folder : " + pkgBinary, (Exception)ex);
                }
            } else {
                this.getLog().info((CharSequence)("PKG folder is not found : " + pkgBinary));
            }
        }
        if (this.isEnforceDeletePackageFiles()) {
            File goPath;
            int deletedInstances = 0;
            this.getLog().debug((CharSequence)"Detected request to delete both package source and binary folders if they are presented");
            String[] packages = this.getPackages();
            try {
                goPath = this.findGoPath(true);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't find $GOPATH", (Exception)ex);
            }
            for (String p : packages) {
                this.getLog().info((CharSequence)("Removing binary and source folders for package '" + p + '\''));
                File pkgSources = this.makePathToPackageSources(goPath, p);
                File pkgBinary = this.makePathToPackageCompiled(goPath, p);
                this.getLog().debug((CharSequence)("Src folder : " + pkgSources));
                this.getLog().debug((CharSequence)("Pkg folder : " + pkgBinary));
                if (pkgSources.isDirectory()) {
                    try {
                        FileUtils.deleteDirectory((File)pkgSources);
                        ++deletedInstances;
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("Can't delete source folder : " + pkgSources, (Exception)ex);
                    }
                    this.getLog().info((CharSequence)("\tDeleted source folder : " + pkgSources));
                } else {
                    this.getLog().debug((CharSequence)("Folder " + pkgSources + " is not found"));
                }
                if (pkgBinary.isDirectory()) {
                    try {
                        FileUtils.deleteDirectory((File)pkgBinary);
                        ++deletedInstances;
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("Can't delete binary folder : " + pkgBinary, (Exception)ex);
                    }
                    this.getLog().info((CharSequence)("\tDeleted binary folder : " + pkgBinary));
                    continue;
                }
                File compiled = new File(pkgBinary.getAbsolutePath() + ".a");
                if (compiled.isFile()) {
                    if (!compiled.delete()) {
                        throw new MojoExecutionException("Can't delete compiled file : " + compiled);
                    }
                    ++deletedInstances;
                    this.getLog().info((CharSequence)("\tDeleted compiled file : " + compiled));
                    continue;
                }
                this.getLog().debug((CharSequence)("File " + compiled + " is not found"));
            }
            if (deletedInstances > 0) {
                try {
                    this.getLog().info((CharSequence)"1.5 second delay to be visible by systems analyzing file time stamp");
                    Thread.sleep(1500L);
                }
                catch (InterruptedException ex) {
                    throw new MojoExecutionException("Interrupted");
                }
            }
        }
        if ((customcvs = this.getCustomCvsOptions()) != null || this.branch != null || this.tag != null || this.revision != null) {
            File goPath;
            try {
                goPath = this.findGoPath(true);
            }
            catch (IOException ex) {
                throw new MojoFailureException("Can't find $GOPATH", (Throwable)ex);
            }
            this.getLog().info((CharSequence)"(!) Get initial version of package repository before CVS operations");
            this.buildFlagsToIgnore.add("-u");
            this.addTmpBuildFlagIfNotPresented("-d");
            try {
                boolean error = this.doMainBusiness(proxySettings, 10);
                if (error) {
                    throw new Exception("error as result of 'get' operation during initial loading of packages " + Arrays.toString(this.getPackages()));
                }
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Can't get packages", ex);
            }
            finally {
                this.buildFlagsToIgnore.clear();
                this.tempBuildFlags.clear();
            }
            this.getLog().debug((CharSequence)String.format("Switching branch and tag for packages : branch = %s , tag = %s", GetUtils.ensureNonNull((Object)this.branch, (Object)"..."), GetUtils.ensureNonNull((Object)this.tag, (Object)"...")));
            this.getLog().debug((CharSequence)("Custom CVS options : " + Arrays.toString(this.customCvsOptions)));
            if (!GolangGetMojo.processCVS(this, proxySettings, goPath)) {
                throw new MojoFailureException("Can't change branch or tag or execute custom CVS options, see the log for errors!");
            }
        }
    }

    @Override
    protected boolean doesNeedOneMoreAttempt(@Nonnull ProcessResult processResult, @Nonnull String consoleOut, @Nonnull String consoleErr) throws IOException, MojoExecutionException {
        List<String> packagesWithDetectedGitCacheErrors;
        Matcher matcher;
        boolean result = false;
        if (processResult.getExitValue() != 0 && (matcher = PATTERN_NO_SUBMODULE_MAPPING_FOUND_IN_GIT.matcher(consoleErr)).find() && !(packagesWithDetectedGitCacheErrors = this.extractProblemPackagesFromErrorLog(consoleErr)).isEmpty()) {
            if (this.autofixGitCache) {
                this.getLog().warn((CharSequence)"Trying to fix the detected git cache errors automatically..");
                result = this.tryToFixGitCacheErrorsForPackages(packagesWithDetectedGitCacheErrors);
            } else {
                for (String s : packagesWithDetectedGitCacheErrors) {
                    this.getLog().error((CharSequence)String.format("Detected Git cache error for package '%s', can be fixed with 'git rm -r --cached .'", s));
                }
            }
        }
        return result;
    }
}

