/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.metadata;

import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.ing.data.cassandra.jdbc.CassandraMetadataResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.ColumnDefinitions;
import com.ing.data.cassandra.jdbc.metadata.AbstractMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.MetadataResultSet;
import com.ing.data.cassandra.jdbc.metadata.MetadataRow;
import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.types.TypesMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnMetadataResultSetBuilder
extends AbstractMetadataResultSetBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnMetadataResultSetBuilder.class);

    public ColumnMetadataResultSetBuilder(CassandraStatement statement) throws SQLException {
        super(statement);
    }

    public CassandraMetadataResultSet buildColumns(String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String catalog = this.connection.getCatalog();
        ArrayList<MetadataRow> columns = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("DATA_TYPE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_SIZE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("BUFFER_LENGTH", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("DECIMAL_DIGITS", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("NUM_PREC_RADIX", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("NULLABLE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("REMARKS", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_DEF", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SQL_DATA_TYPE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SQL_DATETIME_SUB", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("CHAR_OCTET_LENGTH", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("ORDINAL_POSITION", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("IS_NULLABLE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SCOPE_CATALOG", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SCOPE_SCHEMA", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SCOPE_TABLE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SOURCE_DATA_TYPE", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("IS_AUTOINCREMENT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("IS_GENERATEDCOLUMN", DataTypes.TEXT));
        this.filterBySchemaNamePattern(schemaPattern, keyspaceMetadata -> this.filterByTableNamePattern(tableNamePattern, (KeyspaceMetadata)keyspaceMetadata, tableMetadata -> {
            AtomicInteger colIndex = new AtomicInteger(1);
            this.filterByColumnNamePattern(columnNamePattern, (TableMetadata)tableMetadata, columnMetadata -> {
                AbstractJdbcType<?> jdbcEquivalentType = TypesMap.getTypeForComparator(columnMetadata.getType().toString());
                int columnSize = -1;
                if (jdbcEquivalentType != null) {
                    columnSize = jdbcEquivalentType.getPrecision(null);
                }
                int radix = 2;
                if (jdbcEquivalentType != null && (jdbcEquivalentType.getJdbcType() == 3 || jdbcEquivalentType.getJdbcType() == 2)) {
                    radix = 10;
                }
                int jdbcType = 1111;
                try {
                    jdbcType = TypesMap.getTypeForComparator(columnMetadata.getType().toString()).getJdbcType();
                }
                catch (Exception e) {
                    LOG.warn("Unable to get JDBC type for comparator [{}]: {}", (Object)columnMetadata.getType(), (Object)e.getMessage());
                }
                MetadataRow row = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), tableMetadata.getName().asInternal(), columnMetadata.getName().asInternal(), jdbcType, columnMetadata.getType().toString(), columnSize, 0, null, radix, 0, null, null, null, null, Integer.MAX_VALUE, colIndex.getAndIncrement(), "", null, null, null, null, "NO", "NO");
                columns.add(row);
            }, columnMetadata -> colIndex.getAndIncrement());
        }, null), null);
        columns.sort(Comparator.comparing(row -> ((MetadataRow)row).getString("TABLE_SCHEM")).thenComparing(row -> ((MetadataRow)row).getString("TABLE_NAME")).thenComparing(row -> ((MetadataRow)row).getInt("ORDINAL_POSITION")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(columns));
    }
}

