/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.event.models;

import androidx.annotation.IntRange;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import com.instana.android.core.event.models.AppProfile;
import com.instana.android.core.event.models.BeaconType;
import com.instana.android.core.event.models.ConnectionProfile;
import com.instana.android.core.event.models.ConnectionType;
import com.instana.android.core.event.models.DeviceProfile;
import com.instana.android.core.event.models.EffectiveConnectionType;
import com.instana.android.core.event.models.Platform;
import com.instana.android.core.event.models.UserProfile;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 W2\u00020\u0001:\u0001WBO\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007J\r\u0010\u001b\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010\u001e\u001a\u00020\u0007J\r\u0010\u001f\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u001cJ\b\u0010 \u001a\u0004\u0018\u00010\u0007J\u0010\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010$\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010%\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010&\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010'\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u0010\u0010(\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010)\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010*\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\"2\u0006\u0010#\u001a\u00020,J\u0010\u0010-\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010.\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u0010\u0010/\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u00100\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u00101\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u00102\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u000e\u00103\u001a\u00020\"2\u0006\u0010#\u001a\u000204J\u0010\u00105\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u0010\u00106\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u0012\u00107\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007H\u0002J\u0010\u00108\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u00109\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u000e\u0010:\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015J\u0010\u0010;\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010<\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0017J\u0010\u0010=\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u001a\u0010>\u001a\u00020\"2\b\b\u0001\u0010\u001e\u001a\u00020\u00072\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010?\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010@\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010A\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u000e\u0010B\u001a\u00020\"2\u0006\u0010#\u001a\u00020CJ\u000e\u0010D\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015J\u0010\u0010E\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010F\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010G\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u0010\u0010H\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0005J\u000e\u0010I\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003J\u0010\u0010J\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010K\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0016\u0010L\u001a\u00020\"2\u000e\b\u0001\u0010#\u001a\b\u0012\u0004\u0012\u00020N0MJ\u0010\u0010O\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010P\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010Q\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0017J\u0010\u0010R\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u0017J\b\u0010S\u001a\u00020\u0007H\u0016J\f\u0010T\u001a\u00020\u0007*\u00020NH\u0003J\f\u0010U\u001a\u00020\u0007*\u00020\u0007H\u0003J\f\u0010V\u001a\u00020\u0007*\u00020\u0007H\u0003R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/instana/android/core/event/models/Beacon;", "", "type", "Lcom/instana/android/core/event/models/BeaconType;", "duration", "", "mobileAppId", "", "sessionId", "errorCount", "appProfile", "Lcom/instana/android/core/event/models/AppProfile;", "deviceProfile", "Lcom/instana/android/core/event/models/DeviceProfile;", "connectionProfile", "Lcom/instana/android/core/event/models/ConnectionProfile;", "userProfile", "Lcom/instana/android/core/event/models/UserProfile;", "(Lcom/instana/android/core/event/models/BeaconType;JLjava/lang/String;Ljava/lang/String;JLcom/instana/android/core/event/models/AppProfile;Lcom/instana/android/core/event/models/DeviceProfile;Lcom/instana/android/core/event/models/ConnectionProfile;Lcom/instana/android/core/event/models/UserProfile;)V", "booleanMap", "", "", "intMap", "", "longMap", "stringMap", "getBeaconId", "getGooglePlayServicesMissing", "()Ljava/lang/Boolean;", "getMeta", "key", "getRooted", "getView", "setAgentVersion", "", "value", "setAppBuild", "setAppVersion", "setBackendTraceId", "setBatchSize", "setBeaconId", "setBundleIdentifier", "setCarrier", "setConnectionType", "Lcom/instana/android/core/event/models/ConnectionType;", "setCustomEventName", "setDecodedBodySize", "setDeviceHardware", "setDeviceManufacturer", "setDeviceModel", "setDuration", "setEffectiveConnectionType", "Lcom/instana/android/core/event/models/EffectiveConnectionType;", "setEncodedBodySize", "setErrorCount", "setErrorId", "setErrorMessage", "setErrorType", "setGooglePlayServicesMissing", "setHttpCallMethod", "setHttpCallStatus", "setHttpCallUrl", "setMeta", "setMobileAppId", "setOsName", "setOsVersion", "setPlatform", "Lcom/instana/android/core/event/models/Platform;", "setRooted", "setSessionId", "setStackTrace", "setTimestamp", "setTransferSize", "setType", "setUserEmail", "setUserId", "setUserLanguages", "", "Ljava/util/Locale;", "setUserName", "setView", "setViewportHeight", "setViewportWidth", "toString", "bcp47", "escape", "md5", "Companion", "runtime_release"})
public final class Beacon {
    private final Map<String, Integer> intMap;
    private final Map<String, Long> longMap;
    private final Map<String, String> stringMap;
    private final Map<String, Boolean> booleanMap;
    public static final Companion Companion = new Companion(null);

    public final void setAgentVersion(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("agv", value);
    }

    public final void setMobileAppId(@Size(min=1L, max=64L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("k", value);
    }

    public final void setTimestamp(@IntRange(from=1L) long value) {
        this.longMap.put("ti", value);
    }

    public final void setDuration(@IntRange(from=0L) long value) {
        this.longMap.put("d", value);
    }

    public final void setBatchSize(@IntRange(from=1L) long value) {
        this.longMap.put("bs", value);
    }

    public final void setSessionId(@Size(min=1L, max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("sid", value);
    }

    public final void setBeaconId(@Size(min=1L, max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("bid", value);
    }

    @Nullable
    public final String getBeaconId() {
        return this.stringMap.get("bid");
    }

    public final void setBackendTraceId(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("bt", value);
    }

    public final void setType(@NotNull BeaconType value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.stringMap.put("t", value.getInternalType());
    }

    public final void setView(@Size(max=256L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("v", value);
    }

    @Nullable
    public final String getView() {
        return this.stringMap.get("v");
    }

    public final void setCustomEventName(@Size(max=256L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("cen", value);
    }

    public final void setMeta(@Size(max=64L) @NotNull String key, @Size(max=64L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("m_" + key, value);
    }

    @Nullable
    public final String getMeta(@Size(max=64L) @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.stringMap.get("m_" + key);
    }

    public final void setUserId(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("ui", value);
    }

    public final void setUserName(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("un", value);
    }

    public final void setUserEmail(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("ue", value);
    }

    public final void setUserLanguages(@Size(max=5L) @NotNull List<Locale> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.stringMap.put("ul", CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)value, (int)5), (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)new Function1<Locale, String>(this){
            final /* synthetic */ Beacon this$0;

            @NotNull
            public final String invoke(@NotNull Locale it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Beacon.access$bcp47(this.this$0, it);
            }
            {
                this.this$0 = beacon;
                super(1);
            }
        }), (int)30, null));
    }

    public final void setBundleIdentifier(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("bi", value);
    }

    public final void setAppBuild(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("ab", value);
    }

    public final void setAppVersion(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("av", value);
    }

    public final void setPlatform(@NotNull Platform value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.stringMap.put("p", value.getInternalType());
    }

    public final void setOsName(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("osn", value);
    }

    public final void setOsVersion(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("osv", value);
    }

    public final void setDeviceManufacturer(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("dma", value);
    }

    public final void setDeviceModel(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("dmo", value);
    }

    public final void setDeviceHardware(@Size(max=128L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("dh", value);
    }

    public final void setRooted(boolean value) {
        this.booleanMap.put("ro", value);
    }

    @Nullable
    public final Boolean getRooted() {
        return this.booleanMap.get("ro");
    }

    public final void setGooglePlayServicesMissing(boolean value) {
        this.booleanMap.put("gpsm", value);
    }

    @Nullable
    public final Boolean getGooglePlayServicesMissing() {
        return this.booleanMap.get("gpsm");
    }

    public final void setViewportWidth(@IntRange(from=1L) int value) {
        this.intMap.put("vw", value);
    }

    public final void setViewportHeight(@IntRange(from=1L) int value) {
        this.intMap.put("vh", value);
    }

    public final void setCarrier(@Size(max=256L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("cn", value);
    }

    public final void setConnectionType(@NotNull ConnectionType value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.stringMap.put("ct", value.getInternalType());
    }

    public final void setEffectiveConnectionType(@NotNull EffectiveConnectionType value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.stringMap.put("ect", value.getInternalType());
    }

    public final void setHttpCallUrl(@Size(max=4096L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("hu", value);
    }

    public final void setHttpCallMethod(@Size(max=16L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("hm", value);
    }

    public final void setHttpCallStatus(@IntRange(from=-1L, to=599L) int value) {
        this.intMap.put("hs", value);
    }

    public final void setEncodedBodySize(@IntRange(from=-1L) long value) {
        this.longMap.put("ebs", value);
    }

    public final void setDecodedBodySize(@IntRange(from=-1L) long value) {
        this.longMap.put("dbs", value);
    }

    public final void setTransferSize(@IntRange(from=-1L) long value) {
        this.longMap.put("trs", value);
    }

    public final void setErrorCount(@IntRange(from=0L) long value) {
        this.longMap.put("ec", value);
    }

    public final void setErrorMessage(@Size(max=16384L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("em", value);
        this.setErrorId(this.md5(value));
    }

    private final void setErrorId(@Size(max=16384L) String value) {
        this.stringMap.put("ei", value);
    }

    public final void setErrorType(@Size(max=1024L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("et", value);
    }

    public final void setStackTrace(@Size(max=16384L) @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.stringMap.put("st", value);
    }

    @NotNull
    public String toString() {
        Map.Entry<String, Boolean> it;
        Map.Entry<String, Boolean> element$iv;
        StringBuilder sb = new StringBuilder();
        Map<String, Object> $this$forEach$iv = this.booleanMap;
        boolean $i$f$forEach = false;
        Map<String, Boolean> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, Boolean>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl2 = false;
            sb.append(it.getKey()).append("\t").append(it.getValue()).append("\n");
        }
        $this$forEach$iv = this.intMap;
        $i$f$forEach = false;
        map = $this$forEach$iv;
        bl = false;
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl3 = false;
            sb.append(it.getKey()).append("\t").append(((Number)((Object)it.getValue())).intValue()).append("\n");
        }
        $this$forEach$iv = this.longMap;
        $i$f$forEach = false;
        map = $this$forEach$iv;
        bl = false;
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl4 = false;
            sb.append(it.getKey()).append("\t").append(((Number)((Object)it.getValue())).longValue()).append("\n");
        }
        $this$forEach$iv = this.stringMap;
        $i$f$forEach = false;
        map = $this$forEach$iv;
        bl = false;
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl5 = false;
            sb.append(it.getKey()).append("\t").append(this.escape((String)((Object)it.getValue()))).append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @VisibleForTesting
    private final String bcp47(@NotNull Locale $this$bcp47) {
        return $this$bcp47.getLanguage() + '-' + $this$bcp47.getCountry();
    }

    @VisibleForTesting
    private final String md5(@NotNull String $this$md5) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        String string = $this$md5;
        MessageDigest messageDigest = md;
        int n = 1;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] byArray3 = messageDigest.digest(byArray2);
        int n2 = n;
        String string3 = new BigInteger(n2, byArray3).toString(16);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"BigInteger(1, md.digest(\u2026yteArray())).toString(16)");
        return StringsKt.padStart((String)string3, (int)32, (char)'0');
    }

    @VisibleForTesting
    private final String escape(@NotNull String $this$escape) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escape, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null);
    }

    private Beacon(BeaconType type, long duration, String mobileAppId, String sessionId, long errorCount, AppProfile appProfile, DeviceProfile deviceProfile, ConnectionProfile connectionProfile, UserProfile userProfile) {
        Object $this$run;
        boolean bl;
        boolean bl2;
        Map map;
        Beacon beacon = this;
        boolean bl3 = false;
        beacon.intMap = map = (Map)new LinkedHashMap();
        beacon = this;
        bl3 = false;
        beacon.longMap = map = (Map)new LinkedHashMap();
        beacon = this;
        bl3 = false;
        beacon.stringMap = map = (Map)new LinkedHashMap();
        beacon = this;
        bl3 = false;
        beacon.booleanMap = map = (Map)new LinkedHashMap();
        this.setAgentVersion("3.3.2");
        String string = appProfile.getAppVersion();
        if (string != null) {
            String string2 = string;
            bl2 = false;
            bl = false;
            $this$run = string2;
            boolean bl4 = false;
            this.setAppVersion((String)$this$run);
        }
        String string3 = appProfile.getAppBuild();
        if (string3 != null) {
            String string4 = string3;
            bl2 = false;
            bl = false;
            $this$run = string4;
            boolean bl5 = false;
            this.setAppBuild((String)$this$run);
        }
        String string5 = appProfile.getAppId();
        if (string5 != null) {
            String string6 = string5;
            bl2 = false;
            bl = false;
            $this$run = string6;
            boolean bl6 = false;
            this.setBundleIdentifier((String)$this$run);
        }
        Platform platform = deviceProfile.getPlatform();
        if (platform != null) {
            Platform platform2 = platform;
            bl2 = false;
            bl = false;
            $this$run = platform2;
            boolean bl7 = false;
            this.setPlatform((Platform)((Object)$this$run));
        }
        String string7 = deviceProfile.getOsName();
        if (string7 != null) {
            String string8 = string7;
            bl2 = false;
            bl = false;
            $this$run = string8;
            boolean bl8 = false;
            this.setOsName((String)$this$run);
        }
        String string9 = deviceProfile.getOsVersion();
        if (string9 != null) {
            String string10 = string9;
            bl2 = false;
            bl = false;
            $this$run = string10;
            boolean bl9 = false;
            this.setOsVersion((String)$this$run);
        }
        String string11 = deviceProfile.getDeviceManufacturer();
        if (string11 != null) {
            String string12 = string11;
            bl2 = false;
            bl = false;
            $this$run = string12;
            boolean bl10 = false;
            this.setDeviceManufacturer((String)$this$run);
        }
        String string13 = deviceProfile.getDeviceModel();
        if (string13 != null) {
            String string14 = string13;
            bl2 = false;
            bl = false;
            $this$run = string14;
            boolean bl11 = false;
            this.setDeviceModel((String)$this$run);
        }
        String string15 = deviceProfile.getDeviceHardware();
        if (string15 != null) {
            String string16 = string15;
            bl2 = false;
            bl = false;
            $this$run = string16;
            boolean bl12 = false;
            this.setDeviceHardware((String)$this$run);
        }
        Boolean bl13 = deviceProfile.getGooglePlayServicesMissing();
        if (bl13 != null) {
            Boolean bl14 = bl13;
            bl2 = false;
            bl = false;
            boolean $this$run2 = bl14;
            boolean bl15 = false;
            this.setGooglePlayServicesMissing($this$run2);
        }
        Object object = CollectionsKt.listOfNotNull((Object)deviceProfile.getLocale());
        bl2 = false;
        bl = false;
        List $this$run3 = object;
        boolean bl16 = false;
        this.setUserLanguages($this$run3);
        Boolean bl17 = deviceProfile.getRooted();
        if (bl17 != null) {
            object = bl17;
            bl2 = false;
            bl = false;
            boolean $this$run4 = (Boolean)object;
            boolean bl18 = false;
            this.setRooted($this$run4);
        }
        Integer n = deviceProfile.getViewportWidth();
        if (n != null) {
            object = n;
            bl2 = false;
            bl = false;
            int $this$run5 = ((Number)object).intValue();
            boolean bl19 = false;
            this.setViewportWidth($this$run5);
        }
        Integer n2 = deviceProfile.getViewportHeight();
        if (n2 != null) {
            object = n2;
            bl2 = false;
            bl = false;
            int $this$run6 = ((Number)object).intValue();
            boolean bl20 = false;
            this.setViewportHeight($this$run6);
        }
        String string17 = connectionProfile.getCarrierName();
        if (string17 != null) {
            object = string17;
            bl2 = false;
            bl = false;
            Object $this$run7 = object;
            boolean bl21 = false;
            this.setCarrier((String)$this$run7);
        }
        ConnectionType connectionType = connectionProfile.getConnectionType();
        if (connectionType != null) {
            object = connectionType;
            bl2 = false;
            bl = false;
            Object $this$run8 = object;
            boolean bl22 = false;
            this.setConnectionType((ConnectionType)((Object)$this$run8));
        }
        EffectiveConnectionType effectiveConnectionType = connectionProfile.getEffectiveConnectionType();
        if (effectiveConnectionType != null) {
            object = effectiveConnectionType;
            bl2 = false;
            bl = false;
            Object $this$run9 = object;
            boolean bl23 = false;
            this.setEffectiveConnectionType((EffectiveConnectionType)((Object)$this$run9));
        }
        String string18 = userProfile.getUserId();
        if (string18 != null) {
            object = string18;
            bl2 = false;
            bl = false;
            Object $this$run10 = object;
            boolean bl24 = false;
            this.setUserId((String)$this$run10);
        }
        String string19 = userProfile.getUserName();
        if (string19 != null) {
            object = string19;
            bl2 = false;
            bl = false;
            Object $this$run11 = object;
            boolean bl25 = false;
            this.setUserName((String)$this$run11);
        }
        String string20 = userProfile.getUserEmail();
        if (string20 != null) {
            object = string20;
            bl2 = false;
            bl = false;
            Object $this$run12 = object;
            boolean bl26 = false;
            this.setUserEmail((String)$this$run12);
        }
        this.setTimestamp(System.currentTimeMillis());
        String string21 = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string21, (String)"UUID.randomUUID().toString()");
        this.setBeaconId(string21);
        this.setMobileAppId(mobileAppId);
        this.setSessionId(sessionId);
        this.setType(type);
        this.setDuration(duration);
        this.setErrorCount(errorCount);
    }

    public static final /* synthetic */ String access$bcp47(Beacon $this, Locale $this$access_u24bcp47) {
        return $this.bcp47($this$access_u24bcp47);
    }

    public /* synthetic */ Beacon(BeaconType type, long duration, String mobileAppId, String sessionId, long errorCount, AppProfile appProfile, DeviceProfile deviceProfile, ConnectionProfile connectionProfile, UserProfile userProfile, DefaultConstructorMarker $constructor_marker) {
        this(type, duration, mobileAppId, sessionId, errorCount, appProfile, deviceProfile, connectionProfile, userProfile);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0011J\u0080\u0001\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u000eJ\u00af\u0001\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00152\b\u0010 \u001a\u0004\u0018\u00010\u00152\b\u0010!\u001a\u0004\u0018\u00010\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\"JT\u0010#\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0011JR\u0010$\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0011\u00a8\u0006%"}, d2={"Lcom/instana/android/core/event/models/Beacon$Companion;", "", "()V", "newCrash", "Lcom/instana/android/core/event/models/Beacon;", "appProfile", "Lcom/instana/android/core/event/models/AppProfile;", "deviceProfile", "Lcom/instana/android/core/event/models/DeviceProfile;", "connectionProfile", "Lcom/instana/android/core/event/models/ConnectionProfile;", "userProfile", "Lcom/instana/android/core/event/models/UserProfile;", "sessionId", "", "view", "meta", "", "newCustomEvent", "appKey", "startTime", "", "duration", "backendTraceId", "error", "name", "newHttpRequest", "method", "url", "responseCode", "", "requestSizeBytes", "encodedResponseSizeBytes", "decodedResponseSizeBytes", "(Ljava/lang/String;Lcom/instana/android/core/event/models/AppProfile;Lcom/instana/android/core/event/models/DeviceProfile;Lcom/instana/android/core/event/models/ConnectionProfile;Lcom/instana/android/core/event/models/UserProfile;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/String;)Lcom/instana/android/core/event/models/Beacon;", "newSessionStart", "newViewChange", "runtime_release"})
    public static final class Companion {
        @NotNull
        public final Beacon newSessionStart(@NotNull String appKey, @NotNull AppProfile appProfile, @NotNull DeviceProfile deviceProfile, @NotNull ConnectionProfile connectionProfile, @NotNull UserProfile userProfile, @NotNull String sessionId, @Nullable String view, @NotNull Map<String, String> meta) {
            Intrinsics.checkParameterIsNotNull((Object)appKey, (String)"appKey");
            Intrinsics.checkParameterIsNotNull((Object)appProfile, (String)"appProfile");
            Intrinsics.checkParameterIsNotNull((Object)deviceProfile, (String)"deviceProfile");
            Intrinsics.checkParameterIsNotNull((Object)connectionProfile, (String)"connectionProfile");
            Intrinsics.checkParameterIsNotNull((Object)userProfile, (String)"userProfile");
            Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
            Intrinsics.checkParameterIsNotNull(meta, (String)"meta");
            Beacon beacon = new Beacon(BeaconType.SESSION_START, 0L, appKey, sessionId, 0L, appProfile, deviceProfile, connectionProfile, userProfile, null);
            boolean bl = false;
            boolean bl2 = false;
            Beacon $this$apply = beacon;
            boolean bl3 = false;
            String string = view;
            if (string != null) {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String $this$run = string2;
                boolean bl6 = false;
                $this$apply.setView($this$run);
            }
            Map<String, String> $this$forEach$iv = meta;
            boolean $i$f$forEach = false;
            Map<String, String> map = $this$forEach$iv;
            boolean bl7 = false;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl8 = false;
                $this$apply.setMeta(it.getKey(), it.getValue());
            }
            return beacon;
        }

        @NotNull
        public final Beacon newHttpRequest(@NotNull String appKey, @NotNull AppProfile appProfile, @NotNull DeviceProfile deviceProfile, @NotNull ConnectionProfile connectionProfile, @NotNull UserProfile userProfile, @NotNull String sessionId, @Nullable String view, @NotNull Map<String, String> meta, long duration, @Nullable String method, @NotNull String url, @Nullable String backendTraceId, @Nullable Integer responseCode, @Nullable Long requestSizeBytes, @Nullable Long encodedResponseSizeBytes, @Nullable Long decodedResponseSizeBytes, @Nullable String error) {
            Beacon beacon;
            block7: {
                long $this$run;
                boolean bl;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)appKey, (String)"appKey");
                Intrinsics.checkParameterIsNotNull((Object)appProfile, (String)"appProfile");
                Intrinsics.checkParameterIsNotNull((Object)deviceProfile, (String)"deviceProfile");
                Intrinsics.checkParameterIsNotNull((Object)connectionProfile, (String)"connectionProfile");
                Intrinsics.checkParameterIsNotNull((Object)userProfile, (String)"userProfile");
                Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
                Intrinsics.checkParameterIsNotNull(meta, (String)"meta");
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                long errorCount = error != null ? 1L : 0L;
                beacon = new Beacon(BeaconType.HTTP_REQUEST, duration, appKey, sessionId, errorCount, appProfile, deviceProfile, connectionProfile, userProfile, null);
                boolean bl2 = false;
                boolean bl3 = false;
                Beacon $this$apply = beacon;
                boolean bl4 = false;
                String string = view;
                if (string != null) {
                    object = string;
                    bl = false;
                    boolean bl5 = false;
                    String $this$run2 = object;
                    boolean bl6 = false;
                    $this$apply.setView($this$run2);
                }
                Map<String, String> $this$forEach$iv = meta;
                boolean $i$f$forEach = false;
                Map<String, String> map = $this$forEach$iv;
                boolean $this$run2 = false;
                Iterator<Map.Entry<String, String>> bl6 = map.entrySet().iterator();
                while (bl6.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> it = element$iv = bl6.next();
                    boolean bl7 = false;
                    $this$apply.setMeta(it.getKey(), it.getValue());
                }
                String string2 = method;
                if (string2 != null) {
                    object = string2;
                    bl = false;
                    boolean bl8 = false;
                    String $this$run3 = object;
                    boolean bl9 = false;
                    $this$apply.setHttpCallMethod($this$run3);
                }
                $this$apply.setHttpCallUrl(url);
                Integer n = responseCode;
                if (n != null) {
                    object = n;
                    bl = false;
                    boolean bl10 = false;
                    int $this$run4 = ((Number)object).intValue();
                    boolean bl11 = false;
                    $this$apply.setHttpCallStatus($this$run4);
                }
                Long l = encodedResponseSizeBytes;
                if (l != null) {
                    object = l;
                    bl = false;
                    boolean bl12 = false;
                    $this$run = ((Number)object).longValue();
                    boolean bl13 = false;
                    $this$apply.setEncodedBodySize($this$run);
                }
                Long l2 = decodedResponseSizeBytes;
                if (l2 != null) {
                    object = l2;
                    bl = false;
                    boolean bl14 = false;
                    $this$run = ((Number)object).longValue();
                    boolean bl15 = false;
                    $this$apply.setDecodedBodySize($this$run);
                }
                String string3 = backendTraceId;
                if (string3 != null) {
                    object = string3;
                    bl = false;
                    boolean bl16 = false;
                    Object $this$run5 = object;
                    boolean bl17 = false;
                    $this$apply.setBackendTraceId(backendTraceId);
                }
                String string4 = error;
                if (string4 == null) break block7;
                object = string4;
                bl = false;
                boolean bl18 = false;
                Object $this$run6 = object;
                boolean bl19 = false;
                $this$apply.setErrorMessage((String)$this$run6);
            }
            return beacon;
        }

        @NotNull
        public final Beacon newViewChange(@NotNull String appKey, @NotNull AppProfile appProfile, @NotNull DeviceProfile deviceProfile, @NotNull ConnectionProfile connectionProfile, @NotNull UserProfile userProfile, @NotNull String sessionId, @NotNull String view, @NotNull Map<String, String> meta) {
            Intrinsics.checkParameterIsNotNull((Object)appKey, (String)"appKey");
            Intrinsics.checkParameterIsNotNull((Object)appProfile, (String)"appProfile");
            Intrinsics.checkParameterIsNotNull((Object)deviceProfile, (String)"deviceProfile");
            Intrinsics.checkParameterIsNotNull((Object)connectionProfile, (String)"connectionProfile");
            Intrinsics.checkParameterIsNotNull((Object)userProfile, (String)"userProfile");
            Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull(meta, (String)"meta");
            Beacon beacon = new Beacon(BeaconType.VIEW_CHANGE, 0L, appKey, sessionId, 0L, appProfile, deviceProfile, connectionProfile, userProfile, null);
            boolean bl = false;
            boolean bl2 = false;
            Beacon $this$apply = beacon;
            boolean bl3 = false;
            $this$apply.setView(view);
            Map<String, String> $this$forEach$iv = meta;
            boolean $i$f$forEach = false;
            Map<String, String> map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl5 = false;
                $this$apply.setMeta(it.getKey(), it.getValue());
            }
            return beacon;
        }

        @NotNull
        public final Beacon newCustomEvent(@NotNull String appKey, @NotNull AppProfile appProfile, @NotNull DeviceProfile deviceProfile, @NotNull ConnectionProfile connectionProfile, @NotNull UserProfile userProfile, @NotNull String sessionId, @Nullable String view, @NotNull Map<String, String> meta, long startTime, long duration, @Nullable String backendTraceId, @Nullable String error, @NotNull String name) {
            Beacon beacon;
            block3: {
                boolean bl;
                String string;
                Intrinsics.checkParameterIsNotNull((Object)appKey, (String)"appKey");
                Intrinsics.checkParameterIsNotNull((Object)appProfile, (String)"appProfile");
                Intrinsics.checkParameterIsNotNull((Object)deviceProfile, (String)"deviceProfile");
                Intrinsics.checkParameterIsNotNull((Object)connectionProfile, (String)"connectionProfile");
                Intrinsics.checkParameterIsNotNull((Object)userProfile, (String)"userProfile");
                Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
                Intrinsics.checkParameterIsNotNull(meta, (String)"meta");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                beacon = new Beacon(BeaconType.CUSTOM, duration, appKey, sessionId, 0L, appProfile, deviceProfile, connectionProfile, userProfile, null);
                boolean bl2 = false;
                boolean bl3 = false;
                Beacon $this$apply = beacon;
                boolean bl4 = false;
                String string2 = view;
                if (string2 != null) {
                    string = string2;
                    bl = false;
                    boolean bl5 = false;
                    String $this$run = string;
                    boolean bl6 = false;
                    $this$apply.setView($this$run);
                }
                Map<String, String> $this$forEach$iv = meta;
                boolean $i$f$forEach = false;
                Map<String, String> map = $this$forEach$iv;
                boolean $this$run = false;
                Iterator<Map.Entry<String, String>> bl6 = map.entrySet().iterator();
                while (bl6.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> it = element$iv = bl6.next();
                    boolean bl7 = false;
                    $this$apply.setMeta(it.getKey(), it.getValue());
                }
                $this$apply.setCustomEventName(name);
                $this$apply.setTimestamp(startTime);
                String string3 = backendTraceId;
                if (string3 != null) {
                    string = string3;
                    bl = false;
                    boolean bl8 = false;
                    String $this$run2 = string;
                    boolean bl9 = false;
                    $this$apply.setBackendTraceId(backendTraceId);
                }
                String string4 = error;
                if (string4 == null) break block3;
                string = string4;
                bl = false;
                boolean bl10 = false;
                String $this$run3 = string;
                boolean bl11 = false;
                $this$apply.setErrorMessage($this$run3);
            }
            return beacon;
        }

        @NotNull
        public final Beacon newCrash(@NotNull AppProfile appProfile, @NotNull DeviceProfile deviceProfile, @NotNull ConnectionProfile connectionProfile, @NotNull UserProfile userProfile, @NotNull String sessionId, @Nullable String view, @NotNull Map<String, String> meta) {
            Intrinsics.checkParameterIsNotNull((Object)appProfile, (String)"appProfile");
            Intrinsics.checkParameterIsNotNull((Object)deviceProfile, (String)"deviceProfile");
            Intrinsics.checkParameterIsNotNull((Object)connectionProfile, (String)"connectionProfile");
            Intrinsics.checkParameterIsNotNull((Object)userProfile, (String)"userProfile");
            Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
            Intrinsics.checkParameterIsNotNull(meta, (String)"meta");
            Beacon beacon = new Beacon(BeaconType.CRASH, 0L, "", sessionId, 0L, appProfile, deviceProfile, connectionProfile, userProfile, null);
            boolean bl = false;
            boolean bl2 = false;
            Beacon $this$apply = beacon;
            boolean bl3 = false;
            String string = view;
            if (string != null) {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String $this$run = string2;
                boolean bl6 = false;
                $this$apply.setView($this$run);
            }
            Map<String, String> $this$forEach$iv = meta;
            boolean $i$f$forEach = false;
            Map<String, String> map = $this$forEach$iv;
            boolean bl7 = false;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl8 = false;
                $this$apply.setMeta(it.getKey(), it.getValue());
            }
            return beacon;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

