/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.util;

import android.os.Build;
import com.instana.android.core.util.StreamExtensionsKt;
import com.instana.android.instrumentation.aspects.UrlConnectionAspect;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0011\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u00a2\u0006\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a\u0011\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"decodedResponseSizeOrNull", "", "Ljava/net/HttpURLConnection;", "(Ljava/net/HttpURLConnection;)Ljava/lang/Integer;", "encodedResponseSizeOrNull", "", "(Ljava/net/HttpURLConnection;)Ljava/lang/Long;", "errorMessageOrNull", "", "isSuccessful", "", "responseCodeOrNull", "runtime_release"})
public final class HttpURLConnectionExtensionsKt {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public static final boolean isSuccessful(@NotNull HttpURLConnection $this$isSuccessful) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)$this$isSuccessful, (String)"$this$isSuccessful");
        try {
            n = $this$isSuccessful.getResponseCode();
            n = 200 <= n && 299 >= n ? 1 : 0;
        }
        catch (Exception ignored) {
            n = 0;
        }
        return n != 0;
    }

    @Nullable
    public static final Long encodedResponseSizeOrNull(@NotNull HttpURLConnection $this$encodedResponseSizeOrNull) {
        Long size;
        Intrinsics.checkParameterIsNotNull((Object)$this$encodedResponseSizeOrNull, (String)"$this$encodedResponseSizeOrNull");
        Long l = size = Build.VERSION.SDK_INT >= 24 ? Long.valueOf($this$encodedResponseSizeOrNull.getContentLengthLong()) : Long.valueOf($this$encodedResponseSizeOrNull.getContentLength());
        if (size == -1L) {
            size = null;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Integer decodedResponseSizeOrNull(@NotNull HttpURLConnection $this$decodedResponseSizeOrNull) {
        Intrinsics.checkParameterIsNotNull((Object)$this$decodedResponseSizeOrNull, (String)"$this$decodedResponseSizeOrNull");
        if (StringsKt.equals((String)"gzip", (String)$this$decodedResponseSizeOrNull.getContentEncoding(), (boolean)true)) {
            try {
                InputStream inputStream;
                HttpURLConnection httpURLConnection = $this$decodedResponseSizeOrNull;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, (Object)httpURLConnection);
                try {
                    inputStream = httpURLConnection.getInputStream();
                }
                catch (IOException iOException) {
                    UrlConnectionAspect.aspectOf().ajc$afterThrowing$com_instana_android_instrumentation_aspects_UrlConnectionAspect$4$894dc66b(iOException, joinPoint);
                    throw iOException;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"inputStream");
                Closeable closeable = new GZIPInputStream(StreamExtensionsKt.clone(inputStream));
                boolean bl = false;
                Throwable throwable = null;
                try {
                    GZIPInputStream it = (GZIPInputStream)closeable;
                    boolean bl2 = false;
                    Integer n = ByteStreamsKt.readBytes((InputStream)it).length;
                    return n;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static final Integer responseCodeOrNull(@NotNull HttpURLConnection $this$responseCodeOrNull) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)$this$responseCodeOrNull, (String)"$this$responseCodeOrNull");
        try {
            n = $this$responseCodeOrNull.getResponseCode();
        }
        catch (Exception ignored) {
            n = null;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String errorMessageOrNull(@NotNull HttpURLConnection $this$errorMessageOrNull) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$errorMessageOrNull, (String)"$this$errorMessageOrNull");
        if (HttpURLConnectionExtensionsKt.isSuccessful($this$errorMessageOrNull)) {
            string = null;
        } else if (HttpURLConnectionExtensionsKt.responseCodeOrNull($this$errorMessageOrNull) == null) {
            String string2;
            try {
                $this$errorMessageOrNull.getResponseCode();
                string2 = null;
            }
            catch (Exception e) {
                string2 = e.toString();
            }
            string = string2;
        } else if (ComparisonsKt.compareValues((Comparable)HttpURLConnectionExtensionsKt.encodedResponseSizeOrNull($this$errorMessageOrNull), (Comparable)Long.valueOf(0L)) > 0) {
            InputStream inputStream = $this$errorMessageOrNull.getErrorStream();
            if (inputStream != null) {
                Closeable closeable = inputStream;
                boolean bl = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl2 = false;
                    String string3 = StreamExtensionsKt.readCopy(it);
                    string = string3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    static {
        HttpURLConnectionExtensionsKt.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HttpURLConnectionExtensions.kt", HttpURLConnectionExtensionsKt.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getInputStream", "java.net.HttpURLConnection", "", "", "java.io.IOException", "java.io.InputStream"), 28);
    }
}

