/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.crash;

import android.app.Application;
import android.util.Log;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.InstanaWorkManager;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.crash.ExceptionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J)\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u001a\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/instana/android/crash/CrashService;", "", "app", "Landroid/app/Application;", "manager", "Lcom/instana/android/core/InstanaWorkManager;", "config", "Lcom/instana/android/core/InstanaConfig;", "defaultThreadHandler", "Ljava/lang/Thread$UncaughtExceptionHandler;", "(Landroid/app/Application;Lcom/instana/android/core/InstanaWorkManager;Lcom/instana/android/core/InstanaConfig;Ljava/lang/Thread$UncaughtExceptionHandler;)V", "breadCrumbs", "Ljava/util/Queue;", "", "handler", "Lcom/instana/android/crash/ExceptionHandler;", "getAppThreads", "", "Ljava/lang/Thread;", "()[Ljava/lang/Thread;", "getStackTracesFor", "Ljava/util/HashMap;", "threadList", "([Ljava/lang/Thread;)Ljava/util/HashMap;", "leave", "", "breadCrumb", "submitCrash", "thread", "throwable", "", "runtime_release"})
public final class CrashService {
    private Queue<String> breadCrumbs;
    private ExceptionHandler handler;
    private final Application app;
    private final InstanaWorkManager manager;
    private final InstanaConfig config;

    public final void leave(@NotNull String breadCrumb) {
        Intrinsics.checkParameterIsNotNull((Object)breadCrumb, (String)"breadCrumb");
        this.breadCrumbs.add(breadCrumb);
        if (this.breadCrumbs.size() > this.config.getBreadcrumbsBufferSize()) {
            this.breadCrumbs.poll();
        }
    }

    public final void submitCrash(@Nullable Thread thread, @Nullable Throwable throwable) {
        List breadCrumbsCopy = CollectionsKt.toList((Iterable)this.breadCrumbs);
        String string = Log.getStackTraceString((Throwable)throwable);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Log.getStackTraceString(throwable)");
        String stackTrace = string;
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        if (!stackTraces.containsKey(thread)) {
            Map<Thread, StackTraceElement[]> map = stackTraces;
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"stackTraces");
            Thread thread2 = thread;
            map.put(thread, (StackTraceElement[])(thread2 != null ? thread2.getStackTrace() : null));
        }
        if (throwable != null) {
            Map<Thread, StackTraceElement[]> map = stackTraces;
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"stackTraces");
            map.put(thread, throwable.getStackTrace());
        }
        Thread[] threadList = this.getAppThreads();
        HashMap<String, String> appStackTraces = this.getStackTracesFor(threadList);
        Pair<String, String> pair = ConstantsAndUtil.INSTANCE.getAppVersionNameAndVersionCode(this.app);
        String string2 = (String)pair.component1();
        String version = (String)pair.component2();
        this.breadCrumbs.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<String, String> getStackTracesFor(Thread[] threadList) {
        boolean bl = false;
        HashMap<String, String> traces = new HashMap<String, String>();
        Thread[] $this$forEach$iv = threadList;
        boolean $i$f$forEach = false;
        Thread[] threadArray = $this$forEach$iv;
        int n = threadArray.length;
        for (int i = 0; i < n; ++i) {
            void $this$mapTo$iv$iv;
            StackTraceElement[] $this$map$iv;
            Thread thread;
            Thread element$iv;
            Thread thread2 = element$iv = threadArray[i];
            boolean bl2 = false;
            if (thread2 == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Thread notNull = thread;
            boolean bl5 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)notNull.getStackTrace(), (String)"notNull.stackTrace");
            boolean $i$f$map = false;
            StackTraceElement[] stackTraceElementArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var21_22 = $this$mapTo$iv$iv;
            int n2 = ((void)var21_22).length;
            for (int j = 0; j < n2; ++j) {
                void it;
                void item$iv$iv;
                void var25_26 = item$iv$iv = var21_22[j];
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                String string = it.toString();
                collection.add(string);
            }
            String trace = ((List)destination$iv$iv).toString();
            traces.put(notNull.getName(), trace);
        }
        return traces;
    }

    private final Thread[] getAppThreads() {
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread()");
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup == null) {
            return new Thread[0];
        }
        ThreadGroup rootGroup = threadGroup;
        Thread[] threadList = new Thread[rootGroup.activeCount()];
        while (rootGroup.enumerate(threadList, false) == threadList.length) {
            threadList = new Thread[threadList.length * 2];
        }
        return threadList;
    }

    public CrashService(@NotNull Application app, @NotNull InstanaWorkManager manager, @NotNull InstanaConfig config, @Nullable Thread.UncaughtExceptionHandler defaultThreadHandler) {
        block2: {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
                Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
                Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
                this.app = app;
                this.manager = manager;
                this.config = config;
                this.breadCrumbs = new LinkedBlockingDeque();
                if (defaultThreadHandler != null) {
                    this.handler = new ExceptionHandler(this, defaultThreadHandler);
                }
                if (!this.config.getEnableCrashReporting()) break block1;
                ExceptionHandler exceptionHandler = this.handler;
                if (exceptionHandler == null) break block2;
                exceptionHandler.enable();
                break block2;
            }
            ExceptionHandler exceptionHandler = this.handler;
            if (exceptionHandler == null) break block2;
            exceptionHandler.disable();
        }
    }

    public /* synthetic */ CrashService(Application application, InstanaWorkManager instanaWorkManager, InstanaConfig instanaConfig, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        }
        this(application, instanaWorkManager, instanaConfig, uncaughtExceptionHandler);
    }
}

