/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.instrumentation.okhttp3;

import com.instana.android.Instana;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import com.instana.android.instrumentation.HTTPMarker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/instana/android/instrumentation/okhttp3/OkHttp3GlobalInterceptor;", "Lokhttp3/Interceptor;", "()V", "httpMarkers", "", "Lcom/instana/android/instrumentation/HTTPMarker;", "cancel", "", "request", "Lokhttp3/Request;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "runtime_release"})
public final class OkHttp3GlobalInterceptor
implements Interceptor {
    private static final List<HTTPMarker> httpMarkers;
    public static final OkHttp3GlobalInterceptor INSTANCE;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request intercepted = chain.request();
        String header = intercepted.header("X-INSTANA-ANDROID");
        String url = intercepted.url().toString();
        Request request = null;
        HTTPMarker marker = null;
        if (ConstantsAndUtil.isAutoEnabled() && !ConstantsAndUtil.hasTrackingHeader(header) && !ConstantsAndUtil.isBlacklistedURL(url)) {
            if (!ConstantsAndUtil.checkTag(header) && ConstantsAndUtil.isNotLibraryCallBoolean(url)) {
                Request request2;
                marker = Instana.startCapture$default(url, null, 2, null);
                if (marker != null) {
                    Logger.d("Automatically marked OkHttp3 request with: `url` " + url);
                    httpMarkers.add(marker);
                    request2 = chain.request().newBuilder().header(marker.headerKey(), marker.headerValue()).build();
                } else {
                    Logger.e("Failed to automatically mark OkHttp3 request with: `url` " + url);
                    request2 = intercepted;
                }
                request = request2;
            } else {
                Logger.d("Skipped already tagged OkHttp3 request with: `url` " + url);
                request = intercepted;
            }
        } else {
            Logger.d("Ignored OkHttp3 request with: `url` " + url);
            request = intercepted;
        }
        try {
            Response response2 = chain.proceed(request);
            Logger.d("Finishing OkHttp3 request with: `url` " + url);
            HTTPMarker hTTPMarker = marker;
            if (hTTPMarker != null) {
                hTTPMarker.finish(response2);
            }
            Collection collection = httpMarkers;
            boolean bl = false;
            Collection collection2 = collection;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
            }
            TypeIntrinsics.asMutableCollection((Object)collection2).remove(marker);
            response = response2;
        }
        catch (Exception e) {
            Logger.d("Finishing OkHttp3 request with: `url` " + url + ", `error` " + e.getMessage());
            HTTPMarker hTTPMarker = marker;
            if (hTTPMarker != null) {
                hTTPMarker.finish(request, (Throwable)e);
            }
            Collection collection = httpMarkers;
            boolean bl = false;
            Collection collection3 = collection;
            if (collection3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
            }
            TypeIntrinsics.asMutableCollection((Object)collection3).remove(marker);
            response = chain.proceed(chain.request());
        }
        return response;
    }

    public final void cancel(@NotNull Request request) {
        HTTPMarker marker;
        HTTPMarker hTTPMarker;
        Object v0;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Iterable $this$firstOrNull$iv = httpMarkers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HTTPMarker it = (HTTPMarker)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.headerValue(), (Object)request.header(it.headerKey()))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        if ((hTTPMarker = (HTTPMarker)v0) == null) {
            hTTPMarker = Instana.startCapture$default(request.url().toString(), null, 2, null);
        }
        HTTPMarker hTTPMarker2 = marker = hTTPMarker;
        if (hTTPMarker2 != null) {
            hTTPMarker2.cancel();
        }
        Collection collection = httpMarkers;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(marker);
    }

    private OkHttp3GlobalInterceptor() {
    }

    static {
        OkHttp3GlobalInterceptor okHttp3GlobalInterceptor;
        INSTANCE = okHttp3GlobalInterceptor = new OkHttp3GlobalInterceptor();
        boolean bl = false;
        httpMarkers = new ArrayList();
    }
}

