/*
 * Decompiled with CFR 0.152.
 */
package com.instana.sdk.support;

import com.instana.sdk.annotation.Span;
import java.util.Map;
import java.util.concurrent.Callable;

public class SpanSupport {
    public static final String TRACE_ID = "X-INSTANA-T";
    public static final String SPAN_ID = "X-INSTANA-S";
    public static final String LEVEL = "X-INSTANA-L";
    public static final String SUPPRESS = "0";
    public static final long VOID_ID = 0L;

    private SpanSupport() {
        throw new UnsupportedOperationException();
    }

    public static boolean isTracing(Span.Type type) {
        return false;
    }

    public static long currentTraceId(Span.Type type) {
        return 0L;
    }

    public static long currentSpanId(Span.Type type) {
        return 0L;
    }

    public static void annotate(Span.Type type, String key, String value) {
    }

    public static void annotate(Span.Type type, String key, Callable<? extends String> value) {
        if (SpanSupport.isTracing(type)) {
            try {
                SpanSupport.annotate(type, key, value.call());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void suppressNext() {
    }

    @Deprecated
    public static void inheritNext(long traceId) {
        SpanSupport.inheritNext(traceId, traceId);
    }

    public static void inheritNext(long traceId, long spanId) {
    }

    public static String idAsString(long id) {
        return Long.toHexString(id);
    }

    public static long stringAsId(String stringId) {
        int len = stringId.length();
        if (len <= 12) {
            return Long.parseLong(stringId, 16);
        }
        long first = Long.parseLong(stringId.substring(0, len - 1), 16);
        int second = Character.digit(stringId.charAt(len - 1), 16);
        return first * 16L + (long)second;
    }

    public static void addTraceHeadersIfTracing(Span.Type type, Map<? super String, ? super String> map) {
        if (SpanSupport.isTracing(type)) {
            map.put(TRACE_ID, SpanSupport.idAsString(SpanSupport.currentTraceId(type)));
            map.put(SPAN_ID, SpanSupport.idAsString(SpanSupport.currentSpanId(type)));
            map.put(LEVEL, "1");
        }
    }
}

