/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.validator;

import com.intuit.karate.ScriptValue;
import com.intuit.karate.validator.ValidationResult;
import com.intuit.karate.validator.Validator;
import java.util.UUID;

public class UuidValidator
implements Validator {
    public static final UuidValidator INSTANCE = new UuidValidator();

    @Override
    public ValidationResult validate(ScriptValue value) {
        if (!value.isString()) {
            return ValidationResult.fail("not a string");
        }
        String strValue = value.getValue(String.class);
        try {
            UUID uuid = UUID.fromString(strValue);
            return ValidationResult.PASS;
        }
        catch (Exception e) {
            return ValidationResult.fail("not a valid #uuid");
        }
    }
}

