/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.StringUtils;
import com.intuit.karate.cucumber.FeatureWrapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;
import net.minidev.json.reader.JsonWriter;
import net.minidev.json.reader.JsonWriterI;
import org.yaml.snakeyaml.Yaml;

public class JsonUtils {
    private JsonUtils() {
    }

    public static DocumentContext toJsonDoc(String raw) {
        return JsonPath.parse((String)raw);
    }

    public static String toStrictJsonString(String raw) {
        DocumentContext dc = JsonUtils.toJsonDoc(raw);
        return dc.jsonString();
    }

    public static String toJson(Object o) {
        return JSONValue.toJSONString((Object)o);
    }

    public static DocumentContext toJsonDoc(Object o) {
        return JsonUtils.toJsonDoc(JsonUtils.toJson(o));
    }

    public static Object fromJson(String s, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return JSONValue.parse((String)s, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toPrettyJsonString(DocumentContext doc) {
        Object o = doc.read("$", new Predicate[0]);
        StringBuilder sb = new StringBuilder();
        JsonUtils.recursePretty(o, sb, 0);
        sb.append('\n');
        return sb.toString();
    }

    private static void pad(StringBuilder sb, int depth) {
        for (int i = 0; i < depth; ++i) {
            sb.append(' ').append(' ');
        }
    }

    private static void recursePretty(Object o, StringBuilder sb, int depth) {
        if (o == null) {
            sb.append("null");
        } else if (o instanceof Map) {
            sb.append('{').append('\n');
            Map map = (Map)o;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                JsonUtils.pad(sb, depth + 1);
                sb.append('\"').append(JSONObject.escape((String)key)).append('\"');
                sb.append(':').append(' ');
                JsonUtils.recursePretty(entry.getValue(), sb, depth + 1);
                if (iterator.hasNext()) {
                    sb.append(',');
                }
                sb.append('\n');
            }
            JsonUtils.pad(sb, depth);
            sb.append('}');
        } else if (o instanceof List) {
            List list = (List)o;
            Iterator iterator = list.iterator();
            sb.append('[').append('\n');
            while (iterator.hasNext()) {
                Object child = iterator.next();
                JsonUtils.pad(sb, depth + 1);
                JsonUtils.recursePretty(child, sb, depth + 1);
                if (iterator.hasNext()) {
                    sb.append(',');
                }
                sb.append('\n');
            }
            JsonUtils.pad(sb, depth);
            sb.append(']');
        } else if (o instanceof String) {
            String value = (String)o;
            sb.append('\"').append(JSONObject.escape((String)value)).append('\"');
        } else {
            sb.append(o);
        }
    }

    public static StringUtils.Pair getParentAndLeafPath(String path) {
        String right;
        int pos = path.lastIndexOf(46);
        int temp = path.lastIndexOf("['");
        if (temp != -1 && temp > pos) {
            pos = temp - 1;
        }
        if ((right = path.substring(pos + 1)).startsWith("[")) {
            ++pos;
        }
        String left = path.substring(0, pos == -1 ? 0 : pos);
        return StringUtils.pair(left, right);
    }

    public static void removeValueByPath(DocumentContext doc, String path) {
        JsonUtils.setValueByPath(doc, path, null, true);
    }

    public static void setValueByPath(DocumentContext doc, String path, Object value) {
        JsonUtils.setValueByPath(doc, path, value, false);
    }

    public static void setValueByPath(DocumentContext doc, String path, Object value, boolean remove) {
        block14: {
            if ("$".equals(path)) {
                throw new RuntimeException("cannot replace root path $");
            }
            StringUtils.Pair pathLeaf = JsonUtils.getParentAndLeafPath(path);
            String left = pathLeaf.left;
            String right = pathLeaf.right;
            if (right.endsWith("]") && !right.endsWith("']")) {
                int indexPos = right.lastIndexOf(91);
                int index = Integer.valueOf(right.substring(indexPos + 1, right.length() - 1));
                String listPath = (right = right.substring(0, indexPos)).startsWith("[") ? left + right : ("".equals(left) ? right : left + "." + right);
                try {
                    List list = (List)doc.read(listPath, new Predicate[0]);
                    if (index < list.size()) {
                        if (remove) {
                            list.remove(index);
                        } else {
                            list.set(index, value);
                        }
                    } else if (!remove) {
                        list.add(value);
                    }
                    break block14;
                }
                catch (Exception e) {
                    if (!remove) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(value);
                        doc.put(left, right, list, new Predicate[0]);
                    }
                    break block14;
                }
            }
            if (remove) {
                doc.delete(path, new Predicate[0]);
            } else {
                if (right.startsWith("[")) {
                    right = right.substring(2, right.length() - 2);
                }
                if (!JsonUtils.pathExists(doc, left)) {
                    JsonUtils.createParents(doc, left);
                }
                doc.put(left, right, value, new Predicate[0]);
            }
        }
    }

    private static void createParents(DocumentContext doc, String path) {
        Cloneable empty;
        StringUtils.Pair pathLeaf = JsonUtils.getParentAndLeafPath(path);
        String left = pathLeaf.left;
        String right = pathLeaf.right;
        if ("".equals(left)) {
            if (!"$".equals(right)) {
                doc.add("$", new LinkedHashMap(), new Predicate[0]);
            }
            return;
        }
        if (!JsonUtils.pathExists(doc, left)) {
            JsonUtils.createParents(doc, left);
        }
        if (right.endsWith("]") && !right.endsWith("']")) {
            int pos = right.indexOf(91);
            right = right.substring(0, pos);
            ArrayList list = new ArrayList();
            list.add(new LinkedHashMap());
            empty = list;
        } else {
            empty = new LinkedHashMap();
        }
        doc.put(left, right, empty, new Predicate[0]);
    }

    public static boolean pathExists(DocumentContext doc, String path) {
        try {
            return doc.read(path, new Predicate[0]) != null;
        }
        catch (PathNotFoundException pnfe) {
            return false;
        }
    }

    public static DocumentContext fromYaml(String raw) {
        Yaml yaml = new Yaml();
        return JsonPath.parse((Object)yaml.load(raw));
    }

    public static String buildPath(String parentPath, String key) {
        boolean needsQuotes = key.indexOf(45) != -1 || key.indexOf(32) != -1 || key.indexOf(46) != -1;
        return needsQuotes ? parentPath + "['" + key + "']" : parentPath + '.' + key;
    }

    public static DocumentContext emptyJsonObject() {
        return JsonUtils.toJsonDoc(new LinkedHashMap());
    }

    public static DocumentContext emptyJsonArray(int length) {
        ArrayList list = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            list.add(new LinkedHashMap());
        }
        return JsonUtils.toJsonDoc(list);
    }

    static {
        JSONValue.registerWriter(ScriptObjectMirror.class, (JsonWriterI)new NashornObjectJsonWriter());
        JSONValue.registerWriter(FeatureWrapper.class, (JsonWriterI)new FeatureWrapperJsonWriter());
    }

    private static class FeatureWrapperJsonWriter
    implements JsonWriterI<FeatureWrapper> {
        private FeatureWrapperJsonWriter() {
        }

        public <E extends FeatureWrapper> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            JsonWriter.toStringWriter.writeJSONString((Object)"\"#feature\"", out, compression);
        }
    }

    private static class NashornObjectJsonWriter
    implements JsonWriterI<ScriptObjectMirror> {
        private NashornObjectJsonWriter() {
        }

        public <E extends ScriptObjectMirror> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            if (value.isArray()) {
                Object[] array = value.values().toArray();
                JsonWriter.arrayWriter.writeJSONString((Object)array, out, compression);
            } else if (value.isFunction()) {
                JsonWriter.toStringWriter.writeJSONString((Object)"\"#function\"", out, compression);
            } else {
                JsonWriter.JSONMapWriter.writeJSONString(value, out, compression);
            }
        }
    }
}

