/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class StringUtils {
    private static final String EMPTY = "";

    private StringUtils() {
    }

    public static Pair pair(String left, String right) {
        return new Pair(left, right);
    }

    public static String trimToEmpty(String s) {
        if (s == null) {
            return EMPTY;
        }
        return s.trim();
    }

    public static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        String temp = StringUtils.trimToEmpty(s);
        return EMPTY.equals(temp) ? null : temp;
    }

    public static String repeat(char c, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String join(Object[] a, char delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            sb.append(a[i]);
            if (i == a.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(Collection<String> c, char delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = c.iterator();
        while (iterator.hasNext()) {
            sb.append((Object)iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static List<String> split(String s, char delimiter) {
        String temp;
        int pos = s.indexOf(delimiter);
        if (pos == -1) {
            return Collections.singletonList(s);
        }
        ArrayList<String> list = new ArrayList<String>();
        int startPos = 0;
        while (pos != -1) {
            temp = s.substring(startPos, pos);
            if (!EMPTY.equals(temp)) {
                list.add(temp);
            }
            startPos = pos + 1;
            pos = s.indexOf(delimiter, startPos);
        }
        if (startPos != s.length() && !EMPTY.equals(temp = s.substring(startPos))) {
            list.add(temp);
        }
        return list;
    }

    public static boolean isBlank(String s) {
        return StringUtils.trimToNull(s) == null;
    }

    public static class Pair {
        public final String left;
        public final String right;

        public Pair(String left, String right) {
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object obj) {
            Pair o = (Pair)obj;
            return this.left.equals(o.left) && this.right.equals(o.right);
        }
    }
}

