/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.convert;

import com.intuit.karate.StringUtils;
import java.util.Map;

public class FeatureBuilder {
    private String name;
    private String url;
    private String method;
    private String headers;
    private String body;
    private final String SCENARIO_TEMPLATE = "Scenario: %sGiven url %s%s%sWhen method %s" + System.lineSeparator();

    public FeatureBuilder addName(String name) {
        this.name = name != null ? name + System.lineSeparator() : "";
        return this;
    }

    public FeatureBuilder addUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Url is null");
        }
        this.url = "'" + url + "'" + System.lineSeparator();
        return this;
    }

    public FeatureBuilder addMethod(String method) {
        if (this.url == null) {
            throw new IllegalArgumentException("Method is null");
        }
        this.method = method + System.lineSeparator();
        return this;
    }

    public FeatureBuilder addHeaders(Map<String, String> headers) {
        this.headers = "";
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers = this.headers + "And header " + entry.getKey() + " = '" + entry.getValue() + "'" + System.lineSeparator();
        }
        return this;
    }

    public FeatureBuilder addBody(String body) {
        this.body = body != null ? "And request " + body + System.lineSeparator() : "";
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public String build() {
        if ("POST".equals(this.method) && StringUtils.isBlank(this.body)) {
            throw new IllegalArgumentException("Body can't be null if method is POST");
        }
        return String.format(this.SCENARIO_TEMPLATE, this.name, this.url, this.headers, this.body, this.method);
    }
}

