/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import java.util.ArrayList;
import java.util.List;

public class KarateStats {
    private int testCount;
    private int failCount;
    private int skipCount;
    private double timeTaken;
    private final long startTime;
    private long endTime;
    private List<String> failedList;
    private Throwable failureReason;

    private KarateStats(long startTime) {
        this.startTime = startTime;
    }

    public void addToFailedList(String name) {
        if (this.failedList == null) {
            this.failedList = new ArrayList<String>();
        }
        this.failedList.add(name);
    }

    public static KarateStats startTimer() {
        return new KarateStats(System.currentTimeMillis());
    }

    public void setFailureReason(Throwable failureReason) {
        this.failureReason = failureReason;
    }

    public Throwable getFailureReason() {
        return this.failureReason;
    }

    public void addToTestCount(int count) {
        this.testCount += count;
    }

    public void addToFailCount(int count) {
        this.failCount += count;
    }

    public void addToSkipCount(int count) {
        this.skipCount += count;
    }

    public void addToTimeTaken(double time) {
        this.timeTaken += time;
    }

    public void stopTimer() {
        this.endTime = System.currentTimeMillis();
    }

    public void printStats(int threadCount) {
        double elapsedTime = this.endTime - this.startTime;
        System.out.println("=========================================================");
        System.out.println(String.format("elapsed time: %f | test time: %f", elapsedTime / 1000.0, this.timeTaken));
        double efficiency = 1000.0 * this.timeTaken / (elapsedTime * (double)threadCount);
        System.out.println(String.format("thread count: %2d | parallel efficiency: %f", threadCount, efficiency));
        System.out.println(String.format("scenarios: %3d | failed: %3d | skipped: %3d", this.testCount, this.failCount, this.skipCount));
        System.out.println("=========================================================");
        if (this.failedList != null) {
            System.out.println("failed: " + this.failedList);
        }
        if (this.failureReason != null) {
            System.out.println("*** runner exception stack trace ***");
            this.failureReason.printStackTrace();
        }
    }

    public int getTestCount() {
        return this.testCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public double getTimeTaken() {
        return this.timeTaken;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public List<String> getFailedList() {
        return this.failedList;
    }
}

