/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit4;

import com.intuit.karate.CallContext;
import com.intuit.karate.Results;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureExecutionUnit;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.PerfEvent;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.ScenarioExecutionUnit;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.http.HttpRequestBuilder;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class FeatureInfo
implements ExecutionHook {
    public final Feature feature;
    public final ExecutionContext exec;
    public final Description description;
    public final FeatureExecutionUnit unit;
    private RunNotifier notifier;

    public void setNotifier(RunNotifier notifier) {
        this.notifier = notifier;
    }

    public static Description getScenarioDescription(Scenario scenario) {
        return Description.createTestDescription((String)scenario.getFeature().getNameForReport(), (String)scenario.getNameForReport(), (Annotation[])new Annotation[0]);
    }

    public FeatureInfo(Feature feature, String tagSelector) {
        this.feature = feature;
        this.description = Description.createSuiteDescription((String)feature.getNameForReport(), (Serializable)((Object)feature.getResource().getPackageQualifiedName()), (Annotation[])new Annotation[0]);
        FeatureContext featureContext = new FeatureContext(null, feature, tagSelector);
        CallContext callContext = new CallContext(null, true, new ExecutionHook[]{this});
        this.exec = new ExecutionContext(null, System.currentTimeMillis(), featureContext, callContext, null, null, null);
        this.unit = new FeatureExecutionUnit(this.exec);
        this.unit.init();
        for (ScenarioExecutionUnit u : this.unit.getScenarioExecutionUnits()) {
            Description scenarioDescription = FeatureInfo.getScenarioDescription(u.scenario);
            this.description.addChild(scenarioDescription);
        }
    }

    public boolean beforeScenario(Scenario scenario, ScenarioContext context) {
        if (this.notifier == null || context.callDepth > 0) {
            return true;
        }
        this.notifier.fireTestStarted(FeatureInfo.getScenarioDescription(scenario));
        return true;
    }

    public void afterScenario(ScenarioResult result, ScenarioContext context) {
        if (this.notifier == null || context.callDepth > 0) {
            return;
        }
        Description scenarioDescription = FeatureInfo.getScenarioDescription(result.getScenario());
        if (result.isFailed()) {
            this.notifier.fireTestFailure(new Failure(scenarioDescription, result.getError()));
        }
        this.notifier.fireTestFinished(scenarioDescription);
    }

    public boolean beforeFeature(Feature feature, ExecutionContext context) {
        return true;
    }

    public void afterFeature(FeatureResult result, ExecutionContext context) {
    }

    public void beforeAll(Results results) {
    }

    public void afterAll(Results results) {
    }

    public boolean beforeStep(Step step, ScenarioContext context) {
        return true;
    }

    public void afterStep(StepResult result, ScenarioContext context) {
    }

    public String getPerfEventName(HttpRequestBuilder req, ScenarioContext context) {
        return null;
    }

    public void reportPerfEvent(PerfEvent event) {
    }
}

