/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.xfdf;

import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

final class XfdfObjectUtils {
    private XfdfObjectUtils() {
    }

    static Rectangle convertRectFromString(String rectString) {
        String delims = ",";
        StringTokenizer st = new StringTokenizer(rectString, delims);
        ArrayList<String> coordsList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            coordsList.add(st.nextToken());
        }
        if (coordsList.size() == 2) {
            return new Rectangle(Float.parseFloat((String)coordsList.get(0)), Float.parseFloat((String)coordsList.get(1)));
        }
        if (coordsList.size() == 4) {
            float xLeft = Float.parseFloat((String)coordsList.get(0));
            float yBottom = Float.parseFloat((String)coordsList.get(1));
            float width = Float.parseFloat((String)coordsList.get(2)) - xLeft;
            float height = Float.parseFloat((String)coordsList.get(3)) - yBottom;
            return new Rectangle(xLeft, yBottom, width, height);
        }
        return null;
    }

    static PdfArray convertFringeFromString(String fringeString) {
        String[] fringeList = fringeString.split(",");
        float[] fringe = new float[4];
        if (fringeList.length == 4) {
            for (int i = 0; i < 4; ++i) {
                fringe[i] = Float.parseFloat(fringeList[i]);
            }
        }
        return new PdfArray(fringe);
    }

    static PdfArray convertDashesFromString(String dashesString) {
        String[] dashesList = dashesString.split(",");
        float[] dashes = new float[dashesList.length];
        for (int i = 0; i < dashesList.length; ++i) {
            dashes[i] = Float.parseFloat(dashesList[i]);
        }
        return new PdfArray(dashes);
    }

    static PdfString convertDashesFromArray(PdfArray dashesArray) {
        if (dashesArray == null) {
            return null;
        }
        String delims = ",";
        StringBuilder dashes = new StringBuilder();
        for (int i = 0; i < dashesArray.size() - 1; ++i) {
            dashes.append(XfdfObjectUtils.convertFloatToString(((PdfNumber)dashesArray.get(i)).floatValue())).append(delims);
        }
        dashes.append(XfdfObjectUtils.convertFloatToString(((PdfNumber)dashesArray.get(dashesArray.size() - 1)).floatValue()));
        return new PdfString(dashes.toString());
    }

    static int convertJustificationFromStringToInteger(String attributeValue) {
        if ("centered".equalsIgnoreCase(attributeValue)) {
            return 1;
        }
        if ("right".equalsIgnoreCase(attributeValue)) {
            return 2;
        }
        return 0;
    }

    static String convertJustificationFromIntegerToString(int justification) {
        if (1 == justification) {
            return "centered";
        }
        if (2 == justification) {
            return "right";
        }
        return "left";
    }

    static PdfName getHighlightFullValue(PdfName highlightMode) {
        if (highlightMode == null) {
            return null;
        }
        switch (highlightMode.toString().substring(1)) {
            case "N": {
                return new PdfName("None");
            }
            case "I": {
                return new PdfName("Invert");
            }
            case "O": {
                return new PdfName("Outline");
            }
            case "P": {
                return new PdfName("Push");
            }
        }
        return null;
    }

    static PdfName getStyleFullValue(PdfName style) {
        if (style == null) {
            return null;
        }
        switch (style.toString().substring(1)) {
            case "S": {
                return new PdfName("solid");
            }
            case "D": {
                return new PdfName("dash");
            }
            case "B": {
                return new PdfName("bevelled");
            }
            case "I": {
                return new PdfName("inset");
            }
            case "U": {
                return new PdfName("underline");
            }
            case "C": {
                return new PdfName("cloudy");
            }
        }
        return null;
    }

    static String convertRectToString(Rectangle rect) {
        return XfdfObjectUtils.convertFloatToString(rect.getX()) + ", " + XfdfObjectUtils.convertFloatToString(rect.getY()) + ", " + XfdfObjectUtils.convertFloatToString(rect.getX() + rect.getWidth()) + ", " + XfdfObjectUtils.convertFloatToString(rect.getY() + rect.getHeight());
    }

    static String convertFloatToString(float coord) {
        return new String(ByteUtils.getIsoBytes((double)coord), StandardCharsets.UTF_8);
    }

    static float[] convertQuadPointsFromCoordsString(String coordsString) {
        String delims = ",";
        StringTokenizer st = new StringTokenizer(coordsString, delims);
        ArrayList<String> quadPointsList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            quadPointsList.add(st.nextToken());
        }
        if (quadPointsList.size() % 8 == 0) {
            float[] quadPoints = new float[quadPointsList.size()];
            for (int i = 0; i < quadPointsList.size(); ++i) {
                quadPoints[i] = Float.parseFloat((String)quadPointsList.get(i));
            }
            return quadPoints;
        }
        return new float[0];
    }

    static String convertQuadPointsToCoordsString(float[] quadPoints) {
        StringBuilder stb = new StringBuilder(XfdfObjectUtils.convertFloatToString(quadPoints[0]));
        for (int i = 1; i < quadPoints.length; ++i) {
            stb.append(", ").append(XfdfObjectUtils.convertFloatToString(quadPoints[i]));
        }
        return stb.toString();
    }

    static int convertFlagsFromString(String flagsString) {
        int result = 0;
        String delims = ",";
        StringTokenizer st = new StringTokenizer(flagsString, delims);
        ArrayList<String> flagsList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            flagsList.add(st.nextToken().toLowerCase());
        }
        HashMap<String, Integer> flagMap = new HashMap<String, Integer>();
        flagMap.put("invisible", 1);
        flagMap.put("hidden", 2);
        flagMap.put("print", 4);
        flagMap.put("nozoom", 8);
        flagMap.put("norotate", 16);
        flagMap.put("noview", 32);
        flagMap.put("readonly", 64);
        flagMap.put("locked", 128);
        flagMap.put("togglenoview", 256);
        for (String flag : flagsList) {
            if (!flagMap.containsKey(flag)) continue;
            result += ((Integer)flagMap.get(flag)).intValue();
        }
        return result;
    }

    static String convertFlagsToString(PdfAnnotation pdfAnnotation) {
        ArrayList<String> flagsList = new ArrayList<String>();
        StringBuilder stb = new StringBuilder();
        if (pdfAnnotation.hasFlag(1)) {
            flagsList.add("invisible");
        }
        if (pdfAnnotation.hasFlag(2)) {
            flagsList.add("hidden");
        }
        if (pdfAnnotation.hasFlag(4)) {
            flagsList.add("print");
        }
        if (pdfAnnotation.hasFlag(8)) {
            flagsList.add("nozoom");
        }
        if (pdfAnnotation.hasFlag(16)) {
            flagsList.add("norotate");
        }
        if (pdfAnnotation.hasFlag(32)) {
            flagsList.add("noview");
        }
        if (pdfAnnotation.hasFlag(64)) {
            flagsList.add("readonly");
        }
        if (pdfAnnotation.hasFlag(128)) {
            flagsList.add("locked");
        }
        if (pdfAnnotation.hasFlag(256)) {
            flagsList.add("togglenoview");
        }
        for (String flag : flagsList) {
            stb.append(flag).append(",");
        }
        String result = stb.toString();
        return result.length() > 0 ? result.substring(0, result.length() - 1) : null;
    }

    static String convertColorToString(float[] colors) {
        if (colors.length == 3) {
            return "#" + XfdfObjectUtils.convertColorFloatToHex(colors[0]) + XfdfObjectUtils.convertColorFloatToHex(colors[1]) + XfdfObjectUtils.convertColorFloatToHex(colors[2]);
        }
        return null;
    }

    static String convertColorToString(Color color) {
        float[] colors = color.getColorValue();
        if (colors != null && colors.length == 3) {
            return "#" + XfdfObjectUtils.convertColorFloatToHex(colors[0]) + XfdfObjectUtils.convertColorFloatToHex(colors[1]) + XfdfObjectUtils.convertColorFloatToHex(colors[2]);
        }
        return null;
    }

    private static String convertColorFloatToHex(float colorFloat) {
        String result = "0" + Integer.toHexString((int)((double)(colorFloat * 255.0f) + 0.5)).toUpperCase();
        return result.substring(result.length() - 2);
    }

    static String convertIdToHexString(String idString) {
        char[] stringSymbols;
        StringBuilder stb = new StringBuilder();
        for (char ch : stringSymbols = idString.toCharArray()) {
            stb.append(Integer.toHexString(ch).toUpperCase());
        }
        return stb.toString();
    }

    static Color convertColorFromString(String hexColor) {
        return Color.makeColor((PdfColorSpace)new PdfDeviceCs.Rgb(), (float[])XfdfObjectUtils.convertColorFloatsFromString(hexColor));
    }

    static float[] convertColorFloatsFromString(String colorHexString) {
        float[] result = new float[3];
        String colorString = colorHexString.substring(colorHexString.indexOf(35) + 1);
        if (colorString.length() == 6) {
            for (int i = 0; i < 3; ++i) {
                result[i] = (float)Integer.parseInt(colorString.substring(i * 2, 2 + i * 2), 16) / 255.0f;
            }
        }
        return result;
    }

    static String convertVerticesToString(float[] vertices) {
        if (vertices.length <= 0) {
            return null;
        }
        StringBuilder stb = new StringBuilder();
        stb.append(XfdfObjectUtils.convertFloatToString(vertices[0]));
        for (int i = 1; i < vertices.length; ++i) {
            stb.append(", ").append(XfdfObjectUtils.convertFloatToString(vertices[i]));
        }
        return stb.toString();
    }

    static String convertFringeToString(float[] fringeArray) {
        if (fringeArray.length != 4) {
            return null;
        }
        StringBuilder stb = new StringBuilder();
        stb.append(XfdfObjectUtils.convertFloatToString(fringeArray[0]));
        for (int i = 1; i < 4; ++i) {
            stb.append(", ").append(XfdfObjectUtils.convertFloatToString(fringeArray[i]));
        }
        return stb.toString();
    }

    static float[] convertVerticesFromString(String verticesString) {
        String delims = ",;";
        StringTokenizer st = new StringTokenizer(verticesString, delims);
        ArrayList<String> verticesList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            verticesList.add(st.nextToken());
        }
        float[] vertices = new float[verticesList.size()];
        for (int i = 0; i < verticesList.size(); ++i) {
            vertices[i] = Float.parseFloat((String)verticesList.get(i));
        }
        return vertices;
    }

    static String convertLineStartToString(float[] line) {
        if (line.length == 4) {
            return XfdfObjectUtils.convertFloatToString(line[0]) + "," + XfdfObjectUtils.convertFloatToString(line[1]);
        }
        return null;
    }

    static String convertLineEndToString(float[] line) {
        if (line.length == 4) {
            return XfdfObjectUtils.convertFloatToString(line[2]) + "," + XfdfObjectUtils.convertFloatToString(line[3]);
        }
        return null;
    }
}

