/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl;

import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.attach.IHtmlProcessor;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.FontFace;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlDocumentRenderer;
import com.itextpdf.html2pdf.attach.impl.layout.RunningElementContainer;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.IPlaceholderable;
import com.itextpdf.html2pdf.attach.impl.tags.HtmlTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.RunningElementTagWorker;
import com.itextpdf.html2pdf.attach.util.LinkHelper;
import com.itextpdf.html2pdf.css.apply.ICssApplier;
import com.itextpdf.html2pdf.css.apply.util.PageBreakApplierUtil;
import com.itextpdf.html2pdf.css.resolve.DefaultCssResolver;
import com.itextpdf.html2pdf.events.PdfHtmlEvent;
import com.itextpdf.html2pdf.exception.Html2PdfException;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.Version;
import com.itextpdf.kernel.counter.EventCounterHandler;
import com.itextpdf.kernel.counter.event.IEvent;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.font.FontFamilySplitter;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.Range;
import com.itextpdf.layout.property.RenderingMode;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.CssFontFaceRule;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.css.pseudo.CssPseudoElementNode;
import com.itextpdf.styledxmlparser.css.pseudo.CssPseudoElementUtil;
import com.itextpdf.styledxmlparser.css.resolve.AbstractCssContext;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import com.itextpdf.styledxmlparser.node.ITextNode;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHtmlProcessor
implements IHtmlProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHtmlProcessor.class);
    private static final Set<String> ignoredTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("head", "style", "tbody")));
    private static final Set<String> ignoredCssTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("br", "link", "meta", "title", "tr")));
    private static final Set<String> ignoredChildTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("body", "link", "meta", "script", "title")));
    private ProcessorContext context;
    private List<IPropertyContainer> roots;
    private ICssResolver cssResolver;

    public DefaultHtmlProcessor(ConverterProperties converterProperties) {
        this.context = new ProcessorContext(converterProperties);
    }

    public static void setConvertedRootElementProperties(Map<String, String> cssProperties, ProcessorContext context, IPropertyContainer propertyContainer) {
        List fontFamilies;
        propertyContainer.setProperty(89, (Object)true);
        propertyContainer.setProperty(123, (Object)RenderingMode.HTML_MODE);
        propertyContainer.setProperty(91, (Object)context.getFontProvider());
        if (context.getTempFonts() != null) {
            propertyContainer.setProperty(98, (Object)context.getTempFonts());
        }
        if ((fontFamilies = FontFamilySplitter.splitFontFamily((String)cssProperties.get("font-family"))) != null && !propertyContainer.hasOwnProperty(20)) {
            propertyContainer.setProperty(20, (Object)fontFamilies.toArray(new String[0]));
        }
    }

    @Override
    public List<IElement> processElements(INode root) {
        block3: {
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfHtml", 3, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block3;
                throw new RuntimeException(e.getCause());
            }
        }
        this.context.reset();
        this.roots = new ArrayList<IPropertyContainer>();
        this.cssResolver = new DefaultCssResolver(root, this.context);
        this.context.getLinkContext().scanForIds(root);
        this.addFontFaceFonts();
        IElementNode html = this.findHtmlNode(root);
        IElementNode body = this.findBodyNode(root);
        html.setStyles(this.cssResolver.resolveStyles((INode)html, (AbstractCssContext)this.context.getCssContext()));
        this.visit((INode)body);
        Div bodyDiv = (Div)this.roots.get(0);
        ArrayList<IElement> elements = new ArrayList<IElement>();
        body.setStyles(this.cssResolver.resolveStyles((INode)body, (AbstractCssContext)this.context.getCssContext()));
        for (IPropertyContainer propertyContainer : bodyDiv.getChildren()) {
            if (!(propertyContainer instanceof IElement)) continue;
            DefaultHtmlProcessor.setConvertedRootElementProperties(body.getStyles(), this.context, propertyContainer);
            elements.add((IElement)propertyContainer);
        }
        this.cssResolver = null;
        this.roots = null;
        EventCounterHandler.getInstance().onEvent((IEvent)PdfHtmlEvent.CONVERT, this.context.getEventCountingMetaInfo(), this.getClass());
        return elements;
    }

    @Override
    public Document processDocument(INode root, PdfDocument pdfDocument) {
        block4: {
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfHtml", 3, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block4;
                throw new RuntimeException(e.getCause());
            }
        }
        this.context.reset(pdfDocument);
        if (!this.context.hasFonts()) {
            throw new Html2PdfException("Font Provider contains zero fonts. At least one font shall be present");
        }
        this.roots = new ArrayList<IPropertyContainer>();
        this.cssResolver = new DefaultCssResolver(root, this.context);
        this.context.getLinkContext().scanForIds(root);
        this.addFontFaceFonts();
        root = this.findHtmlNode(root);
        this.visit(root);
        Document doc = (Document)this.roots.get(0);
        if (this.context.getCssContext().isPagesCounterPresent() && doc.getRenderer() instanceof HtmlDocumentRenderer) {
            doc.relayout();
        }
        this.cssResolver = null;
        this.roots = null;
        EventCounterHandler.getInstance().onEvent((IEvent)PdfHtmlEvent.CONVERT, this.context.getEventCountingMetaInfo(), this.getClass());
        return doc;
    }

    private void visit(INode node) {
        String content;
        if (node instanceof IElementNode) {
            IElementNode element = (IElementNode)node;
            element.setStyles(this.cssResolver.resolveStyles((INode)element, (AbstractCssContext)this.context.getCssContext()));
            if (!this.isDisplayable(element)) {
                return;
            }
            ITagWorker tagWorker = this.context.getTagWorkerFactory().getTagWorker(element, this.context);
            if (tagWorker == null) {
                if (!ignoredTags.contains(element.name())) {
                    logger.error(MessageFormatUtil.format((String)"No worker found for tag {0}", (Object[])new Object[]{element.name()}));
                }
            } else {
                this.context.getState().push(tagWorker);
            }
            if (tagWorker instanceof HtmlTagWorker) {
                ((HtmlTagWorker)tagWorker).processPageRules(node, this.cssResolver, this.context);
            }
            if ("body".equals(element.name()) || "html".equals(element.name())) {
                this.runApplier(element, tagWorker);
            }
            this.context.getOutlineHandler().addOutlineAndDestToDocument(tagWorker, element, this.context);
            this.visitPseudoElement(element, tagWorker, "before");
            this.visitPseudoElement(element, tagWorker, "placeholder");
            for (INode childNode : element.childNodes()) {
                if (this.context.isProcessingInlineSvg()) continue;
                this.visit(childNode);
            }
            this.visitPseudoElement(element, tagWorker, "after");
            if (tagWorker != null) {
                tagWorker.processEnd(element, this.context);
                LinkHelper.createDestination(tagWorker, element, this.context);
                this.context.getOutlineHandler().setDestinationToElement(tagWorker, element);
                this.context.getState().pop();
                if (!"body".equals(element.name()) && !"html".equals(element.name())) {
                    this.runApplier(element, tagWorker);
                }
                if (!this.context.getState().empty()) {
                    PageBreakApplierUtil.addPageBreakElementBefore(this.context, this.context.getState().top(), element, tagWorker);
                    tagWorker = this.processRunningElement(tagWorker, element, this.context);
                    boolean childProcessed = this.context.getState().top().processTagChild(tagWorker, this.context);
                    PageBreakApplierUtil.addPageBreakElementAfter(this.context, this.context.getState().top(), element, tagWorker);
                    if (!childProcessed && !ignoredChildTags.contains(element.name())) {
                        logger.error(MessageFormatUtil.format((String)"Worker of type {0} unable to process {1}", (Object[])new Object[]{this.context.getState().top().getClass().getName(), tagWorker.getClass().getName()}));
                    }
                } else if (tagWorker.getElementResult() != null) {
                    this.roots.add(tagWorker.getElementResult());
                }
            }
            element.setStyles(null);
        } else if (node instanceof ITextNode && (content = ((ITextNode)node).wholeText()) != null) {
            if (!this.context.getState().empty()) {
                boolean contentProcessed = this.context.getState().top().processContent(content, this.context);
                if (!contentProcessed) {
                    logger.error(MessageFormatUtil.format((String)"Worker of type {0} unable to process it`s text content", (Object[])new Object[]{this.context.getState().top().getClass().getName()}));
                }
            } else {
                logger.error("No consumer found for content");
            }
        }
    }

    private void runApplier(IElementNode element, ITagWorker tagWorker) {
        ICssApplier cssApplier = this.context.getCssApplierFactory().getCssApplier(element);
        if (cssApplier == null) {
            if (!ignoredCssTags.contains(element.name())) {
                logger.error(MessageFormatUtil.format((String)"No css applier found for tag {0}", (Object[])new Object[]{element.name()}));
            }
        } else {
            cssApplier.apply(this.context, (IStylesContainer)element, tagWorker);
        }
    }

    private ITagWorker processRunningElement(ITagWorker tagWorker, IElementNode element, ProcessorContext context) {
        int endBracketInd;
        String positionVal;
        String runningPrefix = "running(";
        if (element.getStyles() == null || (positionVal = (String)element.getStyles().get("position")) == null || !positionVal.startsWith(runningPrefix) || (endBracketInd = positionVal.indexOf(")")) <= runningPrefix.length()) {
            return tagWorker;
        }
        String runningElemName = positionVal.substring(runningPrefix.length(), endBracketInd).trim();
        if (runningElemName.isEmpty()) {
            return tagWorker;
        }
        RunningElementContainer runningElementContainer = new RunningElementContainer(element, tagWorker);
        context.getCssContext().getRunningManager().addRunningElement(runningElemName, runningElementContainer);
        return new RunningElementTagWorker(runningElementContainer);
    }

    private void addFontFaceFonts() {
        if (this.cssResolver instanceof DefaultCssResolver) {
            for (CssFontFaceRule fontFace : ((DefaultCssResolver)this.cssResolver).getFonts()) {
                boolean findSupportedSrc = false;
                List declarations = fontFace.getProperties();
                FontFace ff = FontFace.create(declarations);
                if (ff != null) {
                    for (FontFace.FontFaceSrc src : ff.getSources()) {
                        if (!this.createFont(ff.getFontFamily(), src, this.resolveUnicodeRange(declarations))) continue;
                        findSupportedSrc = true;
                        break;
                    }
                }
                if (findSupportedSrc) continue;
                logger.error(MessageFormatUtil.format((String)"Unable to retrieve font:\n {0}", (Object[])new Object[]{fontFace}));
            }
        }
    }

    private Range resolveUnicodeRange(List<CssDeclaration> declarations) {
        Range range = null;
        for (CssDeclaration descriptor : declarations) {
            if (!"unicode-range".equals(descriptor.getProperty())) continue;
            range = CssUtils.parseUnicodeRange((String)descriptor.getExpression());
        }
        return range;
    }

    private boolean createFont(String fontFamily, FontFace.FontFaceSrc src, Range unicodeRange) {
        if (!this.supportedFontFormat(src.format)) {
            return false;
        }
        if (src.isLocal) {
            Collection fonts = this.context.getFontProvider().getFontSet().get(src.src);
            if (fonts.size() > 0) {
                for (FontInfo fi : fonts) {
                    this.context.addTemporaryFont(fi, fontFamily);
                }
                return true;
            }
            return false;
        }
        try {
            byte[] bytes = this.context.getResourceResolver().retrieveBytesFromResource(src.src);
            if (bytes != null) {
                FontProgram fp = FontProgramFactory.createFont((byte[])bytes, (boolean)false);
                this.context.addTemporaryFont(fp, "Identity-H", fontFamily, unicodeRange);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean supportedFontFormat(FontFace.FontFormat format) {
        switch (format) {
            case None: 
            case TrueType: 
            case OpenType: 
            case WOFF: 
            case WOFF2: {
                return true;
            }
        }
        return false;
    }

    private void visitPseudoElement(IElementNode node, ITagWorker tagWorker, String pseudoElementName) {
        switch (pseudoElementName) {
            case "before": 
            case "after": {
                if (CssPseudoElementUtil.hasBeforeAfterElements((IElementNode)node)) break;
                return;
            }
            case "placeholder": {
                if (("input".equals(node.name()) || "textarea".equals(node.name())) && null != tagWorker && tagWorker.getElementResult() instanceof IPlaceholderable && null != ((IPlaceholderable)tagWorker.getElementResult()).getPlaceholder()) break;
                return;
            }
            default: {
                return;
            }
        }
        this.visit((INode)new CssPseudoElementNode((INode)node, pseudoElementName));
    }

    private IElementNode findElement(INode node, String tagName) {
        LinkedList<INode> q = new LinkedList<INode>();
        q.add(node);
        while (!q.isEmpty()) {
            INode currentNode = (INode)q.getFirst();
            q.removeFirst();
            if (currentNode instanceof IElementNode && ((IElementNode)currentNode).name().equals(tagName)) {
                return (IElementNode)currentNode;
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode)) continue;
                q.add(child);
            }
        }
        return null;
    }

    private IElementNode findHtmlNode(INode node) {
        return this.findElement(node, "html");
    }

    private IElementNode findBodyNode(INode node) {
        return this.findElement(node, "body");
    }

    private boolean isDisplayable(IElementNode element) {
        if (element != null && element.getStyles() != null && "none".equals(element.getStyles().get("display"))) {
            return false;
        }
        if (this.isPlaceholder(element)) {
            return true;
        }
        if (element instanceof CssPseudoElementNode) {
            if (element.childNodes().isEmpty()) {
                return false;
            }
            boolean hasStyles = element.getStyles() != null;
            String positionVal = hasStyles ? (String)element.getStyles().get("position") : null;
            String displayVal = hasStyles ? (String)element.getStyles().get("display") : null;
            boolean containsNonEmptyChildNode = false;
            boolean containsElementNode = false;
            for (int i = 0; i < element.childNodes().size(); ++i) {
                if (element.childNodes().get(i) instanceof ITextNode) {
                    containsNonEmptyChildNode = true;
                    break;
                }
                if (!(element.childNodes().get(i) instanceof IElementNode)) continue;
                containsElementNode = true;
            }
            return containsElementNode || containsNonEmptyChildNode || "absolute".equals(positionVal) || "fixed".equals(positionVal) || displayVal != null && !"inline".equals(displayVal);
        }
        return element != null;
    }

    private boolean isPlaceholder(IElementNode element) {
        return element instanceof CssPseudoElementNode && "placeholder".equals(((CssPseudoElementNode)element).getPseudoElementName());
    }
}

