/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.impl.layout.HtmlDocumentRenderer;
import com.itextpdf.html2pdf.attach.impl.layout.PageCountElement;
import com.itextpdf.html2pdf.attach.impl.layout.PageCountType;
import com.itextpdf.html2pdf.css.resolve.func.counter.CounterDigitsGlyphStyle;
import com.itextpdf.html2pdf.html.HtmlUtils;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import java.util.ArrayList;
import java.util.List;

class PageCountRenderer
extends TextRenderer {
    private final CounterDigitsGlyphStyle digitsGlyphStyle;

    PageCountRenderer(PageCountElement textElement) {
        super((Text)textElement);
        this.digitsGlyphStyle = textElement.getDigitsGlyphStyle();
    }

    public LayoutResult layout(LayoutContext layoutContext) {
        PageCountType pageCountType = (PageCountType)((Object)this.getProperty(0x100002));
        String previousText = this.getText().toString();
        boolean textHasBeenReplaced = false;
        if (pageCountType == PageCountType.CURRENT_PAGE_NUMBER) {
            this.setText(HtmlUtils.convertNumberAccordingToGlyphStyle(this.digitsGlyphStyle, layoutContext.getArea().getPageNumber()));
            textHasBeenReplaced = true;
        } else if (pageCountType == PageCountType.TOTAL_PAGE_COUNT) {
            PageCountRenderer rootRenderer = this;
            while (rootRenderer instanceof AbstractRenderer && ((AbstractRenderer)rootRenderer).getParent() != null) {
                rootRenderer = ((AbstractRenderer)rootRenderer).getParent();
            }
            if (rootRenderer instanceof HtmlDocumentRenderer && ((HtmlDocumentRenderer)((Object)rootRenderer)).getEstimatedNumberOfPages() > 0) {
                this.setText(HtmlUtils.convertNumberAccordingToGlyphStyle(this.digitsGlyphStyle, ((HtmlDocumentRenderer)((Object)rootRenderer)).getEstimatedNumberOfPages()));
                textHasBeenReplaced = true;
            } else if (rootRenderer instanceof DocumentRenderer && rootRenderer.getModelElement() instanceof Document) {
                this.setText(HtmlUtils.convertNumberAccordingToGlyphStyle(this.digitsGlyphStyle, ((Document)rootRenderer.getModelElement()).getPdfDocument().getNumberOfPages()));
                textHasBeenReplaced = true;
            }
        }
        LayoutResult result = super.layout(layoutContext);
        if (textHasBeenReplaced) {
            this.setText(previousText);
        }
        return result;
    }

    protected boolean resolveFonts(List<IRenderer> addTo) {
        ArrayList dummyList = new ArrayList();
        super.resolveFonts(dummyList);
        this.setProperty(20, ((IRenderer)dummyList.get(0)).getProperty(20));
        addTo.add((IRenderer)this);
        return true;
    }
}

