/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.RunningElement;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.LinkHelper;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.Transform;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.resolver.resource.UriResolver;
import java.net.MalformedURLException;

public class ATagWorker
extends SpanTagWorker {
    public ATagWorker(IElementNode element, ProcessorContext context) {
        super(element, context);
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        super.processEnd(element, context);
        String url = element.getAttribute("href");
        if (url != null) {
            String base = context.getBaseUri();
            if (base != null) {
                UriResolver uriResolver = new UriResolver(base);
                if (!url.startsWith("#") || !uriResolver.isLocalBaseUri()) {
                    try {
                        String resolvedUri = uriResolver.resolveAgainstBaseUri(url).toExternalForm();
                        if (!url.endsWith("/") && resolvedUri.endsWith("/")) {
                            resolvedUri = resolvedUri.substring(0, resolvedUri.length() - 1);
                        }
                        if (!resolvedUri.startsWith("file:")) {
                            url = resolvedUri;
                        }
                    }
                    catch (MalformedURLException resolvedUri) {
                        // empty catch block
                    }
                }
            }
            for (int i = 0; i < this.getAllElements().size(); ++i) {
                if (this.getAllElements().get(i) instanceof RunningElement) continue;
                if (this.getAllElements().get(i) instanceof IBlockElement) {
                    FloatPropertyValue floatPropVal;
                    Div simulatedDiv = new Div();
                    simulatedDiv.getAccessibilityProperties().setRole("Link");
                    Transform cssTransform = (Transform)this.getAllElements().get(i).getProperty(53);
                    if (cssTransform != null) {
                        this.getAllElements().get(i).deleteOwnProperty(53);
                        simulatedDiv.setProperty(53, (Object)cssTransform);
                    }
                    if ((floatPropVal = (FloatPropertyValue)this.getAllElements().get(i).getProperty(99)) != null) {
                        this.getAllElements().get(i).deleteOwnProperty(99);
                        simulatedDiv.setProperty(99, (Object)floatPropVal);
                    }
                    simulatedDiv.add((IBlockElement)this.getAllElements().get(i));
                    String display = (String)this.childrenDisplayMap.remove(this.getAllElements().get(i));
                    if (display != null) {
                        this.childrenDisplayMap.put(simulatedDiv, display);
                    }
                    this.getAllElements().set(i, (IPropertyContainer)simulatedDiv);
                }
                LinkHelper.applyLinkAnnotation(this.getAllElements().get(i), url);
            }
        }
        if (!this.getAllElements().isEmpty()) {
            String name = element.getAttribute("name");
            IPropertyContainer firstElement = this.getAllElements().get(0);
            firstElement.setProperty(17, (Object)name);
            firstElement.setProperty(126, (Object)name);
        }
    }
}

