/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import com.itextpdf.io.util.CliCommandUtil;
import com.itextpdf.io.util.FileUtil;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.io.util.SystemUtil;
import java.io.IOException;

public class GhostscriptHelper {
    public static final String GHOSTSCRIPT_ENVIRONMENT_VARIABLE = "ITEXT_GS_EXEC";
    @Deprecated
    static final String GHOSTSCRIPT_ENVIRONMENT_VARIABLE_LEGACY = "gsExec";
    static final String GHOSTSCRIPT_KEYWORD = "GPL Ghostscript";
    private static final String GHOSTSCRIPT_PARAMS = " -dSAFER -dNOPAUSE -dBATCH -sDEVICE=png16m -r150 {0} -sOutputFile=\"{1}\" \"{2}\"";
    private String gsExec;

    public GhostscriptHelper() {
        this(null);
    }

    public GhostscriptHelper(String newGsExec) {
        this.gsExec = newGsExec;
        if (this.gsExec == null) {
            this.gsExec = SystemUtil.getPropertyOrEnvironmentVariable(GHOSTSCRIPT_ENVIRONMENT_VARIABLE);
            if (this.gsExec == null) {
                this.gsExec = SystemUtil.getPropertyOrEnvironmentVariable(GHOSTSCRIPT_ENVIRONMENT_VARIABLE_LEGACY);
            }
        }
        if (!CliCommandUtil.isVersionCommandExecutable(this.gsExec, GHOSTSCRIPT_KEYWORD)) {
            throw new IllegalArgumentException("Ghostscript command is not specified or specified incorrectly. Set the ITEXT_GS_EXEC environment variable to a CLI command that can run the Ghostscript application. See BUILDING.MD in the root of the repository for more details.");
        }
    }

    public String getCliExecutionCommand() {
        return this.gsExec;
    }

    public void runGhostScriptImageGeneration(String pdf, String outDir, String image) throws IOException, InterruptedException {
        this.runGhostScriptImageGeneration(pdf, outDir, image, null);
    }

    public void runGhostScriptImageGeneration(String pdf, String outDir, String image, String pageList) throws IOException, InterruptedException {
        if (!FileUtil.directoryExists(outDir)) {
            throw new IllegalArgumentException("Cannot open output directory for <filename>".replace("<filename>", pdf));
        }
        String currGsParams = MessageFormatUtil.format(GHOSTSCRIPT_PARAMS, pageList = pageList == null ? "" : "-sPageList=<pagelist>".replace("<pagelist>", pageList), outDir + image, pdf);
        if (!SystemUtil.runProcessAndWait(this.gsExec, currGsParams)) {
            throw new GhostscriptExecutionException("GhostScript failed for <filename>".replace("<filename>", pdf));
        }
    }

    public static class GhostscriptExecutionException
    extends RuntimeException {
        public GhostscriptExecutionException(String msg) {
            super(msg);
        }
    }
}

