/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.cmap;

import com.itextpdf.io.font.cmap.AbstractCMap;
import com.itextpdf.io.font.cmap.CMapObject;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.util.IntHashtable;
import com.itextpdf.io.util.TextUtil;

public class CMapUniCid
extends AbstractCMap {
    private static final long serialVersionUID = -6111821751136011584L;
    private IntHashtable map = new IntHashtable(65537);

    @Override
    void addChar(String mark, CMapObject code) {
        if (code.isNumber()) {
            String s = this.toUnicodeString(mark, true);
            int codePoint = TextUtil.isSurrogatePair(s, 0) ? TextUtil.convertToUtf32(s, 0) : (int)s.charAt(0);
            this.map.put(codePoint, (Integer)code.getValue());
        }
    }

    public int lookup(int character) {
        return this.map.get(character);
    }

    public CMapToUnicode exportToUnicode() {
        int[] keys;
        CMapToUnicode uni = new CMapToUnicode();
        for (int key : keys = this.map.toOrderedKeys()) {
            uni.addChar(this.map.get(key), TextUtil.convertFromUtf32(key));
        }
        int spaceCid = this.lookup(32);
        if (spaceCid != 0) {
            uni.addChar(spaceCid, TextUtil.convertFromUtf32(32));
        }
        return uni;
    }
}

