/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagutils.ITagTreeIteratorHandler;
import com.itextpdf.kernel.pdf.tagutils.TagTreeIteratorElementApprover;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TagTreeIterator {
    private final IStructureNode pointer;
    private final Set<ITagTreeIteratorHandler> handlerList;
    private final TagTreeIteratorElementApprover approver;
    private final TreeTraversalOrder traversalOrder;

    public TagTreeIterator(IStructureNode tagTreePointer) {
        this(tagTreePointer, new TagTreeIteratorElementApprover(), TreeTraversalOrder.PRE_ORDER);
    }

    public TagTreeIterator(IStructureNode tagTreePointer, TagTreeIteratorElementApprover approver, TreeTraversalOrder traversalOrder) {
        if (tagTreePointer == null) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"{0} should not be null.", (Object[])new Object[]{"tagTreepointer"}));
        }
        if (approver == null) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"{0} should not be null.", (Object[])new Object[]{"approver"}));
        }
        if (traversalOrder == null) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"{0} should not be null.", (Object[])new Object[]{"traversalOrder"}));
        }
        this.pointer = tagTreePointer;
        this.traversalOrder = traversalOrder;
        this.handlerList = new HashSet<ITagTreeIteratorHandler>();
        this.approver = approver;
    }

    public TagTreeIterator addHandler(ITagTreeIteratorHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"{0} should not be null.", (Object[])new Object[]{"handler"}));
        }
        this.handlerList.add(handler);
        return this;
    }

    public void traverse() {
        this.traverse(this.pointer);
    }

    private void traverse(IStructureNode elem) {
        List<IStructureNode> kids;
        if (!this.approver.approve(elem)) {
            return;
        }
        if (this.traversalOrder == TreeTraversalOrder.PRE_ORDER) {
            for (ITagTreeIteratorHandler handler : this.handlerList) {
                handler.nextElement(elem);
            }
        }
        if ((kids = elem.getKids()) != null) {
            for (IStructureNode kid : kids) {
                this.traverse(kid);
            }
        }
        if (this.traversalOrder == TreeTraversalOrder.POST_ORDER) {
            for (ITagTreeIteratorHandler handler : this.handlerList) {
                handler.nextElement(elem);
            }
        }
    }

    public static enum TreeTraversalOrder {
        PRE_ORDER,
        POST_ORDER;

    }
}

